/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTConsumer;
import org.pentaho.di.trans.step.mqtt.MQTTConsumerMeta;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.BlockingQueueStreamSource;

public class MQTTStreamSource
extends BlockingQueueStreamSource<List<Object>> {
    private final MQTTConsumerMeta mqttConsumerMeta;
    private final MQTTConsumer mqttConsumer;
    @VisibleForTesting
    MqttClient mqttClient;
    private MqttCallback callback = new MqttCallback(){

        public void connectionLost(Throwable cause) {
            MQTTStreamSource.this.error(cause);
        }

        public void messageArrived(String topic, MqttMessage message) {
            MQTTStreamSource.this.acceptRows(Collections.singletonList(ImmutableList.of((Object)MQTTStreamSource.this.readBytes(message.getPayload()), (Object)topic)));
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    };

    MQTTStreamSource(MQTTConsumerMeta mqttConsumerMeta, MQTTConsumer mqttConsumer) {
        super((BaseStreamStep)mqttConsumer);
        this.mqttConsumer = mqttConsumer;
        this.mqttConsumerMeta = mqttConsumerMeta;
    }

    public void open() {
        try {
            this.mqttClient = MQTTClientBuilder.builder().withBroker(this.mqttConsumerMeta.getMqttServer()).withTopics(this.mqttConsumerMeta.getTopics()).withQos(this.mqttConsumerMeta.getQos()).withStep(this.mqttConsumer).withCallback(this.callback).withUsername(this.mqttConsumerMeta.getUsername()).withPassword(this.mqttConsumerMeta.getPassword()).withIsSecure(this.mqttConsumerMeta.isUseSsl()).withSslConfig(this.mqttConsumerMeta.getSslConfig()).withKeepAliveInterval(this.mqttConsumerMeta.getKeepAliveInterval()).withMaxInflight(this.mqttConsumerMeta.getMaxInflight()).withConnectionTimeout(this.mqttConsumerMeta.getConnectionTimeout()).withCleanSession(this.mqttConsumerMeta.getCleanSession()).withStorageLevel(this.mqttConsumerMeta.getStorageLevel()).withServerUris(this.mqttConsumerMeta.getServerUris()).withMqttVersion(this.mqttConsumerMeta.getMqttVersion()).withAutomaticReconnect(this.mqttConsumerMeta.getAutomaticReconnect()).buildAndConnect();
        }
        catch (Exception e) {
            this.mqttConsumer.stopAll();
            this.mqttConsumer.logError(e.toString());
        }
    }

    public void close() {
        super.close();
        try {
            if (this.mqttClient != null && this.mqttClient.isConnected()) {
                this.mqttClient.disconnect();
                this.mqttClient.close();
            }
        }
        catch (MqttException e) {
            this.mqttConsumer.logError(e.getMessage());
        }
    }
}

