/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.AbstractMDXDataFactoryWriteHandler;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractNamedMDXDataFactoryWriteHandler
extends AbstractMDXDataFactoryWriteHandler {
    protected AbstractNamedMDXDataFactoryWriteHandler() {
    }

    protected void writeBody(ReportWriterContext reportWriterContext, AbstractNamedMDXDataFactory df, XmlWriter xmlWriter) throws IOException, ReportWriterException {
        super.writeBody(reportWriterContext, df, xmlWriter);
        String globalScript = df.getGlobalScript();
        String globalScriptLanguage = df.getGlobalScriptLanguage();
        if (!StringUtils.isEmpty((String)globalScript) && !StringUtils.isEmpty((String)globalScriptLanguage)) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "global-script", "language", globalScriptLanguage, false);
            xmlWriter.writeTextNormalized(globalScript, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "query-definitions", false);
        String[] queryNames = df.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = df.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "query", "name", queryName, false);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "static-query", false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
            String queryScriptLanguage = df.getScriptingLanguage(queryName);
            String queryScript = df.getScript(queryName);
            if (!(StringUtils.isEmpty((String)queryScript) || StringUtils.isEmpty((String)queryScriptLanguage) && StringUtils.isEmpty((String)globalScriptLanguage))) {
                if (StringUtils.isEmpty((String)queryScriptLanguage)) {
                    xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "script", false);
                } else {
                    xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "script", "language", queryScriptLanguage, false);
                }
                xmlWriter.writeTextNormalized(queryScript, false);
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
    }
}

