/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.bundle.core.BundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.pentaho.osgi.api.BlueprintStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintStateServiceImpl
implements BlueprintStateService,
BlueprintListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintStateServiceImpl.class);
    private final Map<Long, BlueprintEvent> states = new ConcurrentHashMap<Long, BlueprintEvent>();
    private final List<Long> bluePrints = new ArrayList<Long>();
    private final BundleContext bundleContext;

    public BlueprintStateServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Boolean isBlueprintLoaded(long bundleId) {
        return this.hasBlueprint(bundleId) != false && this.getBundleState(bundleId) == BundleState.Active;
    }

    public Boolean isBlueprintFailed(long bundleId) {
        return this.hasBlueprint(bundleId) != false && this.getBundleState(bundleId) == BundleState.Failure;
    }

    public Boolean isBlueprintTryingToLoad(long bundleId) {
        if (!this.hasBlueprint(bundleId).booleanValue()) {
            return false;
        }
        switch (this.getBundleState(bundleId)) {
            case GracePeriod: 
            case Waiting: 
            case Starting: {
                return true;
            }
        }
        return false;
    }

    public Boolean hasBlueprint(long bundleId) {
        if (this.bluePrints.size() == 0) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (bundle.getBundleId() == 0L || bundle.getResource("OSGI-INF/blueprint") == null) continue;
                this.bluePrints.add(bundle.getBundleId());
            }
        }
        return this.bluePrints.contains(bundleId);
    }

    public void blueprintEvent(BlueprintEvent blueprintEvent) {
        if (LOG.isDebugEnabled()) {
            BundleState state = this.getBundleState(blueprintEvent.getBundle().getBundleId());
            LOG.debug("Blueprint app state changed to " + state + " for bundle " + blueprintEvent.getBundle().getBundleId());
        }
        this.states.put(blueprintEvent.getBundle().getBundleId(), blueprintEvent);
    }

    public BundleState getBundleState(long bundleId) {
        BlueprintEvent blueprintEvent = this.states.get(bundleId);
        if (blueprintEvent == null) {
            return BundleState.Unknown;
        }
        switch (blueprintEvent.getType()) {
            case 1: {
                return BundleState.Starting;
            }
            case 2: {
                return BundleState.Active;
            }
            case 3: {
                return BundleState.Stopping;
            }
            case 4: {
                return BundleState.Resolved;
            }
            case 5: {
                return BundleState.Failure;
            }
            case 6: {
                return BundleState.GracePeriod;
            }
            case 7: {
                return BundleState.Waiting;
            }
        }
        return BundleState.Unknown;
    }

    public String[] getBundleMissDependencies(long bundleId) {
        BlueprintEvent blueprintEvent = this.states.get(bundleId);
        if (blueprintEvent == null) {
            return null;
        }
        return blueprintEvent.getDependencies();
    }

    public Throwable getBundleFailureCause(long bundleId) {
        BlueprintEvent blueprintEvent = this.states.get(bundleId);
        if (blueprintEvent == null) {
            return null;
        }
        return blueprintEvent.getCause();
    }
}

