/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncStringOutput;

public class CastDecimalToChar
extends CastDecimalToString
implements TruncStringOutput {
    private static final long serialVersionUID = 1L;
    private int maxLength;

    public CastDecimalToChar() {
    }

    public CastDecimalToChar(int inputColumn, int outputColumn) {
        super(inputColumn, outputColumn);
    }

    @Override
    protected void assign(BytesColumnVector outV, int i, byte[] bytes, int offset, int length) {
        StringExpr.rightTrimAndTruncate(outV, i, bytes, offset, length, this.maxLength);
    }

    @Override
    public String getOutputType() {
        return "Char";
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumn + ", maxLength " + this.maxLength;
    }
}

