/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.RequestIdUtil;
import org.slf4j.MDC;

public class RequestIdFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(RequestIdFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        String requestId = Optional.ofNullable(request.getHeader("x-request-id")).orElse(UUID.randomUUID().toString());
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received request with request id of: " + requestId));
            }
            MDC.put((String)"requestId", (String)RequestIdUtil.getFormattedRequestUid((String)requestId));
            chain.doFilter(req, resp);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting request with request id of: " + requestId));
            }
            ((HttpServletResponse)resp).setHeader("x-request-id", requestId);
            MDC.remove((String)"x-request-id");
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

