/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class UserRoleListEnhancedUserMap {
    private Logger logger = LoggerFactory.getLogger(UserRoleListEnhancedUserMap.class);
    private final Map<String, UserDetails> userRoleListEnhanceduserMap = new HashMap<String, UserDetails>();
    private final Map<GrantedAuthority, Set<String>> rolesToUsersMap = new HashMap<GrantedAuthority, Set<String>>();

    public void addUser(UserDetails user) throws IllegalArgumentException {
        Assert.notNull((Object)user, (String)"Must be a valid User");
        this.logger.info("Adding user [" + user + "]");
        this.userRoleListEnhanceduserMap.put(user.getUsername().toLowerCase(), user);
        Collection auths = user.getAuthorities();
        for (GrantedAuthority anAuthority : auths) {
            Set<String> userListForAuthority = this.getRolesToUsersMap().get(anAuthority);
            if (userListForAuthority == null) {
                userListForAuthority = new TreeSet<String>();
                this.getRolesToUsersMap().put(anAuthority, userListForAuthority);
            }
            userListForAuthority.add(user.getUsername());
        }
    }

    public String[] getAllAuthorities() {
        Set<GrantedAuthority> authoritiesSet = this.getRolesToUsersMap().keySet();
        ArrayList<String> roles = new ArrayList<String>(authoritiesSet.size());
        for (GrantedAuthority role : authoritiesSet) {
            roles.add(role.getAuthority());
        }
        return roles.toArray(new String[0]);
    }

    public String[] getAllUsers() {
        String[] rtn = new String[this.getUserRoleListEnhanceduserMap().size()];
        Iterator<UserDetails> it = this.getUserRoleListEnhanceduserMap().values().iterator();
        int i = 0;
        while (it.hasNext()) {
            rtn[i] = it.next().getUsername();
            ++i;
        }
        return rtn;
    }

    public String[] getUserNamesInRole(String role) {
        Set<String> userListForAuthority = this.getRolesToUsersMap().get(new SimpleGrantedAuthority(role));
        String[] typ = new String[]{};
        if (userListForAuthority != null) {
            return userListForAuthority.toArray(typ);
        }
        return typ;
    }

    public void setUsers(Map users) {
        this.getUserRoleListEnhanceduserMap().clear();
        Iterator iter = users.values().iterator();
        while (iter.hasNext()) {
            this.addUser((UserDetails)iter.next());
        }
    }

    public int getUserCount() {
        return this.getUserRoleListEnhanceduserMap() != null ? this.getUserRoleListEnhanceduserMap().size() : 0;
    }

    protected Map<String, UserDetails> getUserRoleListEnhanceduserMap() {
        return this.userRoleListEnhanceduserMap;
    }

    protected Map<GrantedAuthority, Set<String>> getRolesToUsersMap() {
        return this.rolesToUsersMap;
    }
}

