/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importexport.BaseExportProcessor;
import org.pentaho.platform.plugin.services.importexport.DefaultExportHandler;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ExportHandler;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifest;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestFormatException;
import org.pentaho.platform.repository2.ClientRepositoryPaths;

public class ZipExportProcessor
extends BaseExportProcessor {
    private static final Log log = LogFactory.getLog(ZipExportProcessor.class);
    protected String path;
    protected ExportManifest exportManifest;
    protected boolean withManifest = true;
    protected List<String> localeExportList;
    private static final int SAFETY_TMP_FILE_SIZE = 50;

    public ZipExportProcessor(String path, IUnifiedRepository repository, boolean withManifest) {
        this.withManifest = withManifest;
        this.path = StringUtils.isEmpty((String)path) ? "/" : path;
        this.setUnifiedRepository(repository);
        this.exportHandlerList = new ArrayList();
        this.exportManifest = new ExportManifest();
        IPentahoSession session = this.getSession();
        Date todaysDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss z");
        this.exportManifest.getManifestInformation().setExportBy(session.getName());
        this.exportManifest.getManifestInformation().setExportDate(dateFormat.format(todaysDate) + " " + timeFormat.format(todaysDate));
        this.exportManifest.getManifestInformation().setManifestVersion("2");
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    @Override
    public File performExport(RepositoryFile exportRepositoryFile) throws ExportException, IOException {
        File exportFile;
        block19: {
            exportFile = null;
            exportFile = File.createTempFile("repoExport", ".zip");
            exportFile.deleteOnExit();
            String filePath = new File(this.path).getParent();
            if (filePath == null) {
                filePath = "/";
            }
            if (exportRepositoryFile == null) {
                throw new FileNotFoundException("JCR file not found: " + this.path);
            }
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(exportFile));){
                if (exportRepositoryFile.isFolder()) {
                    this.exportManifest.getManifestInformation().setRootFolder(this.path.substring(0, this.path.lastIndexOf("/") + 1));
                    if (!ClientRepositoryPaths.getRootFolderPath().equals(exportRepositoryFile.getPath())) {
                        zos.putNextEntry(new ZipEntry(this.getFixedZipEntryName(exportRepositoryFile, filePath)));
                    }
                    this.exportDirectory(exportRepositoryFile, zos, filePath);
                } else {
                    this.exportManifest.getManifestInformation().setRootFolder(this.path.substring(0, this.path.lastIndexOf("/") + 1));
                    this.exportFile(exportRepositoryFile, zos, filePath);
                }
                if (!this.withManifest) break block19;
                ZipEntry entry = new ZipEntry("exportManifest.xml");
                zos.putNextEntry(entry);
                try {
                    this.exportManifest.toXml(zos);
                }
                catch (Exception e) {
                    log.error((Object)"Error generating export XML");
                }
                zos.closeEntry();
            }
        }
        this.exportManifest = null;
        return exportFile;
    }

    @Override
    public void exportFile(RepositoryFile repositoryFile, OutputStream outputStream, String filePath) throws ExportException, IOException {
        ZipOutputStream zos = (ZipOutputStream)outputStream;
        for (ExportHandler exportHandler : this.exportHandlerList) {
            InputStream is = exportHandler.doExport(repositoryFile, filePath);
            Throwable throwable = null;
            try {
                if (is == null) continue;
                this.addToManifest(repositoryFile);
                String zipEntryName = this.getFixedZipEntryName(repositoryFile, filePath);
                ZipEntry entry = new ZipEntry(zipEntryName);
                zos.putNextEntry(entry);
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                zos.closeEntry();
                this.createLocales(repositoryFile, filePath, repositoryFile.isFolder(), outputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    protected void addToManifest(RepositoryFile repositoryFile) throws ExportException {
        if (this.withManifest) {
            RepositoryFileAcl fileAcl = this.getUnifiedRepository().getAcl(repositoryFile.getId());
            try {
                this.getExportManifest().add(repositoryFile, fileAcl);
            }
            catch (ExportManifestFormatException e) {
                throw new ExportException(e.getMessage());
            }
        }
    }

    @Override
    public void exportDirectory(RepositoryFile repositoryDir, OutputStream outputStream, String filePath) throws ExportException, IOException {
        this.addToManifest(repositoryDir);
        List children = this.getUnifiedRepository().getChildren(new RepositoryRequest(String.valueOf(repositoryDir.getId()), Boolean.valueOf(true), Integer.valueOf(1), null));
        for (RepositoryFile repositoryFile : children) {
            if (!this.isExportCandidate(repositoryFile.getPath())) continue;
            if (repositoryFile.isFolder()) {
                if (outputStream.getClass().isAssignableFrom(ZipOutputStream.class)) {
                    ZipOutputStream zos = (ZipOutputStream)outputStream;
                    String zipEntryName = this.getFixedZipEntryName(repositoryFile, filePath);
                    ZipEntry entry = new ZipEntry(zipEntryName);
                    zos.putNextEntry(entry);
                }
                this.exportDirectory(repositoryFile, outputStream, filePath);
                continue;
            }
            try {
                this.exportFile(repositoryFile, outputStream, filePath);
            }
            catch (ZipException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.createLocales(repositoryDir, filePath, repositoryDir.isFolder(), outputStream);
    }

    protected boolean isExportCandidate(String path) {
        return !ClientRepositoryPaths.getEtcFolderPath().equals(path);
    }

    protected String getFixedZipEntryName(RepositoryFile repositoryFile, String filePath) {
        String result = this.getZipEntryName(repositoryFile, filePath);
        if (this.withManifest) {
            result = ExportFileNameEncoder.encodeZipPathName(result);
        }
        return result;
    }

    protected String getZipEntryName(RepositoryFile repositoryFile, String filePath) {
        String result = "";
        int filePathLength = 0;
        filePathLength = filePath.equals("/") || filePath.equals("\\") ? filePath.length() : filePath.length() + 1;
        result = repositoryFile.getPath().substring(filePathLength);
        if (repositoryFile.isFolder()) {
            result = result + "/";
        }
        return FilenameUtils.normalize((String)result, (boolean)true);
    }

    protected void createLocales(RepositoryFile repositoryFile, String filePath, boolean isFolder, OutputStream outputStream) throws IOException {
        ZipOutputStream zos = (ZipOutputStream)outputStream;
        if (this.supportedLocaleFileExt(repositoryFile)) {
            List<LocaleMapDto> locales = this.getAvailableLocales(repositoryFile.getId());
            String zipEntryName = this.getFixedZipEntryName(repositoryFile, filePath);
            String name = repositoryFile.getName();
            for (LocaleMapDto locale : locales) {
                Properties properties;
                String localeName;
                String string = localeName = locale.getLocale().equalsIgnoreCase("default") ? "" : "_" + locale.getLocale();
                if (isFolder) {
                    zipEntryName = this.getFixedZipEntryName(repositoryFile, filePath) + "index";
                    name = "index";
                }
                if ((properties = this.getUnifiedRepository().getLocalePropertiesForFileById(repositoryFile.getId(), locale.getLocale())) == null) continue;
                properties.remove("jcr:primaryType");
                InputStream is = this.createLocaleFile(name + localeName, properties, locale.getLocale());
                Throwable throwable = null;
                try {
                    if (is == null) continue;
                    ZipEntry entry = new ZipEntry(zipEntryName + localeName + ".locale");
                    zos.putNextEntry(entry);
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private boolean supportedLocaleFileExt(RepositoryFile repositoryFile) {
        boolean ans = true;
        String ext = repositoryFile.getName();
        if (!repositoryFile.isFolder()) {
            List<String> exportList;
            int idx = ext.lastIndexOf(".");
            if (idx > 0) {
                ext = ext.substring(idx, ext.length());
            }
            if ((exportList = this.getLocaleExportList()) != null) {
                ans = exportList.contains(ext);
            }
        }
        return ans;
    }

    private List<LocaleMapDto> getAvailableLocales(Serializable fileId) {
        ArrayList<LocaleMapDto> availableLocales = new ArrayList<LocaleMapDto>();
        List locales = this.getUnifiedRepository().getAvailableLocalesForFileById(fileId);
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                availableLocales.add(new LocaleMapDto(locale.toString(), null));
            }
        }
        return availableLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createLocaleFile(String name, Properties properties, String locale) throws IOException {
        if (properties != null) {
            File localeFile = null;
            try {
                localeFile = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), ExportFileNameEncoder.encodeZipFileName(name), ".locale", true);
            }
            catch (IOException e) {
                String smallerName = ExportFileNameEncoder.encodeZipFileName(name).substring(0, 50);
                log.debug((Object)("Error with original name file. Retrying with a smaller temp file name - " + smallerName));
                localeFile = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), smallerName, ".locale", true);
            }
            finally {
                if (localeFile != null) {
                    localeFile.deleteOnExit();
                }
            }
            try (FileOutputStream fileOut = new FileOutputStream(localeFile);){
                properties.store(fileOut, "Locale = " + locale);
            }
            return new FileInputStream(localeFile);
        }
        return null;
    }

    public List<String> getLocaleExportList() {
        block0: {
            Iterator iterator;
            if (this.localeExportList != null && !this.localeExportList.isEmpty() || !(iterator = this.exportHandlerList.iterator()).hasNext()) break block0;
            ExportHandler exportHandler = (ExportHandler)iterator.next();
            this.localeExportList = ((DefaultExportHandler)exportHandler).getLocaleExportList();
        }
        return this.localeExportList;
    }

    public void setLocaleExportList(List<String> localeExportList) {
        this.localeExportList = localeExportList;
    }

    public ExportManifest getExportManifest() {
        return this.exportManifest;
    }

    public void setExportManifest(ExportManifest exportManifest) {
        this.exportManifest = exportManifest;
    }
}

