/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetMetaDataInvocationHandler
implements InvocationHandler {
    ResultSetMetaData rsmd;

    public ResultSetMetaDataInvocationHandler(ResultSetMetaData r) {
        this.rsmd = r;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            if (("getColumnName".equals(methodName) || "getColumnLabel".equals(methodName)) && args != null && args.length == 1) {
                return this.getColumnName((Integer)args[0]);
            }
            return method.invoke((Object)this.rsmd, args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable cause = t.getCause();
                if (cause instanceof SQLException) {
                    if (cause.getMessage().equals("Method not supported")) {
                        String methodName = method.getName();
                        if ("isSigned".equals(methodName) && args != null) {
                            return this.isSigned((Integer)args[0]);
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw cause;
            }
            throw t;
        }
    }

    private String getColumnName(Integer column) throws SQLException {
        int dotIndex;
        String columnName = null;
        columnName = this.rsmd.getColumnName(column);
        if (columnName != null && (dotIndex = columnName.indexOf(46)) != -1) {
            return columnName.substring(dotIndex + 1);
        }
        return columnName;
    }

    public boolean isSigned(int column) throws SQLException {
        int numCols = this.rsmd.getColumnCount();
        if (column < 1 || column > numCols) {
            throw new SQLException("Invalid column value: " + column);
        }
        int type = this.rsmd.getColumnType(column);
        switch (type) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

