/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.lifecycle;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IBackingRepositoryLifecycleManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.lifecycle.DefaultBackingRepositoryLifecycleManager;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public abstract class AbstractBackingRepositoryLifecycleManager
implements IBackingRepositoryLifecycleManager {
    protected static final Log logger = LogFactory.getLog(DefaultBackingRepositoryLifecycleManager.class);
    protected TransactionTemplate txnTemplate;
    protected JcrTemplate adminJcrTemplate;
    protected IPathConversionHelper pathConversionHelper;

    public AbstractBackingRepositoryLifecycleManager(TransactionTemplate txnTemplate, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper) {
        Assert.notNull((Object)txnTemplate);
        this.txnTemplate = txnTemplate;
        this.adminJcrTemplate = adminJcrTemplate;
        this.pathConversionHelper = pathConversionHelper;
        this.initTransactionTemplate();
    }

    protected void initTransactionTemplate() {
        this.txnTemplate.setPropagationBehavior(3);
    }

    public void addMetadataToRepository(final String metadataProperty) {
        this.txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                AbstractBackingRepositoryLifecycleManager.this.adminJcrTemplate.execute(new JcrCallback(){

                    public Object doInJcr(Session session) throws IOException, RepositoryException {
                        Map<String, Serializable> metadataMap;
                        new PentahoJcrConstants(session);
                        String absPath = ServerRepositoryPaths.getPentahoRootFolderPath();
                        RepositoryFile rootFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, absPath, AbstractBackingRepositoryLifecycleManager.this.pathConversionHelper, null, false, null);
                        if (rootFolder != null) {
                            metadataMap = JcrRepositoryFileUtils.getFileMetadata(session, rootFolder.getId());
                            if (metadataMap == null) {
                                metadataMap = new HashMap<String, Serializable>();
                            }
                        } else {
                            throw new IllegalStateException("Repository has not been initialized properly");
                        }
                        metadataMap.put(metadataProperty, Boolean.TRUE);
                        JcrRepositoryFileUtils.setFileMetadata(session, rootFolder.getId(), metadataMap);
                        session.save();
                        return null;
                    }
                });
            }
        });
    }

    public Boolean doesMetadataExists(final String metadataProperty) {
        try {
            return (Boolean)this.txnTemplate.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    return AbstractBackingRepositoryLifecycleManager.this.adminJcrTemplate.execute(new JcrCallback(){

                        public Object doInJcr(Session session) throws IOException, RepositoryException {
                            PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
                            String absPath = ServerRepositoryPaths.getPentahoRootFolderPath();
                            RepositoryFile rootFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, absPath, AbstractBackingRepositoryLifecycleManager.this.pathConversionHelper, null, false, null);
                            if (rootFolder != null) {
                                Map<String, Serializable> metadataMap = JcrRepositoryFileUtils.getFileMetadata(session, rootFolder.getId());
                                for (Map.Entry<String, Serializable> metadataEntry : metadataMap.entrySet()) {
                                    if (!metadataEntry.getKey().equals(metadataProperty)) continue;
                                    return (Boolean)metadataEntry.getValue();
                                }
                            }
                            return false;
                        }
                    });
                }
            });
        }
        catch (Throwable th) {
            th.printStackTrace();
            return false;
        }
    }
}

