/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.repository2.unified.DefaultServerRepositoryPathsStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;

public class ServerRepositoryPaths {
    private static final Log logger = LogFactory.getLog(ServerRepositoryPaths.class);
    public static final String DEFAULT = "DEFAULT";
    public static final String SYSTEM_PROPERTY = "pentaho.repository.server.pathsStrategy";
    private static String strategyName = System.getProperty("pentaho.repository.server.pathsStrategy");
    private static IServerRepositoryPathsStrategy strategy;

    private ServerRepositoryPaths() {
    }

    public static String getPentahoRootFolderPath() {
        return strategy.getPentahoRootFolderPath();
    }

    public static String getTenantHomeFolderPath(ITenant tenant) {
        return strategy.getTenantHomeFolderPath(tenant);
    }

    public static String getTenantPublicFolderPath(ITenant tenant) {
        return strategy.getTenantPublicFolderPath(tenant);
    }

    public static String getTenantRootFolderPath(ITenant tenant) {
        return strategy.getTenantRootFolderPath(tenant);
    }

    public static String getUserHomeFolderPath(ITenant tenant, String username) {
        return strategy.getUserHomeFolderPath(tenant, username);
    }

    public static String getTenantId(String absPath) {
        return strategy.getTenantId(absPath);
    }

    public static String getTenantEtcFolderPath(ITenant tenant) {
        return strategy.getTenantEtcFolderPath(tenant);
    }

    public static String getTenantHomeFolderPath() {
        return ServerRepositoryPaths.getTenantHomeFolderPath(JcrTenantUtils.getTenant());
    }

    public static String getTenantPublicFolderPath() {
        return ServerRepositoryPaths.getTenantPublicFolderPath(JcrTenantUtils.getTenant());
    }

    public static String getTenantRootFolderPath() {
        return ServerRepositoryPaths.getTenantRootFolderPath(JcrTenantUtils.getTenant());
    }

    public static String getTenantEtcFolderPath() {
        return ServerRepositoryPaths.getTenantEtcFolderPath(JcrTenantUtils.getTenant());
    }

    public static String getTenantHomeFolderName() {
        return strategy.getTenantHomeFolderName();
    }

    public static String getTenantPublicFolderName() {
        return strategy.getTenantPublicFolderName();
    }

    public static String getPentahoRootFolderName() {
        return strategy.getPentahoRootFolderName();
    }

    public static String getTenantEtcFolderName() {
        return strategy.getTenantEtcFolderName();
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = DEFAULT;
        }
        if (strategyName.equals(DEFAULT)) {
            strategy = new DefaultServerRepositoryPathsStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (IServerRepositoryPathsStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)("ServerRepositoryPaths initialized: strategy=" + strategyName));
    }

    public static void setStrategyName(String strategyName) {
        ServerRepositoryPaths.strategyName = strategyName;
        ServerRepositoryPaths.initialize();
    }

    static {
        ServerRepositoryPaths.initialize();
    }

    public static interface IServerRepositoryPathsStrategy {
        public String getPentahoRootFolderPath();

        public String getTenantHomeFolderPath(ITenant var1);

        public String getTenantPublicFolderPath(ITenant var1);

        public String getTenantRootFolderPath(ITenant var1);

        public String getUserHomeFolderPath(ITenant var1, String var2);

        public String getTenantEtcFolderPath(ITenant var1);

        public String getTenantHomeFolderName();

        public String getTenantPublicFolderName();

        public String getPentahoRootFolderName();

        public String getTenantEtcFolderName();

        public String getTenantId(String var1);
    }
}

