/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoter;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoterManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.springframework.util.Assert;

public class RepositoryAccessVoterManager
implements IRepositoryAccessVoterManager {
    private IAuthorizationPolicy authorizationPolicy;
    private String repositoryAdminUsername;
    private List<IRepositoryAccessVoter> voters;

    public RepositoryAccessVoterManager(IAuthorizationPolicy authorizationPolicy, String repositoryAdminUsername) {
        this.authorizationPolicy = authorizationPolicy;
        this.repositoryAdminUsername = repositoryAdminUsername;
    }

    public RepositoryAccessVoterManager(List<IRepositoryAccessVoter> voters, IAuthorizationPolicy authorizationPolicy, String repositoryAdminUsername) {
        this(authorizationPolicy, repositoryAdminUsername);
        Assert.notNull(voters);
        this.voters = new ArrayList<IRepositoryAccessVoter>();
        this.voters.addAll(voters);
    }

    public void registerVoter(IRepositoryAccessVoter voter) {
        this.voters.add(voter);
    }

    public boolean hasAccess(RepositoryFile file, RepositoryFilePermission operation, RepositoryFileAcl repositoryFileAcl, IPentahoSession session) {
        if (this.voters != null && !this.authorizationPolicy.isAllowed("org.pentaho.security.administerSecurity") && session.getName() != null && !session.getName().equals(this.repositoryAdminUsername)) {
            for (IRepositoryAccessVoter voter : this.voters) {
                if (voter.hasAccess(file, operation, repositoryFileAcl, session)) continue;
                return false;
            }
        }
        return true;
    }
}

