/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.big.data.api.jdbc.DriverLocator;
import org.pentaho.big.data.kettle.plugins.hive.BaseSimbaDatabaseMeta;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="SPARKSIMBA", typeDescription="SparkSQL")
public class SparkSimbaDatabaseMeta
extends BaseSimbaDatabaseMeta {
    @VisibleForTesting
    static final String JDBC_URL_PREFIX = "jdbc:spark://";
    @VisibleForTesting
    static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.SparkSqlSimbaDriver";
    @VisibleForTesting
    static final String JAR_FILE = "SparkJDBC41.jar";
    @VisibleForTesting
    static final int DEFAULT_PORT = 10015;
    @VisibleForTesting
    static final String SOCKET_TIMEOUT_OPTION = "SocketTimeout";
    private final String LIMIT_1 = " LIMIT 1";

    public SparkSimbaDatabaseMeta(DriverLocator driverLocator) {
        super(driverLocator);
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 4};
    }

    @Override
    protected String getJdbcPrefix() {
        return JDBC_URL_PREFIX;
    }

    @Override
    public String getDriverClass() {
        return DRIVER_CLASS_NAME;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 1";
    }

    @Override
    public String getStartQuote() {
        return "`";
    }

    @Override
    public String getEndQuote() {
        return "`";
    }

    public String getSQLTableExists(String tablename) {
        return "SELECT 1 FROM " + tablename + " LIMIT 1";
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT " + columnname + " FROM " + tablename + " LIMIT 1";
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    @Override
    public String getSelectCountStatement(String tableName) {
        return "select count(*) FROM " + tableName;
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "";
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "";
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public int getDefaultDatabasePort() {
        return 10015;
    }

    public Map<String, String> getDefaultOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(String.format("%s.%s", this.getPluginId(), SOCKET_TIMEOUT_OPTION), "10");
        return options;
    }
}

