/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import com.google.common.base.Strings;
import org.pentaho.big.data.kettle.plugins.hive.Hive2DatabaseDialect;
import org.pentaho.big.data.kettle.plugins.hive.SimbaUrl;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class Hive2SimbaDatabaseDialect
extends Hive2DatabaseDialect {
    public static final String SOCKET_TIMEOUT_OPTION = "SocketTimeout";
    public static final String DEFAULT_SOCKET_TIMEOUT = "10";
    private static final long serialVersionUID = -8456961348836455937L;
    private static final IDatabaseType DBTYPE = new DatabaseType("Hadoop Hive 2 (Simba)", "HIVE2SIMBA", DatabaseAccessType.getList((DatabaseAccessType[])new DatabaseAccessType[]{DatabaseAccessType.NATIVE, DatabaseAccessType.JNDI, DatabaseAccessType.ODBC}), 10000, "http://www.simba.com/connectors/apache-hadoop-hive-driver");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "org.apache.hive.jdbc.HiveSimbaDriver";
    }

    @Override
    public String getURL(IDatabaseConnection databaseConnection) throws DatabaseDialectException {
        return SimbaUrl.Builder.create().withAccessType(databaseConnection.getAccessType().ordinal()).withDatabaseName(databaseConnection.getDatabaseName()).withPort(databaseConnection.getDatabasePort()).withDefaultPort(this.getDefaultDatabasePort()).withHostname(databaseConnection.getHostname()).withJdbcPrefix(this.getNativeJdbcPre()).withUsername(databaseConnection.getUsername()).withPassword(databaseConnection.getPassword()).withIsKerberos(this.isKerberos(databaseConnection)).build().getURL();
    }

    private String getExtraProperty(String key, IDatabaseConnection databaseConnection) {
        return (String)databaseConnection.getAttributes().get("EXTRA_OPTION_" + this.getDatabaseType().getShortName() + "." + key);
    }

    private String getProperty(String key, IDatabaseConnection databaseConnection) {
        return (String)databaseConnection.getExtraOptions().get(this.getDatabaseType().getShortName() + "." + key);
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:hive2://";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"HiveJDBC41.jar"};
    }

    @Override
    public boolean initialize(String classname) {
        return true;
    }

    public boolean isKerberos(IDatabaseConnection databaseConnection) {
        return !Strings.isNullOrEmpty((String)this.getProperty("KrbHostFQDN", databaseConnection)) || !Strings.isNullOrEmpty((String)this.getExtraProperty("KrbHostFQDN", databaseConnection)) || !Strings.isNullOrEmpty((String)this.getProperty("KrbServiceName", databaseConnection)) || !Strings.isNullOrEmpty((String)this.getExtraProperty("KrbServiceName", databaseConnection));
    }
}

