/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.tezplugins.ContainerFactory;
import org.apache.hadoop.hive.llap.tezplugins.helpers.MonotonicClock;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapTaskSchedulerMetrics;
import org.apache.hadoop.hive.llap.tezplugins.scheduler.LoggingFutureCallback;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.ServicePluginErrorDefaults;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTaskSchedulerService
extends TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTaskSchedulerService.class);
    private static final TaskStartComparator TASK_INFO_COMPARATOR = new TaskStartComparator();
    private final Configuration conf;
    private ServiceInstanceSet activeInstances;
    @VisibleForTesting
    final Map<String, NodeInfo> instanceToNodeMap = new LinkedHashMap<String, NodeInfo>();
    @VisibleForTesting
    final TreeMap<Priority, List<TaskInfo>> pendingTasks = new TreeMap(new Comparator<Priority>(){

        @Override
        public int compare(Priority o1, Priority o2) {
            return o1.getPriority() - o2.getPriority();
        }
    });
    private final ConcurrentMap<Object, TaskInfo> knownTasks = new ConcurrentHashMap<Object, TaskInfo>();
    private final TreeMap<Integer, TreeSet<TaskInfo>> runningTasks = new TreeMap();
    @VisibleForTesting
    final DelayQueue<NodeInfo> disabledNodesQueue = new DelayQueue();
    @VisibleForTesting
    final DelayQueue<TaskInfo> delayedTaskQueue = new DelayQueue();
    private final ContainerFactory containerFactory;
    private final Random random = new Random();
    @VisibleForTesting
    final Clock clock;
    private final ListeningExecutorService nodeEnabledExecutor;
    private final NodeEnablerCallable nodeEnablerCallable = new NodeEnablerCallable();
    private final ListeningExecutorService delayedTaskSchedulerExecutor;
    @VisibleForTesting
    final DelayedTaskSchedulerCallable delayedTaskSchedulerCallable;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Lock scheduleLock = new ReentrantLock();
    private final Condition scheduleCondition = this.scheduleLock.newCondition();
    private final AtomicBoolean pendingScheduleInvocations = new AtomicBoolean(false);
    private final ListeningExecutorService schedulerExecutor;
    private final SchedulerCallable schedulerCallable = new SchedulerCallable();
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicInteger pendingPreemptions = new AtomicInteger(0);
    private final Map<String, MutableInt> pendingPreemptionsPerHost = new HashMap<String, MutableInt>();
    private final NodeBlacklistConf nodeBlacklistConf;
    private final LocalityDelayConf localityDelayConf;
    private final int memoryPerInstance;
    private final int coresPerInstance;
    private final int executorsPerInstance;
    private final int numSchedulableTasksPerNode;
    private final Resource resourcePerExecutor;
    private final long timeout;
    private final Lock timeoutLock = new ReentrantLock();
    private final ScheduledExecutorService timeoutExecutor;
    private final SchedulerTimeoutMonitor timeoutMonitor;
    private ScheduledFuture<?> timeoutFuture;
    private final LlapRegistryService registry = new LlapRegistryService(false);
    private volatile ListenableFuture<Void> nodeEnablerFuture;
    private volatile ListenableFuture<Void> delayedTaskSchedulerFuture;
    private volatile ListenableFuture<Void> schedulerFuture;
    @VisibleForTesting
    private final AtomicInteger dagCounter = new AtomicInteger(1);
    @VisibleForTesting
    StatsPerDag dagStats = new StatsPerDag();
    private final LlapTaskSchedulerMetrics metrics;
    private final JvmPauseMonitor pauseMonitor;
    private static final SelectHostResult SELECT_HOST_RESULT_INADEQUATE_TOTAL_CAPACITY = new SelectHostResult(ScheduleResult.INADEQUATE_TOTAL_RESOURCES);
    private static final SelectHostResult SELECT_HOST_RESULT_DELAYED_LOCALITY = new SelectHostResult(ScheduleResult.DELAYED_LOCALITY);
    private static final SelectHostResult SELECT_HOST_RESULT_DELAYED_RESOURCES = new SelectHostResult(ScheduleResult.DELAYED_RESOURCES);

    public LlapTaskSchedulerService(TaskSchedulerContext taskSchedulerContext) {
        this(taskSchedulerContext, new MonotonicClock(), true);
    }

    @VisibleForTesting
    public LlapTaskSchedulerService(TaskSchedulerContext taskSchedulerContext, Clock clock, boolean initMetrics) {
        super(taskSchedulerContext);
        this.clock = clock;
        this.delayedTaskSchedulerCallable = this.createDelayedTaskSchedulerCallable();
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)taskSchedulerContext.getInitialUserPayload());
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to parse user payload for " + LlapTaskSchedulerService.class.getSimpleName(), (Throwable)e);
        }
        this.containerFactory = new ContainerFactory(taskSchedulerContext.getApplicationAttemptId(), taskSchedulerContext.getCustomClusterIdentifier());
        this.memoryPerInstance = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB);
        this.coresPerInstance = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE);
        this.executorsPerInstance = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
        this.nodeBlacklistConf = new NodeBlacklistConf(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_NODE_REENABLE_MIN_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS), HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_NODE_REENABLE_MAX_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS), HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_NODE_DISABLE_BACK_OFF_FACTOR));
        this.numSchedulableTasksPerNode = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_NUM_SCHEDULABLE_TASKS_PER_NODE);
        long localityDelayMs = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_LOCALITY_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        this.localityDelayConf = new LocalityDelayConf(localityDelayMs);
        this.timeoutMonitor = new SchedulerTimeoutMonitor();
        this.timeout = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
        this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LlapTaskSchedulerTimeoutMonitor").build());
        this.timeoutFuture = null;
        int memoryPerExecutor = (int)((float)this.memoryPerInstance / (float)this.executorsPerInstance);
        int coresPerExecutor = (int)((float)this.coresPerInstance / (float)this.executorsPerInstance);
        this.resourcePerExecutor = Resource.newInstance((int)memoryPerExecutor, (int)coresPerExecutor);
        String instanceId = HiveConf.getTrimmedVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        Preconditions.checkNotNull((Object)instanceId, (Object)(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname + " must be defined"));
        ExecutorService executorServiceRaw = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LlapSchedulerNodeEnabler").build());
        this.nodeEnabledExecutor = MoreExecutors.listeningDecorator((ExecutorService)executorServiceRaw);
        ExecutorService delayedTaskSchedulerExecutorRaw = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LlapSchedulerDelayedTaskHandler").build());
        this.delayedTaskSchedulerExecutor = MoreExecutors.listeningDecorator((ExecutorService)delayedTaskSchedulerExecutorRaw);
        ExecutorService schedulerExecutorServiceRaw = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LlapScheduler").build());
        this.schedulerExecutor = MoreExecutors.listeningDecorator((ExecutorService)schedulerExecutorServiceRaw);
        if (initMetrics && !this.conf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST.varname, false)) {
            LlapMetricsSystem.initialize((String)"LlapTaskScheduler");
            this.pauseMonitor = new JvmPauseMonitor();
            this.pauseMonitor.init(this.conf);
            this.pauseMonitor.start();
            String displayName = "LlapTaskSchedulerMetrics-" + MetricsUtils.getHostName();
            String sessionId = this.conf.get("llap.daemon.metrics.sessionid");
            this.metrics = LlapTaskSchedulerMetrics.create(displayName, sessionId);
            this.metrics.setNumExecutors(this.executorsPerInstance);
            this.metrics.setMemoryPerInstance((long)this.memoryPerInstance * 1024L * 1024L);
            this.metrics.setCpuCoresPerInstance(coresPerExecutor);
            this.metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        } else {
            this.metrics = null;
            this.pauseMonitor = null;
        }
        LOG.info("Running with configuration: memoryPerInstance=" + this.memoryPerInstance + ", vCoresPerInstance=" + this.coresPerInstance + ", executorsPerInstance=" + this.executorsPerInstance + ", resourcePerInstanceInferred=" + this.resourcePerExecutor + ", nodeBlacklistConf=" + this.nodeBlacklistConf + ", localityDelayMs=" + localityDelayMs);
    }

    public void initialize() {
        this.registry.init(this.conf);
    }

    public void start() throws IOException {
        this.writeLock.lock();
        try {
            this.nodeEnablerFuture = this.nodeEnabledExecutor.submit((Callable)this.nodeEnablerCallable);
            Futures.addCallback(this.nodeEnablerFuture, (FutureCallback)new LoggingFutureCallback("NodeEnablerThread", LOG));
            this.delayedTaskSchedulerFuture = this.delayedTaskSchedulerExecutor.submit((Callable)this.delayedTaskSchedulerCallable);
            Futures.addCallback(this.delayedTaskSchedulerFuture, (FutureCallback)new LoggingFutureCallback("DelayedTaskSchedulerThread", LOG));
            this.schedulerFuture = this.schedulerExecutor.submit((Callable)this.schedulerCallable);
            Futures.addCallback(this.schedulerFuture, (FutureCallback)new LoggingFutureCallback("SchedulerThread", LOG));
            this.registry.start();
            this.registry.registerStateChangeListener((ServiceInstanceStateChangeListener)new NodeStateChangeListener());
            this.activeInstances = this.registry.getInstances();
            for (ServiceInstance inst : this.activeInstances.getAll().values()) {
                this.addNode(inst, new NodeInfo(inst, this.nodeBlacklistConf, this.clock, this.numSchedulableTasksPerNode, this.metrics));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startTimeoutMonitor() {
        this.timeoutLock.lock();
        try {
            if ((this.timeoutFuture == null || this.timeoutFuture != null && this.timeoutFuture.isDone()) && this.activeInstances.size() == 0) {
                this.timeoutFuture = this.timeoutExecutor.schedule(this.timeoutMonitor, this.timeout, TimeUnit.MILLISECONDS);
                LOG.info("Scheduled timeout monitor task to run after {} ms", (Object)this.timeout);
            } else {
                LOG.info("Timeout monitor task not started. Timeout future state: {}, #instances: {}", this.timeoutFuture == null ? "null" : Boolean.valueOf(this.timeoutFuture.isDone()), (Object)this.activeInstances.size());
            }
        }
        finally {
            this.timeoutLock.unlock();
        }
    }

    private void stopTimeoutMonitor() {
        this.timeoutLock.lock();
        try {
            if (this.timeoutFuture != null && this.activeInstances.size() != 0 && this.timeoutFuture.cancel(false)) {
                LOG.info("Stopped timeout monitor task");
            } else {
                LOG.info("Timeout monitor task not stopped. Timeout future state: {}, #instances: {}", this.timeoutFuture == null ? "null" : Boolean.valueOf(this.timeoutFuture.isDone()), (Object)this.activeInstances.size());
            }
            this.timeoutFuture = null;
        }
        finally {
            this.timeoutLock.unlock();
        }
    }

    public void shutdown() {
        this.writeLock.lock();
        try {
            if (!this.isStopped.getAndSet(true)) {
                this.nodeEnablerCallable.shutdown();
                if (this.nodeEnablerFuture != null) {
                    this.nodeEnablerFuture.cancel(true);
                }
                this.nodeEnabledExecutor.shutdownNow();
                this.timeoutExecutor.shutdown();
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(true);
                    this.timeoutFuture = null;
                }
                this.timeoutExecutor.shutdownNow();
                this.delayedTaskSchedulerCallable.shutdown();
                if (this.delayedTaskSchedulerFuture != null) {
                    this.delayedTaskSchedulerFuture.cancel(true);
                }
                this.delayedTaskSchedulerExecutor.shutdownNow();
                this.schedulerCallable.shutdown();
                if (this.schedulerFuture != null) {
                    this.schedulerFuture.cancel(true);
                }
                this.schedulerExecutor.shutdownNow();
                if (this.registry != null) {
                    this.registry.stop();
                }
                if (this.pauseMonitor != null) {
                    this.pauseMonitor.stop();
                }
                if (this.metrics != null) {
                    LlapMetricsSystem.shutdown();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getTotalResources() {
        int memory = 0;
        int vcores = 0;
        this.readLock.lock();
        try {
            int numInstancesFound = 0;
            for (ServiceInstance inst : this.activeInstances.getAll().values()) {
                if (!inst.isAlive()) continue;
                Resource r = inst.getResource();
                memory += r.getMemory();
                vcores += r.getVirtualCores();
                ++numInstancesFound;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("GetTotalResources: numInstancesFound={}, totalMem={}, totalVcores={}", new Object[]{numInstancesFound, memory, vcores});
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Resource.newInstance((int)memory, (int)vcores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAvailableResources() {
        int memory = 0;
        int vcores = 0;
        this.readLock.lock();
        try {
            for (Map.Entry<String, NodeInfo> entry : this.instanceToNodeMap.entrySet()) {
                if (!entry.getValue().getServiceInstance().isAlive() || entry.getValue().isDisabled()) continue;
                Resource r = entry.getValue().getServiceInstance().getResource();
                memory += r.getMemory();
                vcores += r.getVirtualCores();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Resource.newInstance((int)memory, (int)vcores);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterNodeCount() {
        this.readLock.lock();
        try {
            int n = 0;
            for (ServiceInstance inst : this.activeInstances.getAll().values()) {
                if (!inst.isAlive()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void dagComplete() {
        LOG.info("DAG: " + this.dagCounter.get() + " completed. Scheduling stats: " + this.dagStats);
        this.dagCounter.incrementAndGet();
        if (this.metrics != null) {
            this.metrics.incrCompletedDagCount();
        }
        this.dagStats = new StatsPerDag();
    }

    public void blacklistNode(NodeId nodeId) {
        LOG.info("BlacklistNode not supported");
    }

    public void unblacklistNode(NodeId nodeId) {
        LOG.info("unBlacklistNode not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        TaskInfo taskInfo = new TaskInfo(this.localityDelayConf, this.clock, task, clientCookie, priority, capability, hosts, racks, this.clock.getTime());
        LOG.info("Received allocateRequest. task={}, priority={}, capability={}, hosts={}", new Object[]{task, priority, capability, Arrays.toString(hosts)});
        this.writeLock.lock();
        try {
            this.dagStats.registerTaskRequest(hosts, racks);
        }
        finally {
            this.writeLock.unlock();
        }
        this.addPendingTask(taskInfo);
        this.trySchedulingPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        TaskInfo taskInfo = new TaskInfo(this.localityDelayConf, this.clock, task, clientCookie, priority, capability, null, null, this.clock.getTime());
        LOG.info("Received allocateRequest. task={}, priority={}, capability={}, containerId={}", new Object[]{task, priority, capability, containerId});
        this.writeLock.lock();
        try {
            this.dagStats.registerTaskRequest(null, null);
        }
        finally {
            this.writeLock.unlock();
        }
        this.addPendingTask(taskInfo);
        this.trySchedulingPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
        TaskInfo taskInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing deallocateTask for task={}, taskSucceeded={}, endReason={}", new Object[]{task, taskSucceeded, endReason});
        }
        this.writeLock.lock();
        try {
            taskInfo = this.unregisterTask(task);
            if (taskInfo == null) {
                LOG.error("Could not determine ContainerId for task: " + task + " . Could have hit a race condition. Ignoring. The query may hang since this \"unknown\" container is now taking up a slot permanently");
                boolean bl = false;
                return bl;
            }
            if (taskInfo.containerId == null) {
                if (taskInfo.getState() == TaskInfo.State.ASSIGNED) {
                    LOG.error("Task: " + task + " assigned, but could not find the corresponding containerId. The query may hang since this \"unknown\" container is now taking up a slot permanently");
                } else {
                    LOG.info("Ignoring deallocate request for task " + task + " which hasn't been assigned to a container");
                    this.removePendingTask(taskInfo);
                }
                boolean bl = false;
                return bl;
            }
            ServiceInstance assignedInstance = taskInfo.assignedInstance;
            assert (assignedInstance != null);
            NodeInfo nodeInfo = this.instanceToNodeMap.get(assignedInstance.getWorkerIdentity());
            assert (nodeInfo != null);
            LOG.info("Processing de-allocate request for task={}, state={}, endReason={}", new Object[]{taskInfo.task, taskInfo.getState(), endReason});
            if (taskInfo.getState() == TaskInfo.State.PREEMPTED) {
                LOG.info("Processing deallocateTask for {} which was preempted, EndReason={}", task, (Object)endReason);
                this.unregisterPendingPreemption(taskInfo.assignedInstance.getHost());
                nodeInfo.registerUnsuccessfulTaskEnd(true);
                if (nodeInfo.isDisabled()) {
                    nodeInfo.enableNode();
                    this.reinsertNodeInfo(nodeInfo);
                }
                this.trySchedulingPendingTasks();
            } else if (taskSucceeded) {
                nodeInfo.registerTaskSuccess();
                if (nodeInfo.isDisabled()) {
                    nodeInfo.enableNode();
                    this.reinsertNodeInfo(nodeInfo);
                }
                this.trySchedulingPendingTasks();
            } else {
                nodeInfo.registerUnsuccessfulTaskEnd(false);
                if (endReason != null && EnumSet.of(TaskAttemptEndReason.EXECUTOR_BUSY, TaskAttemptEndReason.COMMUNICATION_ERROR).contains(endReason)) {
                    if (endReason == TaskAttemptEndReason.COMMUNICATION_ERROR) {
                        this.dagStats.registerCommFailure(taskInfo.assignedInstance.getHost());
                    } else if (endReason == TaskAttemptEndReason.EXECUTOR_BUSY) {
                        this.dagStats.registerTaskRejected(taskInfo.assignedInstance.getHost());
                    }
                }
                if (endReason != null && endReason == TaskAttemptEndReason.NODE_FAILED) {
                    LOG.info("Task {} ended on {} nodeInfo.toString() with a NODE_FAILED message. An message should come in from the registry to disable this node unless this was a temporary communication failure", task, (Object)assignedInstance);
                }
                boolean commFailure = endReason != null && endReason == TaskAttemptEndReason.COMMUNICATION_ERROR;
                this.disableInstance(assignedInstance, commFailure);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.getContext().containerBeingReleased(taskInfo.containerId);
        return true;
    }

    private void reinsertNodeInfo(NodeInfo nodeInfo) {
        if (this.disabledNodesQueue.remove(nodeInfo)) {
            this.disabledNodesQueue.add(nodeInfo);
        }
        if (this.metrics != null) {
            this.metrics.setDisabledNodeCount(this.disabledNodesQueue.size());
        }
    }

    public Object deallocateContainer(ContainerId containerId) {
        LOG.debug("Ignoring deallocateContainer for containerId: " + containerId);
        return null;
    }

    public void setShouldUnregister() {
    }

    public boolean hasUnregistered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectHostResult selectHost(TaskInfo request) {
        Object[] requestedHosts = request.requestedHosts;
        if (LOG.isDebugEnabled()) {
            LOG.debug("selectingHost for task={} on hosts={}", request.task, (Object)Arrays.toString(requestedHosts));
        }
        long schedulerAttemptTime = this.clock.getTime();
        this.readLock.lock();
        try {
            Object object;
            if (this.getTotalResources().getMemory() <= 0) {
                SelectHostResult selectHostResult = SELECT_HOST_RESULT_INADEQUATE_TOTAL_CAPACITY;
                return selectHostResult;
            }
            boolean shouldDelayForLocality = request.shouldDelayForLocality(schedulerAttemptTime);
            LOG.debug("ShouldDelayForLocality={} for task={} on hosts={}", new Object[]{shouldDelayForLocality, request.task, Arrays.toString(requestedHosts)});
            if (requestedHosts != null && requestedHosts.length > 0) {
                int prefHostCount = -1;
                boolean requestedHostsWillBecomeAvailable = false;
                for (Object host : requestedHosts) {
                    ++prefHostCount;
                    Set instances = this.activeInstances.getByHost((String)host);
                    if (instances.isEmpty()) continue;
                    for (ServiceInstance inst : instances) {
                        NodeInfo nodeInfo = this.instanceToNodeMap.get(inst.getWorkerIdentity());
                        if (nodeInfo != null) {
                            if (nodeInfo.canAcceptTask()) {
                                LOG.info("Assigning " + this.nodeToString(inst, nodeInfo) + " when looking for " + (String)host + ". local=true FirstRequestedHost=" + (prefHostCount == 0) + (requestedHosts.length > 1 ? ", #prefLocations=" + requestedHosts.length : ""));
                                SelectHostResult selectHostResult = new SelectHostResult(inst, nodeInfo);
                                return selectHostResult;
                            }
                            if (!shouldDelayForLocality) continue;
                            if (request.shouldForceLocality()) {
                                requestedHostsWillBecomeAvailable = true;
                                continue;
                            }
                            if (nodeInfo.getEnableTime() > request.getLocalityDelayTimeout() && nodeInfo.isDisabled() && nodeInfo.hadCommFailure()) {
                                LOG.debug("Host={} will not become available within requested timeout", (Object)nodeInfo);
                                continue;
                            }
                            requestedHostsWillBecomeAvailable = true;
                            continue;
                        }
                        LOG.warn("Null NodeInfo when attempting to get host with worker identity {}, and host {}", (Object)inst.getWorkerIdentity(), host);
                    }
                }
                if (shouldDelayForLocality) {
                    if (requestedHostsWillBecomeAvailable) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Delaying local allocation for [" + request.task + "] when trying to allocate on [" + Arrays.toString(requestedHosts) + "]. ScheduleAttemptTime=" + schedulerAttemptTime + ", taskDelayTimeout=" + request.getLocalityDelayTimeout());
                        }
                        object = SELECT_HOST_RESULT_DELAYED_LOCALITY;
                        return object;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping local allocation for [" + request.task + "] when trying to allocate on [" + Arrays.toString(requestedHosts) + "] since none of these hosts are part of the known list");
                    }
                }
            }
            Collection instances = this.activeInstances.getAll().values();
            ArrayList<NodeInfo> all = new ArrayList<NodeInfo>(instances.size());
            for (ServiceInstance inst : instances) {
                NodeInfo nodeInfo = this.instanceToNodeMap.get(inst.getWorkerIdentity());
                if (nodeInfo == null || !nodeInfo.canAcceptTask()) continue;
                all.add(nodeInfo);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting random allocation for task={}", request.task);
            }
            if (all.isEmpty()) {
                object = SELECT_HOST_RESULT_DELAYED_RESOURCES;
                return object;
            }
            NodeInfo randomNode = (NodeInfo)all.get(this.random.nextInt(all.size()));
            LOG.info("Assigning " + this.nodeToString(randomNode.getServiceInstance(), randomNode) + " when looking for any host, from #hosts=" + all.size() + ", requestedHosts=" + (requestedHosts == null || requestedHosts.length == 0 ? "null" : Arrays.toString(requestedHosts)));
            SelectHostResult selectHostResult = new SelectHostResult(randomNode.getServiceInstance(), randomNode);
            return selectHostResult;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void scanForNodeChanges() {
        this.writeLock.lock();
        try {
            for (ServiceInstance inst : this.activeInstances.getAll().values()) {
                if (!inst.isAlive() || this.instanceToNodeMap.containsKey(inst.getWorkerIdentity())) continue;
                LOG.info("Found a new node: " + inst + ".");
                this.addNode(inst, new NodeInfo(inst, this.nodeBlacklistConf, this.clock, this.numSchedulableTasksPerNode, this.metrics));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addNode(ServiceInstance inst, NodeInfo node) {
        LOG.info("Adding node: " + inst);
        if (this.activeInstances.size() == 1) {
            LOG.info("New node added. Signalling scheduler timeout monitor thread to stop timer.");
            this.stopTimeoutMonitor();
        }
        this.instanceToNodeMap.put(inst.getWorkerIdentity(), node);
        if (this.metrics != null) {
            this.metrics.setClusterNodeCount(this.activeInstances.size());
        }
        this.trySchedulingPendingTasks();
    }

    private void reenableDisabledNode(NodeInfo nodeInfo) {
        this.writeLock.lock();
        try {
            LOG.info("Attempting to re-enable node: " + nodeInfo.getServiceInstance());
            if (nodeInfo.getServiceInstance().isAlive()) {
                nodeInfo.enableNode();
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Removing dead node " + nodeInfo);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInstance(ServiceInstance instance, boolean isCommFailure) {
        this.writeLock.lock();
        try {
            NodeInfo nodeInfo = this.instanceToNodeMap.get(instance.getWorkerIdentity());
            if (nodeInfo == null || nodeInfo.isDisabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node: " + instance + " already disabled, or invalid. Not doing anything.");
                }
            } else {
                nodeInfo.disableNode(isCommFailure);
                this.disabledNodesQueue.add(nodeInfo);
                if (this.metrics != null) {
                    this.metrics.setDisabledNodeCount(this.disabledNodesQueue.size());
                }
                this.trySchedulingPendingTasks();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addPendingTask(TaskInfo taskInfo) {
        this.writeLock.lock();
        try {
            List<TaskInfo> tasksAtPriority = this.pendingTasks.get(taskInfo.priority);
            if (tasksAtPriority == null) {
                tasksAtPriority = new LinkedList<TaskInfo>();
                this.pendingTasks.put(taskInfo.priority, tasksAtPriority);
            }
            tasksAtPriority.add(taskInfo);
            this.knownTasks.putIfAbsent(taskInfo.task, taskInfo);
            if (this.metrics != null) {
                this.metrics.incrPendingTasksCount();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("PendingTasksInfo={}", (Object)this.constructPendingTaskCountsLogMessage());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingTask(TaskInfo taskInfo) {
        this.writeLock.lock();
        try {
            Priority priority = taskInfo.priority;
            List<TaskInfo> taskInfoList = this.pendingTasks.get(priority);
            if (taskInfoList == null || taskInfoList.isEmpty() || !taskInfoList.remove(taskInfo)) {
                LOG.warn("Could not find task: " + taskInfo.task + " in pending list, at priority: " + priority);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRunningTask(TaskInfo taskInfo) {
        this.writeLock.lock();
        try {
            int priority = taskInfo.priority.getPriority();
            TreeSet<TaskInfo> tasksAtpriority = this.runningTasks.get(priority);
            if (tasksAtpriority == null) {
                tasksAtpriority = new TreeSet<TaskInfo>(TASK_INFO_COMPARATOR);
                this.runningTasks.put(priority, tasksAtpriority);
            }
            tasksAtpriority.add(taskInfo);
            if (this.metrics != null) {
                this.metrics.decrPendingTasksCount();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInfo unregisterTask(Object task) {
        this.writeLock.lock();
        try {
            TaskInfo taskInfo = (TaskInfo)this.knownTasks.remove(task);
            if (taskInfo != null) {
                if (taskInfo.getState() == TaskInfo.State.ASSIGNED) {
                    int priority = taskInfo.priority.getPriority();
                    Set tasksAtPriority = this.runningTasks.get(priority);
                    Preconditions.checkState((tasksAtPriority != null ? 1 : 0) != 0, (String)"runningTasks should contain an entry if the task was in running state. Caused by task: {}", (Object[])new Object[]{task});
                    tasksAtPriority.remove(taskInfo);
                    if (tasksAtPriority.isEmpty()) {
                        this.runningTasks.remove(priority);
                    }
                }
            } else {
                LOG.warn("Could not find TaskInfo for task: {}. Not removing it from the running set", task);
            }
            TaskInfo taskInfo2 = taskInfo;
            return taskInfo2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void schedulePendingTasks() {
        this.writeLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ScheduleRun: {}", (Object)this.constructPendingTaskCountsLogMessage());
            }
            Iterator<Map.Entry<Priority, List<TaskInfo>>> pendingIterator = this.pendingTasks.entrySet().iterator();
            while (pendingIterator.hasNext()) {
                Map.Entry<Priority, List<TaskInfo>> entry = pendingIterator.next();
                List<TaskInfo> taskListAtPriority = entry.getValue();
                Iterator<TaskInfo> taskIter = taskListAtPriority.iterator();
                boolean scheduledAllAtPriority = true;
                while (taskIter.hasNext()) {
                    Object[] potentialHosts;
                    TaskInfo taskInfo = taskIter.next();
                    if (taskInfo.getNumPreviousAssignAttempts() == 1) {
                        this.dagStats.registerDelayedAllocation();
                    }
                    taskInfo.triedAssigningTask();
                    ScheduleResult scheduleResult = this.scheduleTask(taskInfo);
                    LOG.info("ScheduleResult for Task: {} = {}", (Object)taskInfo, (Object)scheduleResult);
                    if (scheduleResult == ScheduleResult.SCHEDULED) {
                        taskIter.remove();
                        continue;
                    }
                    if (scheduleResult == ScheduleResult.INADEQUATE_TOTAL_RESOURCES) {
                        LOG.info("Inadequate total resources before scheduling pending tasks. Signalling scheduler timeout monitor thread to start timer.");
                        this.startTimeoutMonitor();
                    }
                    if (scheduleResult == ScheduleResult.DELAYED_LOCALITY) {
                        this.maybeAddToDelayedTaskQueue(taskInfo);
                        potentialHosts = taskInfo.requestedHosts;
                        if (potentialHosts == null || potentialHosts.length == 0) {
                            potentialHosts = null;
                        }
                    } else {
                        potentialHosts = null;
                    }
                    if (potentialHosts != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Attempting to preempt on requested host for task={}, potentialHosts={}", (Object)taskInfo, (Object)Arrays.toString(potentialHosts));
                        }
                        boolean shouldPreempt = true;
                        for (Object host : potentialHosts) {
                            MutableInt pendingHostPreemptions = this.pendingPreemptionsPerHost.get(host);
                            if (pendingHostPreemptions == null || pendingHostPreemptions.intValue() <= 0) continue;
                            shouldPreempt = false;
                            LOG.debug("Not preempting for task={}. Found an existing preemption request on host={}, pendingPreemptionCount={}", new Object[]{taskInfo.task, host, pendingHostPreemptions.intValue()});
                            break;
                        }
                        if (shouldPreempt) {
                            LOG.debug("Preempting for {} on potential hosts={}. TotalPendingPreemptions={}", new Object[]{taskInfo.task, Arrays.toString(potentialHosts), this.pendingPreemptions.get()});
                            this.preemptTasks(entry.getKey().getPriority(), 1, (String[])potentialHosts);
                        } else {
                            LOG.debug("Not preempting for {} on potential hosts={}. An existing preemption request exists", taskInfo.task, (Object)Arrays.toString(potentialHosts));
                        }
                    } else {
                        LOG.debug("Attempting to preempt on any host for task={}, pendingPreemptions={}", taskInfo.task, (Object)this.pendingPreemptions.get());
                        if (this.pendingPreemptions.get() == 0) {
                            LOG.info("Preempting for task={} on any available host", taskInfo.task);
                            this.preemptTasks(entry.getKey().getPriority(), 1, null);
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Skipping preemption since there are {} pending preemption request. For task={}", (Object)this.pendingPreemptions.get(), (Object)taskInfo);
                        }
                    }
                    scheduledAllAtPriority = false;
                    if (scheduleResult == ScheduleResult.DELAYED_LOCALITY) continue;
                    break;
                }
                if (taskListAtPriority.isEmpty()) {
                    pendingIterator.remove();
                }
                if (scheduledAllAtPriority) continue;
                LOG.debug("Unable to schedule all requests at priority={}. Skipping subsequent priority levels", (Object)entry.getKey());
                break;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String constructPendingTaskCountsLogMessage() {
        StringBuilder sb = new StringBuilder();
        int totalCount = 0;
        sb.append("numPriorityLevels=").append(this.pendingTasks.size()).append(". ");
        for (Map.Entry<Priority, List<TaskInfo>> entry : this.pendingTasks.entrySet()) {
            int count = entry.getValue() == null ? 0 : entry.getValue().size();
            sb.append("[p=").append(entry.getKey().toString()).append(",c=").append(count).append("]");
            totalCount += count;
        }
        sb.append(". totalPendingTasks=").append(totalCount);
        sb.append(". delayedTaskQueueSize=").append(this.delayedTaskQueue.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduleResult scheduleTask(TaskInfo taskInfo) {
        SelectHostResult selectHostResult = this.selectHost(taskInfo);
        if (selectHostResult.scheduleResult == ScheduleResult.SCHEDULED) {
            NodeServiceInstancePair nsPair = selectHostResult.nodeServiceInstancePair;
            Container container = this.containerFactory.createContainer(this.resourcePerExecutor, taskInfo.priority, nsPair.getServiceInstance().getHost(), nsPair.getServiceInstance().getRpcPort(), nsPair.getServiceInstance().getServicesAddress());
            this.writeLock.lock();
            try {
                LOG.info("Assigned task {} to container {} on node={}", new Object[]{taskInfo, container.getId(), nsPair.getServiceInstance()});
                this.dagStats.registerTaskAllocated(taskInfo.requestedHosts, taskInfo.requestedRacks, nsPair.getServiceInstance().getHost());
                taskInfo.setAssignmentInfo(nsPair.getServiceInstance(), container.getId(), this.clock.getTime());
                this.registerRunningTask(taskInfo);
                nsPair.getNodeInfo().registerTaskScheduled();
            }
            finally {
                this.writeLock.unlock();
            }
            this.getContext().taskAllocated(taskInfo.task, taskInfo.clientCookie, container);
        }
        return selectHostResult.scheduleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preemptTasks(int forPriority, int numTasksToPreempt, String[] potentialHosts) {
        HashSet preemptHosts = potentialHosts == null ? null : Sets.newHashSet((Object[])potentialHosts);
        this.writeLock.lock();
        LinkedList<TaskInfo> preemptedTaskList = null;
        try {
            NavigableMap<Integer, TreeSet<TaskInfo>> orderedMap = this.runningTasks.descendingMap();
            Iterator iterator = orderedMap.entrySet().iterator();
            int preemptedCount = 0;
            while (iterator.hasNext() && preemptedCount < numTasksToPreempt) {
                Map.Entry entryAtPriority = iterator.next();
                if ((Integer)entryAtPriority.getKey() > forPriority) {
                    Iterator taskInfoIterator = ((TreeSet)entryAtPriority.getValue()).iterator();
                    while (taskInfoIterator.hasNext() && preemptedCount < numTasksToPreempt) {
                        TaskInfo taskInfo = (TaskInfo)taskInfoIterator.next();
                        if (preemptHosts != null && !preemptHosts.contains(taskInfo.assignedInstance.getHost())) continue;
                        ++preemptedCount;
                        LOG.info("preempting {} for task at priority {} with potentialHosts={}", new Object[]{taskInfo, forPriority, potentialHosts == null ? "" : Arrays.toString(potentialHosts)});
                        taskInfo.setPreemptedInfo(this.clock.getTime());
                        if (preemptedTaskList == null) {
                            preemptedTaskList = new LinkedList<TaskInfo>();
                        }
                        this.dagStats.registerTaskPreempted(taskInfo.assignedInstance.getHost());
                        preemptedTaskList.add(taskInfo);
                        this.registerPendingPreemption(taskInfo.assignedInstance.getHost());
                        taskInfoIterator.remove();
                    }
                    if (!((TreeSet)entryAtPriority.getValue()).isEmpty()) continue;
                    iterator.remove();
                    continue;
                }
                LOG.info("No tasks qualify as killable to schedule tasks at priority {}", (Object)forPriority);
                break;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (preemptedTaskList != null) {
            for (TaskInfo taskInfo : preemptedTaskList) {
                LOG.info("Preempting task {}", (Object)taskInfo);
                this.getContext().preemptContainer(taskInfo.containerId);
            }
        }
    }

    private void registerPendingPreemption(String host) {
        this.writeLock.lock();
        try {
            MutableInt val;
            this.pendingPreemptions.incrementAndGet();
            if (this.metrics != null) {
                this.metrics.incrPendingPreemptionTasksCount();
            }
            if ((val = this.pendingPreemptionsPerHost.get(host)) == null) {
                val = new MutableInt(0);
                this.pendingPreemptionsPerHost.put(host, val);
            }
            val.increment();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void unregisterPendingPreemption(String host) {
        this.writeLock.lock();
        try {
            this.pendingPreemptions.decrementAndGet();
            if (this.metrics != null) {
                this.metrics.decrPendingPreemptionTasksCount();
            }
            MutableInt val = this.pendingPreemptionsPerHost.get(host);
            Preconditions.checkNotNull((Object)val);
            val.decrement();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void maybeAddToDelayedTaskQueue(TaskInfo taskInfo) {
        if (!taskInfo.shouldForceLocality() && !taskInfo.isInDelayedQueue()) {
            taskInfo.setInDelayedQueue(true);
            this.delayedTaskQueue.add(taskInfo);
        }
    }

    private String nodeToString(ServiceInstance serviceInstance, NodeInfo nodeInfo) {
        return serviceInstance.getHost() + ":" + serviceInstance.getRpcPort() + ", workerIdentity=" + serviceInstance.getWorkerIdentity() + ", webAddress=" + serviceInstance.getServicesAddress() + ", currentlyScheduledTasksOnNode=" + nodeInfo.numScheduledTasks;
    }

    @VisibleForTesting
    DelayedTaskSchedulerCallable createDelayedTaskSchedulerCallable() {
        return new DelayedTaskSchedulerCallable();
    }

    private void trySchedulingPendingTasks() {
        this.scheduleLock.lock();
        try {
            this.pendingScheduleInvocations.set(true);
            this.scheduleCondition.signal();
        }
        finally {
            this.scheduleLock.unlock();
        }
    }

    @VisibleForTesting
    static final class LocalityDelayConf {
        private final long nodeLocalityDelay;

        public LocalityDelayConf(long nodeLocalityDelay) {
            this.nodeLocalityDelay = nodeLocalityDelay;
        }

        public long getNodeLocalityDelay() {
            return this.nodeLocalityDelay;
        }

        public String toString() {
            return "LocalityDelayConf{nodeLocalityDelay=" + this.nodeLocalityDelay + '}';
        }
    }

    private static final class NodeBlacklistConf {
        private final long minDelay;
        private final long maxDelay;
        private final float backoffFactor;

        public NodeBlacklistConf(long minDelay, long maxDelay, float backoffFactor) {
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.backoffFactor = backoffFactor;
        }

        public String toString() {
            return "NodeBlacklistConf{minDelay=" + this.minDelay + ", maxDelay=" + this.maxDelay + ", backoffFactor=" + this.backoffFactor + '}';
        }
    }

    private static class NodeServiceInstancePair {
        final NodeInfo nodeInfo;
        final ServiceInstance serviceInstance;

        private NodeServiceInstancePair(ServiceInstance serviceInstance, NodeInfo nodeInfo) {
            this.serviceInstance = serviceInstance;
            this.nodeInfo = nodeInfo;
        }

        public ServiceInstance getServiceInstance() {
            return this.serviceInstance;
        }

        public NodeInfo getNodeInfo() {
            return this.nodeInfo;
        }
    }

    private static class SelectHostResult {
        final NodeServiceInstancePair nodeServiceInstancePair;
        final ScheduleResult scheduleResult;

        SelectHostResult(ServiceInstance serviceInstance, NodeInfo nodeInfo) {
            this.nodeServiceInstancePair = new NodeServiceInstancePair(serviceInstance, nodeInfo);
            this.scheduleResult = ScheduleResult.SCHEDULED;
        }

        SelectHostResult(ScheduleResult scheduleResult) {
            this.nodeServiceInstancePair = null;
            this.scheduleResult = scheduleResult;
        }
    }

    private static class TaskStartComparator
    implements Comparator<TaskInfo> {
        private TaskStartComparator() {
        }

        @Override
        public int compare(TaskInfo o1, TaskInfo o2) {
            if (o1.startTime > o2.startTime) {
                return -1;
            }
            if (o1.startTime < o2.startTime) {
                return 1;
            }
            if (o1.uniqueId > o2.uniqueId) {
                return -1;
            }
            if (o1.uniqueId < o2.uniqueId) {
                return 1;
            }
            return 0;
        }
    }

    @VisibleForTesting
    static class TaskInfo
    implements Delayed {
        static final AtomicLong ID_GEN = new AtomicLong(0L);
        final long uniqueId;
        final LocalityDelayConf localityDelayConf;
        final Clock clock;
        final Object task;
        final Object clientCookie;
        final Priority priority;
        final Resource capability;
        final String[] requestedHosts;
        final String[] requestedRacks;
        final long requestTime;
        final long localityDelayTimeout;
        long startTime;
        long preemptTime;
        ContainerId containerId;
        ServiceInstance assignedInstance;
        private State state = State.PENDING;
        boolean inDelayedQueue = false;
        private int numAssignAttempts = 0;

        public TaskInfo(LocalityDelayConf localityDelayConf, Clock clock, Object task, Object clientCookie, Priority priority, Resource capability, String[] hosts, String[] racks, long requestTime) {
            this.localityDelayConf = localityDelayConf;
            this.clock = clock;
            this.task = task;
            this.clientCookie = clientCookie;
            this.priority = priority;
            this.capability = capability;
            this.requestedHosts = hosts;
            this.requestedRacks = racks;
            this.requestTime = requestTime;
            this.localityDelayTimeout = localityDelayConf.getNodeLocalityDelay() == -1L ? Long.MAX_VALUE : (localityDelayConf.getNodeLocalityDelay() == 0L ? 0L : requestTime + localityDelayConf.getNodeLocalityDelay());
            this.uniqueId = ID_GEN.getAndIncrement();
        }

        synchronized void setAssignmentInfo(ServiceInstance instance, ContainerId containerId, long startTime) {
            this.assignedInstance = instance;
            this.containerId = containerId;
            this.startTime = startTime;
            this.state = State.ASSIGNED;
        }

        synchronized void setPreemptedInfo(long preemptTime) {
            this.state = State.PREEMPTED;
            this.preemptTime = preemptTime;
        }

        synchronized void setInDelayedQueue(boolean val) {
            this.inDelayedQueue = val;
        }

        synchronized void triedAssigningTask() {
            ++this.numAssignAttempts;
        }

        synchronized int getNumPreviousAssignAttempts() {
            return this.numAssignAttempts;
        }

        synchronized State getState() {
            return this.state;
        }

        synchronized boolean isInDelayedQueue() {
            return this.inDelayedQueue;
        }

        boolean shouldDelayForLocality(long schedulerAttemptTime) {
            return this.localityDelayTimeout > schedulerAttemptTime;
        }

        boolean shouldForceLocality() {
            return this.localityDelayTimeout == Long.MAX_VALUE;
        }

        long getLocalityDelayTimeout() {
            return this.localityDelayTimeout;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)o;
            if (this.uniqueId != taskInfo.uniqueId) {
                return false;
            }
            return this.task.equals(taskInfo.task);
        }

        public int hashCode() {
            int result = (int)(this.uniqueId ^ this.uniqueId >>> 32);
            result = 31 * result + this.task.hashCode();
            return result;
        }

        public String toString() {
            return "TaskInfo{task=" + this.task + ", priority=" + this.priority + ", startTime=" + this.startTime + ", containerId=" + this.containerId + ", assignedInstance=" + this.assignedInstance + ", uniqueId=" + this.uniqueId + ", localityDelayTimeout=" + this.localityDelayTimeout + '}';
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.localityDelayTimeout - this.clock.getTime(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            TaskInfo other = (TaskInfo)o;
            if (other.localityDelayTimeout > this.localityDelayTimeout) {
                return -1;
            }
            if (other.localityDelayTimeout < this.localityDelayTimeout) {
                return 1;
            }
            return 0;
        }

        static enum State {
            PENDING,
            ASSIGNED,
            PREEMPTED;

        }
    }

    @VisibleForTesting
    static class StatsPerDag {
        int numRequestedAllocations = 0;
        int numRequestsWithLocation = 0;
        int numRequestsWithoutLocation = 0;
        int numTotalAllocations = 0;
        int numLocalAllocations = 0;
        int numNonLocalAllocations = 0;
        int numAllocationsNoLocalityRequest = 0;
        int numRejectedTasks = 0;
        int numCommFailures = 0;
        int numDelayedAllocations = 0;
        int numPreemptedTasks = 0;
        Map<String, AtomicInteger> localityBasedNumAllocationsPerHost = new HashMap<String, AtomicInteger>();
        Map<String, AtomicInteger> numAllocationsPerHost = new HashMap<String, AtomicInteger>();

        StatsPerDag() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NumPreemptedTasks=").append(this.numPreemptedTasks).append(", ");
            sb.append("NumRequestedAllocations=").append(this.numRequestedAllocations).append(", ");
            sb.append("NumRequestsWithlocation=").append(this.numRequestsWithLocation).append(", ");
            sb.append("NumLocalAllocations=").append(this.numLocalAllocations).append(",");
            sb.append("NumNonLocalAllocations=").append(this.numNonLocalAllocations).append(",");
            sb.append("NumTotalAllocations=").append(this.numTotalAllocations).append(",");
            sb.append("NumRequestsWithoutLocation=").append(this.numRequestsWithoutLocation).append(", ");
            sb.append("NumRejectedTasks=").append(this.numRejectedTasks).append(", ");
            sb.append("NumCommFailures=").append(this.numCommFailures).append(", ");
            sb.append("NumDelayedAllocations=").append(this.numDelayedAllocations).append(", ");
            sb.append("LocalityBasedAllocationsPerHost=").append(this.localityBasedNumAllocationsPerHost).append(", ");
            sb.append("NumAllocationsPerHost=").append(this.numAllocationsPerHost);
            return sb.toString();
        }

        void registerTaskRequest(String[] requestedHosts, String[] requestedRacks) {
            ++this.numRequestedAllocations;
            if (requestedHosts != null && requestedHosts.length != 0) {
                ++this.numRequestsWithLocation;
            } else {
                ++this.numRequestsWithoutLocation;
            }
        }

        void registerTaskAllocated(String[] requestedHosts, String[] requestedRacks, String allocatedHost) {
            if (requestedHosts != null && requestedHosts.length != 0) {
                HashSet<String> requestedHostSet = new HashSet<String>(Arrays.asList(requestedHosts));
                if (requestedHostSet.contains(allocatedHost)) {
                    ++this.numLocalAllocations;
                    this._registerAllocationInHostMap(allocatedHost, this.localityBasedNumAllocationsPerHost);
                } else {
                    ++this.numNonLocalAllocations;
                }
            } else {
                ++this.numAllocationsNoLocalityRequest;
            }
            ++this.numTotalAllocations;
            this._registerAllocationInHostMap(allocatedHost, this.numAllocationsPerHost);
        }

        void registerTaskPreempted(String host) {
            ++this.numPreemptedTasks;
        }

        void registerCommFailure(String host) {
            ++this.numCommFailures;
        }

        void registerTaskRejected(String host) {
            ++this.numRejectedTasks;
        }

        void registerDelayedAllocation() {
            ++this.numDelayedAllocations;
        }

        private void _registerAllocationInHostMap(String host, Map<String, AtomicInteger> hostMap) {
            AtomicInteger val = hostMap.get(host);
            if (val == null) {
                val = new AtomicInteger(0);
                hostMap.put(host, val);
            }
            val.incrementAndGet();
        }
    }

    @VisibleForTesting
    static class NodeInfo
    implements Delayed {
        private final NodeBlacklistConf blacklistConf;
        final ServiceInstance serviceInstance;
        private final Clock clock;
        long expireTimeMillis = -1L;
        private long numSuccessfulTasks = 0L;
        private long numSuccessfulTasksAtLastBlacklist = -1L;
        float cumulativeBackoffFactor = 1.0f;
        private boolean hadCommFailure = false;
        private boolean disabled = false;
        private int numPreemptedTasks = 0;
        private int numScheduledTasks = 0;
        private final int numSchedulableTasks;
        private final LlapTaskSchedulerMetrics metrics;

        NodeInfo(ServiceInstance serviceInstance, NodeBlacklistConf blacklistConf, Clock clock, int numSchedulableTasksConf, LlapTaskSchedulerMetrics metrics) {
            Preconditions.checkArgument((numSchedulableTasksConf >= -1 ? 1 : 0) != 0, (Object)"NumSchedulableTasks must be >=-1");
            this.serviceInstance = serviceInstance;
            this.blacklistConf = blacklistConf;
            this.clock = clock;
            this.metrics = metrics;
            if (numSchedulableTasksConf == 0) {
                int pendingQueueuCapacity = 0;
                String pendingQueueCapacityString = (String)serviceInstance.getProperties().get(HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_WAIT_QUEUE_SIZE.varname);
                LOG.info("Setting up node: {} with available capacity={}, pendingQueueSize={}, memory={}", new Object[]{serviceInstance, serviceInstance.getResource().getVirtualCores(), pendingQueueCapacityString, serviceInstance.getResource().getMemory()});
                if (pendingQueueCapacityString != null) {
                    pendingQueueuCapacity = Integer.parseInt(pendingQueueCapacityString);
                }
                this.numSchedulableTasks = serviceInstance.getResource().getVirtualCores() + pendingQueueuCapacity;
            } else {
                this.numSchedulableTasks = numSchedulableTasksConf;
                LOG.info("Setting up node: " + serviceInstance + " with schedulableCapacity=" + this.numSchedulableTasks);
            }
            if (metrics != null) {
                metrics.incrSchedulableTasksCount(this.numSchedulableTasks);
            }
        }

        ServiceInstance getServiceInstance() {
            return this.serviceInstance;
        }

        void enableNode() {
            this.expireTimeMillis = -1L;
            this.disabled = false;
            this.hadCommFailure = false;
        }

        void disableNode(boolean commFailure) {
            long duration = this.blacklistConf.minDelay;
            long currentTime = this.clock.getTime();
            this.hadCommFailure = commFailure;
            this.disabled = true;
            this.cumulativeBackoffFactor = this.numSuccessfulTasksAtLastBlacklist == this.numSuccessfulTasks ? (this.cumulativeBackoffFactor *= this.blacklistConf.backoffFactor) : 1.0f;
            long delayTime = (long)((float)duration * this.cumulativeBackoffFactor);
            if (delayTime > this.blacklistConf.maxDelay) {
                delayTime = this.blacklistConf.maxDelay;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Disabling instance {} for {} milli-seconds. commFailure={}", new Object[]{this.serviceInstance, delayTime, commFailure});
            }
            this.expireTimeMillis = currentTime + delayTime;
            this.numSuccessfulTasksAtLastBlacklist = this.numSuccessfulTasks;
        }

        void registerTaskScheduled() {
            ++this.numScheduledTasks;
            if (this.metrics != null) {
                this.metrics.incrRunningTasksCount();
                this.metrics.decrSchedulableTasksCount();
            }
        }

        void registerTaskSuccess() {
            ++this.numSuccessfulTasks;
            --this.numScheduledTasks;
            if (this.metrics != null) {
                this.metrics.incrSuccessfulTasksCount();
                this.metrics.decrRunningTasksCount();
                this.metrics.incrSchedulableTasksCount();
            }
        }

        void registerUnsuccessfulTaskEnd(boolean wasPreempted) {
            --this.numScheduledTasks;
            if (this.metrics != null) {
                this.metrics.decrRunningTasksCount();
                this.metrics.incrSchedulableTasksCount();
            }
            if (wasPreempted) {
                ++this.numPreemptedTasks;
                if (this.metrics != null) {
                    this.metrics.incrPreemptedTasksCount();
                }
            }
        }

        public long getEnableTime() {
            return this.expireTimeMillis;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean hadCommFailure() {
            return this.hadCommFailure;
        }

        public boolean canAcceptTask() {
            boolean result;
            boolean bl = result = !this.hadCommFailure && !this.disabled && this.serviceInstance.isAlive() && (this.numSchedulableTasks == -1 || this.numSchedulableTasks - this.numScheduledTasks > 0);
            if (LOG.isInfoEnabled()) {
                LOG.info("Node[" + this.serviceInstance.getHost() + ":" + this.serviceInstance.getRpcPort() + ", " + this.serviceInstance.getWorkerIdentity() + "]: canAcceptTask={}, numScheduledTasks={}, numSchedulableTasks={}, hadCommFailure={}, disabled={}, serviceInstance.isAlive={}", new Object[]{result, this.numScheduledTasks, this.numSchedulableTasks, this.hadCommFailure, this.disabled, this.serviceInstance.isAlive()});
            }
            return result;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireTimeMillis - this.clock.getTime(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            NodeInfo other = (NodeInfo)o;
            if (other.expireTimeMillis > this.expireTimeMillis) {
                return -1;
            }
            if (other.expireTimeMillis < this.expireTimeMillis) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "NodeInfo{instance=" + this.serviceInstance + ", expireTimeMillis=" + this.expireTimeMillis + ", numSuccessfulTasks=" + this.numSuccessfulTasks + ", numSuccessfulTasksAtLastBlacklist=" + this.numSuccessfulTasksAtLastBlacklist + ", cumulativeBackoffFactor=" + this.cumulativeBackoffFactor + ", numSchedulableTasks=" + this.numSchedulableTasks + ", numScheduledTasks=" + this.numScheduledTasks + ", disabled=" + this.disabled + ", commFailures=" + this.hadCommFailure + '}';
        }
    }

    private class SchedulerCallable
    implements Callable<Void> {
        private AtomicBoolean isShutdown = new AtomicBoolean(false);

        private SchedulerCallable() {
        }

        @Override
        public Void call() {
            while (!this.isShutdown.get() && !Thread.currentThread().isInterrupted()) {
                LlapTaskSchedulerService.this.scheduleLock.lock();
                try {
                    while (!LlapTaskSchedulerService.this.pendingScheduleInvocations.get()) {
                        LlapTaskSchedulerService.this.scheduleCondition.await();
                    }
                }
                catch (InterruptedException e) {
                    if (this.isShutdown.get()) {
                        LOG.info("Scheduler thread interrupted after shutdown");
                        break;
                    }
                    LOG.warn("Scheduler thread interrupted without being shutdown");
                    throw new RuntimeException("Scheduler thread interrupted without being shutdown", e);
                }
                finally {
                    LlapTaskSchedulerService.this.scheduleLock.unlock();
                }
                LlapTaskSchedulerService.this.pendingScheduleInvocations.set(false);
                LlapTaskSchedulerService.this.schedulePendingTasks();
            }
            return null;
        }

        public void shutdown() {
            this.isShutdown.set(true);
        }
    }

    private class SchedulerTimeoutMonitor
    implements Runnable {
        private final Logger LOG = LoggerFactory.getLogger(SchedulerTimeoutMonitor.class);

        private SchedulerTimeoutMonitor() {
        }

        @Override
        public void run() {
            this.LOG.info("Reporting SERVICE_UNAVAILABLE error as no instances are running");
            try {
                LlapTaskSchedulerService.this.getContext().reportError((ServicePluginError)ServicePluginErrorDefaults.SERVICE_UNAVAILABLE, "No LLAP Daemons are running", LlapTaskSchedulerService.this.getContext().getCurrentDagInfo());
            }
            catch (Exception e) {
                this.LOG.error("Exception when reporting SERVICE_UNAVAILABLE error for dag: {}", (Object)LlapTaskSchedulerService.this.getContext().getCurrentDagInfo().getName(), (Object)e);
            }
        }
    }

    private class NodeEnablerCallable
    implements Callable<Void> {
        private final AtomicBoolean isShutdown = new AtomicBoolean(false);
        private static final long REFRESH_INTERVAL = 10000L;
        long nextPollInterval = 10000L;
        long lastRefreshTime;

        private NodeEnablerCallable() {
        }

        @Override
        public Void call() {
            this.lastRefreshTime = LlapTaskSchedulerService.this.clock.getTime();
            if (!this.isShutdown.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    while (true) {
                        NodeInfo nodeInfo;
                        if ((nodeInfo = (NodeInfo)LlapTaskSchedulerService.this.disabledNodesQueue.poll(this.nextPollInterval, TimeUnit.MILLISECONDS)) != null) {
                            long currentTime = LlapTaskSchedulerService.this.clock.getTime();
                            LlapTaskSchedulerService.this.reenableDisabledNode(nodeInfo);
                            LlapTaskSchedulerService.this.trySchedulingPendingTasks();
                            this.nextPollInterval -= currentTime - this.lastRefreshTime;
                        }
                        if (this.nextPollInterval >= 0L && nodeInfo != null) continue;
                        this.nextPollInterval = 10000L;
                        this.lastRefreshTime = LlapTaskSchedulerService.this.clock.getTime();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Refreshing instances based on poll interval");
                        }
                        LlapTaskSchedulerService.this.scanForNodeChanges();
                    }
                }
                catch (InterruptedException e) {
                    if (this.isShutdown.get()) {
                        LOG.info("NodeEnabler thread interrupted after shutdown");
                    }
                    LOG.warn("NodeEnabler thread interrupted without being shutdown");
                    throw new RuntimeException("NodeEnabler thread interrupted without being shutdown", e);
                }
            }
            return null;
        }

        public void shutdown() {
            this.isShutdown.set(true);
        }
    }

    @VisibleForTesting
    class DelayedTaskSchedulerCallable
    implements Callable<Void> {
        private final AtomicBoolean isShutdown = new AtomicBoolean(false);

        DelayedTaskSchedulerCallable() {
        }

        @Override
        public Void call() {
            while (!this.isShutdown.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    TaskInfo taskInfo = this.getNextTask();
                    taskInfo.setInDelayedQueue(false);
                    this.processEvictedTask(taskInfo);
                }
                catch (InterruptedException e) {
                    if (this.isShutdown.get()) {
                        LOG.info("DelayedTaskScheduler thread interrupted after shutdown");
                        break;
                    }
                    LOG.warn("DelayedTaskScheduler thread interrupted before being shutdown");
                    throw new RuntimeException("DelayedTaskScheduler thread interrupted without being shutdown", e);
                }
            }
            return null;
        }

        public void shutdown() {
            this.isShutdown.set(true);
        }

        public TaskInfo getNextTask() throws InterruptedException {
            return (TaskInfo)LlapTaskSchedulerService.this.delayedTaskQueue.take();
        }

        public void processEvictedTask(TaskInfo taskInfo) {
            if (this.shouldScheduleTask(taskInfo)) {
                LlapTaskSchedulerService.this.trySchedulingPendingTasks();
            }
        }

        public boolean shouldScheduleTask(TaskInfo taskInfo) {
            return taskInfo.getState() == TaskInfo.State.PENDING;
        }
    }

    private static enum ScheduleResult {
        SCHEDULED,
        DELAYED_LOCALITY,
        DELAYED_RESOURCES,
        INADEQUATE_TOTAL_RESOURCES;

    }

    private class NodeStateChangeListener
    implements ServiceInstanceStateChangeListener {
        private final Logger LOG = LoggerFactory.getLogger(NodeStateChangeListener.class);

        private NodeStateChangeListener() {
        }

        public void onCreate(ServiceInstance serviceInstance) {
            LlapTaskSchedulerService.this.addNode(serviceInstance, new NodeInfo(serviceInstance, LlapTaskSchedulerService.this.nodeBlacklistConf, LlapTaskSchedulerService.this.clock, LlapTaskSchedulerService.this.numSchedulableTasksPerNode, LlapTaskSchedulerService.this.metrics));
            this.LOG.info("Added node with identity: {}", (Object)serviceInstance.getWorkerIdentity());
        }

        public void onUpdate(ServiceInstance serviceInstance) {
            LlapTaskSchedulerService.this.instanceToNodeMap.put(serviceInstance.getWorkerIdentity(), new NodeInfo(serviceInstance, LlapTaskSchedulerService.this.nodeBlacklistConf, LlapTaskSchedulerService.this.clock, LlapTaskSchedulerService.this.numSchedulableTasksPerNode, LlapTaskSchedulerService.this.metrics));
            this.LOG.info("Updated node with identity: {}", (Object)serviceInstance.getWorkerIdentity());
        }

        public void onRemove(ServiceInstance serviceInstance) {
            this.LOG.info("Removed node with identity: {}", (Object)serviceInstance.getWorkerIdentity());
            if (LlapTaskSchedulerService.this.metrics != null) {
                LlapTaskSchedulerService.this.metrics.setClusterNodeCount(LlapTaskSchedulerService.this.activeInstances.size());
            }
            if (LlapTaskSchedulerService.this.activeInstances.size() == 0) {
                this.LOG.info("No node found. Signalling scheduler timeout monitor thread to start timer.");
                LlapTaskSchedulerService.this.startTimeoutMonitor();
            }
        }
    }
}

