/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.spark.JobStatisticCollector;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.spark.SparkPigStats;
import org.apache.pig.tools.pigstats.spark.SparkPigStatusReporter;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkStatsUtil {
    public static final String SPARK_STORE_COUNTER_GROUP = "MultiStoreCounters";
    public static final String SPARK_STORE_RECORD_COUNTER = "Output records in ";
    public static final String SPARK_INPUT_COUNTER_GROUP = "MultiInputCounters";
    public static final String SPARK_INPUT_RECORD_COUNTER = "Input records from ";

    public static void waitForJobAddStats(int jobID, POStore poStore, SparkOperator sparkOperator, JobStatisticCollector jobStatisticCollector, JavaSparkContext sparkContext, SparkPigStats sparkPigStats) throws InterruptedException {
        jobStatisticCollector.waitForJobToEnd(jobID);
        sparkPigStats.addJobStats(poStore, sparkOperator, jobID, jobStatisticCollector, sparkContext);
        jobStatisticCollector.cleanup(jobID);
    }

    public static void addFailJobStats(String jobID, POStore poStore, SparkOperator sparkOperator, SparkPigStats sparkPigStats, Exception e) {
        sparkPigStats.addFailJobStats(poStore, sparkOperator, jobID, null, null, e);
    }

    public static String getCounterName(POStore store) {
        String shortName = PigStatsUtil.getShortName(store.getSFile().getFileName());
        StringBuffer sb = new StringBuffer(SPARK_STORE_RECORD_COUNTER);
        sb.append("_");
        sb.append(store.getIndex());
        sb.append("_");
        sb.append(store.getOperatorKey());
        sb.append("_");
        sb.append(shortName);
        return sb.toString();
    }

    public static String getCounterName(POLoad load) {
        String shortName = PigStatsUtil.getShortName(load.getLFile().getFileName());
        StringBuffer sb = new StringBuffer(SPARK_INPUT_RECORD_COUNTER);
        sb.append("_");
        sb.append(load.getOperatorKey());
        sb.append("_");
        sb.append(shortName);
        return sb.toString();
    }

    public static long getRecordCount(POStore store) {
        SparkPigStatusReporter reporter = SparkPigStatusReporter.getInstance();
        Object value = reporter.getCounters().getValue(SPARK_STORE_COUNTER_GROUP, SparkStatsUtil.getCounterName(store));
        if (value == null) {
            return 0L;
        }
        return (Long)value;
    }

    public static long getRecordCount(POLoad load) {
        SparkPigStatusReporter reporter = SparkPigStatusReporter.getInstance();
        int loadersCount = SparkStatsUtil.countCoLoadsIfInSplit(load, load.getParentPlan());
        Object value = reporter.getCounters().getValue(SPARK_INPUT_COUNTER_GROUP, SparkStatsUtil.getCounterName(load));
        if (value == null) {
            return 0L;
        }
        return (Long)value / (long)loadersCount;
    }

    private static int countCoLoadsIfInSplit(PhysicalOperator op, PhysicalPlan pp) {
        List<PhysicalOperator> successors = pp.getSuccessors(op);
        if (successors == null || successors.size() == 0) {
            return 1;
        }
        Iterator<PhysicalOperator> iterator = successors.iterator();
        if (iterator.hasNext()) {
            PhysicalOperator successor = iterator.next();
            if (successor instanceof POSplit) {
                return ((POSplit)successor).getPlans().size();
            }
            return SparkStatsUtil.countCoLoadsIfInSplit(successor, pp);
        }
        return 1;
    }

    public static boolean isJobSuccess(int jobID, JavaSparkContext sparkContext) {
        if (jobID == -1) {
            return true;
        }
        JobExecutionStatus status = SparkStatsUtil.getJobInfo(jobID, sparkContext).status();
        if (status == JobExecutionStatus.SUCCEEDED) {
            return true;
        }
        if (status != JobExecutionStatus.FAILED) {
            throw new RuntimeException("Unexpected job execution status " + status);
        }
        return false;
    }

    private static SparkJobInfo getJobInfo(int jobID, JavaSparkContext sparkContext) {
        SparkJobInfo jobInfo = sparkContext.statusTracker().getJobInfo(jobID);
        if (jobInfo == null) {
            throw new RuntimeException("No jobInfo available for jobID " + jobID);
        }
        return jobInfo;
    }

    public static void addNativeJobStats(PigStats ps, NativeSparkOperator nativeSparkOperator) {
        ((SparkPigStats)ps).addNativeJobStats(nativeSparkOperator, nativeSparkOperator.getJobId(), true, null);
    }

    public static void addFailedNativeJobStats(PigStats ps, NativeSparkOperator nativeSparkOperator, Exception e) {
        ((SparkPigStats)ps).addNativeJobStats(nativeSparkOperator, nativeSparkOperator.getJobId(), false, e);
    }
}

