/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.StoreFuncMetadataWrapper;
import org.apache.pig.StoreMetadata;
import org.apache.pig.StoreResources;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.JarManager;

public class ParquetStorer
extends StoreFuncMetadataWrapper
implements StoreResources {
    private static final String PARQUET_STORER_FQCN = "org.apache.parquet.pig.ParquetStorer";

    public ParquetStorer() throws FrontendException {
        Throwable exception = null;
        try {
            this.init((StoreMetadata)Class.forName(PARQUET_STORER_FQCN).newInstance());
        }
        catch (NoClassDefFoundError e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        if (exception != null) {
            throw new FrontendException(String.format("Cannot instantiate class %s (%s)", this.getClass().getName(), PARQUET_STORER_FQCN), 2259, exception);
        }
    }

    private void init(StoreMetadata storeMetadata) {
        this.setStoreFunc(storeMetadata);
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        try {
            JarManager.addDependencyJars(job, Class.forName("org.apache.parquet.Version"));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Runtime parquet dependency not found", e);
        }
        super.setStoreLocation(location, job);
    }

    @Override
    public List<String> getCacheFiles() {
        return null;
    }

    @Override
    public List<String> getShipFiles() {
        LinkedList<Class> classList = new LinkedList<Class>();
        try {
            classList.add(Class.forName(PARQUET_STORER_FQCN));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Cannot find class %s (%s)", this.getClass().getName(), PARQUET_STORER_FQCN), e);
        }
        return FuncUtils.getShipFiles(classList);
    }
}

