/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class MergeCogroupConverter
implements RDDConverter<Tuple, Tuple, POMergeCogroup> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POMergeCogroup physicalOperator) {
        SparkUtil.assertPredecessorSize(predecessors, physicalOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        MergeCogroupFunction mergeCogroupFunction = new MergeCogroupFunction(physicalOperator);
        return rdd.toJavaRDD().mapPartitions(SparkShims.getInstance().flatMapFunction(mergeCogroupFunction), true).rdd();
    }

    private static class MergeCogroupFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple>,
    Serializable {
        private POMergeCogroup poMergeCogroup;

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> input) {
            return new OutputConsumerIterator(input){

                @Override
                protected void attach(Tuple tuple) {
                    poMergeCogroup.setInputs(null);
                    poMergeCogroup.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    return poMergeCogroup.getNextTuple();
                }

                @Override
                protected void endOfInput() {
                    poMergeCogroup.setEndOfInput(true);
                }
            };
        }

        private MergeCogroupFunction(POMergeCogroup poMergeCogroup) {
            this.poMergeCogroup = poMergeCogroup;
        }
    }
}

