/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.PairFlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkShims;
import org.apache.pig.data.Tuple;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.Spark2JobStats;
import org.apache.pig.tools.pigstats.spark.SparkJobStats;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import scala.Option;
import scala.Tuple2;

public class Spark2Shims
extends SparkShims {
    public <T, R> FlatMapFunction flatMapFunction(final FlatMapFunctionAdapter<T, R> function) {
        return new FlatMapFunction<T, R>(){

            public Iterator<R> call(T t) throws Exception {
                return function.call(t);
            }
        };
    }

    @Override
    public <T, K, V> PairFlatMapFunction<T, K, V> pairFlatMapFunction(final PairFlatMapFunctionAdapter<T, K, V> function) {
        return new PairFlatMapFunction<T, K, V>(){

            public Iterator<Tuple2<K, V>> call(T t) throws Exception {
                return function.call(t);
            }
        };
    }

    @Override
    public RDD<Tuple> coalesce(RDD<Tuple> rdd, int numPartitions, boolean shuffle) {
        return rdd.coalesce(numPartitions, shuffle, Option.empty(), null);
    }

    @Override
    public SparkJobStats sparkJobStats(int jobId, PigStats.JobGraph plan, Configuration conf) {
        return new Spark2JobStats(jobId, plan, conf);
    }

    @Override
    public SparkJobStats sparkJobStats(String jobId, PigStats.JobGraph plan, Configuration conf) {
        return new Spark2JobStats(jobId, plan, conf);
    }

    @Override
    public <T> SparkShims.OptionalWrapper<T> wrapOptional(T tuple) {
        final Optional t = (Optional)tuple;
        return new SparkShims.OptionalWrapper<T>(){

            @Override
            public boolean isPresent() {
                return t.isPresent();
            }

            @Override
            public T get() {
                return t.get();
            }
        };
    }

    @Override
    public SparkListener getJobMetricsListener(Map<Integer, int[]> jobIdToStageId, Map<Integer, Integer> stageIdToJobId, Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics, Set<Integer> finishedJobIds) {
        return new JobMetricsListener(jobIdToStageId, stageIdToJobId, allJobMetrics, finishedJobIds);
    }

    @Override
    public void addSparkListener(SparkContext sc, SparkListener sparkListener) {
        sc.addSparkListener((SparkListenerInterface)sparkListener);
    }

    private static class JobMetricsListener
    extends SparkListener {
        private final Log LOG = LogFactory.getLog(JobMetricsListener.class);
        private Map<Integer, int[]> jobIdToStageId;
        private Map<Integer, Integer> stageIdToJobId;
        private Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics;
        private Set<Integer> finishedJobIds;

        JobMetricsListener(Map<Integer, int[]> jobIdToStageId, Map<Integer, Integer> stageIdToJobId, Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics, Set<Integer> finishedJobIds) {
            this.jobIdToStageId = jobIdToStageId;
            this.stageIdToJobId = stageIdToJobId;
            this.allJobMetrics = allJobMetrics;
            this.finishedJobIds = finishedJobIds;
        }

        public synchronized void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
            int stageId = stageCompleted.stageInfo().stageId();
            int stageAttemptId = stageCompleted.stageInfo().attemptId();
            String stageIdentifier = stageId + "_" + stageAttemptId;
            Integer jobId = this.stageIdToJobId.get(stageId);
            if (jobId == null) {
                this.LOG.warn((Object)("Cannot find job id for stage[" + stageId + "]."));
            } else {
                List stageMetrics;
                HashMap jobMetrics = this.allJobMetrics.get(jobId);
                if (jobMetrics == null) {
                    jobMetrics = Maps.newHashMap();
                    this.allJobMetrics.put(jobId, jobMetrics);
                }
                if ((stageMetrics = (List)jobMetrics.get(stageIdentifier)) == null) {
                    stageMetrics = Lists.newLinkedList();
                    jobMetrics.put(stageIdentifier, stageMetrics);
                }
                stageMetrics.add(stageCompleted.stageInfo().taskMetrics());
            }
        }

        public synchronized void onJobStart(SparkListenerJobStart jobStart) {
            int jobId = jobStart.jobId();
            int size = jobStart.stageIds().size();
            int[] intStageIds = new int[size];
            for (int i = 0; i < size; ++i) {
                Integer stageId = (Integer)jobStart.stageIds().apply(i);
                intStageIds[i] = stageId;
                this.stageIdToJobId.put(stageId, jobId);
            }
            this.jobIdToStageId.put(jobId, intStageIds);
        }

        public synchronized void onJobEnd(SparkListenerJobEnd jobEnd) {
            this.finishedJobIds.add(jobEnd.jobId());
            ((Object)((Object)this)).notify();
        }
    }
}

