/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.hive.HiveImport;
import com.cloudera.sqoop.orm.ClassWriter;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class CodeGenTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)CodeGenTool.class.getName());
    private List<String> generatedJarFiles = new ArrayList<String>();

    public CodeGenTool() {
        super("codegen");
    }

    public List<String> getGeneratedJarFiles() {
        ArrayList<String> out = new ArrayList<String>(this.generatedJarFiles);
        return out;
    }

    public String generateORM(SqoopOptions options, String tableName) throws IOException {
        String existingJar = options.getExistingJarName();
        if (existingJar != null) {
            if (this.manager.isORMFacilitySelfManaged()) {
                LOG.info((Object)"The connection manager declares that it self manages mapping between records & fields and rows & columns.  The jar file  provided will have no effect");
            }
            LOG.info((Object)("Using existing jar: " + existingJar));
            return existingJar;
        }
        if (this.manager.isORMFacilitySelfManaged()) {
            LOG.info((Object)"The connection manager declares that it self manages mapping between records & fields and rows & columns.  No class will will be generated.");
            return null;
        }
        LOG.info((Object)"Beginning code generation");
        if (tableName != null && options.getFileLayout() == SqoopOptions.FileLayout.ParquetFile) {
            String className;
            String string = className = options.getClassName() != null ? options.getClassName() : tableName;
            if (className.equalsIgnoreCase(tableName)) {
                className = "codegen_" + className;
                options.setClassName(className);
                LOG.info((Object)("Will generate java class as " + options.getClassName()));
            }
        }
        CompilationManager compileMgr = new CompilationManager(options);
        ClassWriter classWriter = new ClassWriter(options, this.manager, tableName, compileMgr);
        classWriter.generate();
        compileMgr.compile();
        compileMgr.jar();
        String jarFile = compileMgr.getJarFilename();
        this.generatedJarFiles.add(jarFile);
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        if (!this.init(options)) {
            return 1;
        }
        try {
            this.generateORM(options, options.getTableName());
            if (options.doHiveImport() && options.getFileLayout() != SqoopOptions.FileLayout.ParquetFile) {
                HiveImport hiveImport = new HiveImport(options, this.manager, options.getConf(), true);
                hiveImport.importTable(options.getTableName(), options.getHiveTableName(), true);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running codegen job: " + StringUtils.stringifyException((Throwable)ioe)));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ioe);
            }
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(false);
        OptionBuilder.withArgName((String)"table-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Table to generate code for");
        OptionBuilder.withLongOpt((String)"table");
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"statement");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SQL 'statement' to generate code for");
        OptionBuilder.withLongOpt((String)"query");
        codeGenOpts.addOption(OptionBuilder.create((String)"e"));
        toolOptions.addUniqueOptions(codeGenOpts);
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getHiveOptions(true));
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        super.printHelp(toolOptions);
        System.out.println("");
        System.out.println("At minimum, you must specify --connect and --table");
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("table")) {
            out.setTableName(in.getOptionValue("table"));
        }
        if (in.hasOption("query")) {
            out.setSqlQuery(in.getOptionValue("query"));
        }
        this.applyCommonOptions(in, out);
        this.applyOutputFormatOptions(in, out);
        this.applyInputFormatOptions(in, out);
        this.applyCodeGenOptions(in, out, false);
        this.applyHiveOptions(in, out);
        this.applyHCatalogOptions(in, out);
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (this.hasUnrecognizedArgs(this.extraArguments)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateCommonOptions(options);
        this.validateCodeGenOptions(options);
        this.validateOutputFormatOptions(options);
        this.validateHiveOptions(options);
        this.validateHCatalogOptions(options);
        if (options.getTableName() == null && options.getSqlQuery() == null) {
            throw new SqoopOptions.InvalidOptionsException("--table or --query is required for codegen. \nTry --help for usage instructions.");
        }
        if (options.getTableName() != null && options.getSqlQuery() != null) {
            throw new SqoopOptions.InvalidOptionsException("Cannot specify --table and --query together. \nTry --help for usage instructions.");
        }
    }
}

