/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;
import org.kitesdk.data.spi.SchemaValidationUtil;

public final class ParquetJob {
    public static final Log LOG = LogFactory.getLog((String)ParquetJob.class.getName());
    public static final String HIVE_CONF_CLASS = "org.apache.hadoop.hive.conf.HiveConf";
    public static final String HIVE_METASTORE_CLIENT_CLASS = "org.apache.hadoop.hive.metastore.HiveMetaStoreClient";
    public static final String HIVE_METASTORE_SASL_ENABLED = "hive.metastore.sasl.enabled";
    public static final String HIVE_METASTORE_TOKEN_ALIAS = "HCat Token";
    private static final String CONF_AVRO_SCHEMA = "parquetjob.avro.schema";
    static final String CONF_OUTPUT_CODEC = "parquetjob.output.codec";

    private ParquetJob() {
    }

    public static Schema getAvroSchema(Configuration conf) {
        return new Schema.Parser().parse(conf.get(CONF_AVRO_SCHEMA));
    }

    public static CompressionType getCompressionType(Configuration conf) {
        CompressionType defaults = Formats.PARQUET.getDefaultCompressionType();
        String codec = conf.get(CONF_OUTPUT_CODEC, defaults.getName());
        try {
            return CompressionType.forName((String)codec);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn((Object)String.format("Unsupported compression type '%s'. Fallback to '%s'.", codec, defaults));
            return defaults;
        }
    }

    public static void configureImportJob(JobConf conf, Schema schema, String uri, boolean reuseExistingDataset, boolean overwrite) throws IOException {
        Dataset dataset;
        Configuration hiveConf = ParquetJob.getHiveConf((Configuration)conf);
        if (uri.startsWith("dataset:hive") && ParquetJob.isSecureMetastore(hiveConf)) {
            ParquetJob.addHiveConfigs(hiveConf, (Configuration)conf);
            if (conf.getCredentials().getToken(new Text(HIVE_METASTORE_TOKEN_ALIAS)) == null) {
                ParquetJob.addHiveDelegationToken(conf);
            }
        }
        if (reuseExistingDataset || overwrite) {
            try {
                dataset = (Dataset)Datasets.load((String)uri);
            }
            catch (DatasetNotFoundException ex) {
                dataset = ParquetJob.createDataset(schema, ParquetJob.getCompressionType((Configuration)conf), uri);
            }
            Schema writtenWith = dataset.getDescriptor().getSchema();
            if (!SchemaValidationUtil.canRead((Schema)writtenWith, (Schema)schema)) {
                throw new IOException(String.format("Expected schema: %s%nActual schema: %s", writtenWith, schema));
            }
        } else {
            dataset = ParquetJob.createDataset(schema, ParquetJob.getCompressionType((Configuration)conf), uri);
        }
        conf.set(CONF_AVRO_SCHEMA, schema.toString());
        if (overwrite) {
            DatasetKeyOutputFormat.configure((Configuration)conf).overwrite((View)dataset);
        } else {
            DatasetKeyOutputFormat.configure((Configuration)conf).writeTo((View)dataset);
        }
    }

    private static Dataset createDataset(Schema schema, CompressionType compressionType, String uri) {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).compressionType(compressionType).build();
        return (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor, GenericRecord.class);
    }

    private static boolean isSecureMetastore(Configuration conf) {
        return conf != null && conf.getBoolean(HIVE_METASTORE_SASL_ENABLED, false);
    }

    private static Configuration getHiveConf(Configuration conf) {
        try {
            Class<?> HiveConfClass = Class.forName(HIVE_CONF_CLASS);
            return (Configuration)HiveConfClass.getConstructor(Configuration.class, Class.class).newInstance(conf, Configuration.class);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.conf.HiveConf. Make sure HIVE_CONF_DIR is set correctly.");
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not instantiate HiveConf instance.", (Throwable)ex);
        }
        return null;
    }

    private static void addHiveDelegationToken(JobConf conf) {
        Class<?> HiveConfClass;
        Class<?> HiveMetaStoreClientClass;
        try {
            HiveMetaStoreClientClass = Class.forName(HIVE_METASTORE_CLIENT_CLASS);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.metastore.HiveMetaStoreClient when adding hive delegation token. Make sure HIVE_CONF_DIR is set correctly.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
        try {
            HiveConfClass = Class.forName(HIVE_CONF_CLASS);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.conf.HiveConf when adding hive delegation token. Make sure HIVE_CONF_DIR is set correctly.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
        try {
            Object client = HiveMetaStoreClientClass.getConstructor(HiveConfClass).newInstance(HiveConfClass.getConstructor(Configuration.class, Class.class).newInstance(conf, Configuration.class));
            Method getDelegationTokenMethod = HiveMetaStoreClientClass.getMethod("getDelegationToken", String.class);
            Object tokenStringForm = getDelegationTokenMethod.invoke(client, UserGroupInformation.getLoginUser().getShortUserName());
            Token metastoreToken = new Token();
            metastoreToken.decodeFromUrlString(tokenStringForm.toString());
            conf.getCredentials().addToken(new Text(HIVE_METASTORE_TOKEN_ALIAS), metastoreToken);
            LOG.debug((Object)("Successfully fetched hive metastore delegation token. " + metastoreToken));
        }
        catch (Exception ex) {
            LOG.error((Object)"Couldn't fetch delegation token.", (Throwable)ex);
            throw new RuntimeException("Couldn't fetch delegation token.", ex);
        }
    }

    private static void addHiveConfigs(Configuration hiveConf, Configuration conf) {
        for (Map.Entry item : hiveConf) {
            conf.setIfUnset((String)item.getKey(), (String)item.getValue());
        }
    }

    static enum WriteMode {
        DEFAULT,
        APPEND,
        OVERWRITE;

    }
}

