/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.plain;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class BinaryPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BinaryPlainValuesReader.class);
    private ByteBuffer in;
    private int offset;

    @Override
    public Binary readBytes() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            int start = this.offset + 4;
            this.offset = start + length;
            return Binary.fromConstantByteBuffer(this.in, start, length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            this.offset += 4 + length;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.limit() - offset));
        }
        this.in = in;
        this.offset = offset;
    }
}

