/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprIntervalDayTimeScalarColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private HiveIntervalDayTime arg2Scalar;
    private final int arg3Column;
    private int outputColumnNum;

    public IfExprIntervalDayTimeScalarColumn(int arg1Column, HiveIntervalDayTime arg2Scalar, int arg3Column, int outputColumnNum) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Column = arg3Column;
        this.outputColumnNum = outputColumnNum;
    }

    public IfExprIntervalDayTimeScalarColumn() {
        this.arg1Column = -1;
        this.arg2Scalar = null;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        IntervalDayTimeColumnVector arg3ColVector = (IntervalDayTimeColumnVector)batch.cols[this.arg3Column];
        boolean[] arg3IsNull = arg3ColVector.isNull;
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, this.arg2Scalar);
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg3ColVector.asScratchIntervalDayTime(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, this.arg2Scalar);
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg3ColVector.asScratchIntervalDayTime(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg2Scalar);
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, arg3ColVector.asScratchIntervalDayTime(i));
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg2Scalar);
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, arg3ColVector.asScratchIntervalDayTime(i));
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumnNum;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", val " + this.arg2Scalar + ", " + this.getColumnParamString(2, this.arg3Column);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("int_family"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

