/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterCharColumnNotBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private byte[] left;
    private byte[] right;

    public FilterCharColumnNotBetween(int colNum, byte[] left, byte[] right) {
        this.colNum = colNum;
        this.left = left;
        this.right = right;
    }

    public FilterCharColumnNotBetween() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (StringExpr.compare(vector[0], start[0], length[0], this.left, 0, this.left.length) >= 0 && StringExpr.compare(this.right, 0, this.right.length, vector[0], start[0], length[0]) >= 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (StringExpr.compare(this.left, 0, this.left.length, vector[i], start[i], length[i]) <= 0 && StringExpr.compare(vector[i], start[i], length[i], this.right, 0, this.right.length) <= 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (StringExpr.compare(this.left, 0, this.left.length, vector[i], start[i], length[i]) <= 0 && StringExpr.compare(vector[i], start[i], length[i], this.right, 0, this.right.length) <= 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!inputIsNull[0]) {
                if (StringExpr.compare(vector[0], start[0], length[0], this.left, 0, this.left.length) >= 0 && StringExpr.compare(this.right, 0, this.right.length, vector[0], start[0], length[0]) >= 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputIsNull[i] || StringExpr.compare(this.left, 0, this.left.length, vector[i], start[i], length[i]) <= 0 && StringExpr.compare(vector[i], start[i], length[i], this.right, 0, this.right.length) <= 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i] || StringExpr.compare(this.left, 0, this.left.length, vector[i], start[i], length[i]) <= 0 && StringExpr.compare(vector[i], start[i], length[i], this.right, 0, this.right.length) <= 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getLeft() {
        return this.left;
    }

    public void setLeft(byte[] value) {
        this.left = value;
    }

    public byte[] getRight() {
        return this.right;
    }

    public void setRight(byte[] value) {
        this.right = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", left " + FilterCharColumnNotBetween.displayUtf8Bytes(this.left) + ", right " + FilterCharColumnNotBetween.displayUtf8Bytes(this.right);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("Char"), VectorExpressionDescriptor.ArgumentType.getType("Char"), VectorExpressionDescriptor.ArgumentType.getType("Char")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

