/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDFDirect;

public class StringLTrim
extends StringUnaryUDFDirect {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public StringLTrim(int inputColumn, int outputColumn) {
        super(inputColumn, outputColumn);
    }

    public StringLTrim() {
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int batchIndex) {
        int index;
        byte[] bytes = vector[batchIndex];
        int startIndex = start[batchIndex];
        int end = startIndex + length[batchIndex];
        for (index = startIndex; index < end && bytes[index] == 32; ++index) {
        }
        int resultLength = end - index;
        if (resultLength == 0) {
            outV.setVal(batchIndex, EMPTY_BYTES, 0, 0);
            return;
        }
        outV.setVal(batchIndex, bytes, index, resultLength);
    }
}

