/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HooksLoader;
import org.apache.hadoop.hive.ql.hooks.MetricsQueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContextImpl;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.session.SessionState;

class QueryLifeTimeHookRunner {
    private final HiveConf conf;
    private final List<QueryLifeTimeHook> queryHooks;

    QueryLifeTimeHookRunner(HiveConf conf, HooksLoader hooksLoader, SessionState.LogHelper console) {
        List propertyDefinedHoooks;
        this.conf = conf;
        this.queryHooks = new ArrayList<QueryLifeTimeHook>();
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
            this.queryHooks.add(new MetricsQueryLifeTimeHook());
        }
        try {
            propertyDefinedHoooks = hooksLoader.getHooks(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, console, QueryLifeTimeHook.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        if (propertyDefinedHoooks != null) {
            Iterables.addAll(this.queryHooks, propertyDefinedHoooks);
        }
    }

    void runBeforeParseHook(String command) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).beforeParse(qhc);
            }
        }
    }

    void runAfterParseHook(String command, boolean parseError) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).afterParse(qhc, parseError);
            }
        }
    }

    void runBeforeCompileHook(String command) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.beforeCompile(qhc);
            }
        }
    }

    void runAfterCompilationHook(String command, boolean compileError) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.afterCompile(qhc, compileError);
            }
        }
    }

    void runBeforeExecutionHook(String command, HookContext hookContext) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.beforeExecution(qhc);
            }
        }
    }

    void runAfterExecutionHook(String command, HookContext hookContext, boolean executionError) {
        if (this.containsHooks()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.afterExecution(qhc, executionError);
            }
        }
    }

    private boolean containsHooks() {
        return this.queryHooks != null && !this.queryHooks.isEmpty();
    }
}

