/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.CorruptedWALProcedureStoreException;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureMap;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureTree;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProcedureWALFormatReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureWALFormatReader.class);
    private final WALProcedureMap localProcedureMap = new WALProcedureMap();
    private final WALProcedureMap procedureMap = new WALProcedureMap();
    private final ProcedureWALFormat.Loader loader;
    private final ProcedureStoreTracker tracker;
    private ProcedureStoreTracker localTracker;
    private long maxProcId = 0L;

    public ProcedureWALFormatReader(ProcedureStoreTracker tracker, ProcedureWALFormat.Loader loader) {
        this.tracker = tracker;
        this.loader = loader;
    }

    public void read(ProcedureWALFile log) throws IOException {
        this.localTracker = log.getTracker();
        if (this.localTracker.isPartial()) {
            LOG.info("Rebuilding tracker for {}", (Object)log);
        }
        long count = 0L;
        FSDataInputStream stream = log.getStream();
        try {
            boolean hasMore = true;
            block9: while (hasMore) {
                ProcedureProtos.ProcedureWALEntry entry = ProcedureWALFormat.readEntry((InputStream)stream);
                if (entry == null) {
                    LOG.warn("Nothing left to decode. Exiting with missing EOF, log={}", (Object)log);
                    break;
                }
                ++count;
                switch (entry.getType()) {
                    case PROCEDURE_WAL_INIT: {
                        this.readInitEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_INSERT: {
                        this.readInsertEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_UPDATE: 
                    case PROCEDURE_WAL_COMPACT: {
                        this.readUpdateEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_DELETE: {
                        this.readDeleteEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_EOF: {
                        hasMore = false;
                        continue block9;
                    }
                }
                throw new CorruptedWALProcedureStoreException("Invalid entry: " + entry);
            }
            LOG.info("Read {} entries in {}", (Object)count, (Object)log);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("While reading entry #{} in {}", new Object[]{count, log, e});
            this.loader.markCorruptedWAL(log, (IOException)((Object)e));
        }
        if (!this.localProcedureMap.isEmpty()) {
            log.setProcIds(this.localProcedureMap.getMinModifiedProcId(), this.localProcedureMap.getMaxModifiedProcId());
            if (this.localTracker.isPartial()) {
                this.localTracker.setMinMaxModifiedProcIds(this.localProcedureMap.getMinModifiedProcId(), this.localProcedureMap.getMaxModifiedProcId());
            }
            this.procedureMap.merge(this.localProcedureMap);
        }
    }

    public void finish() throws IOException {
        this.loader.setMaxProcId(this.maxProcId);
        WALProcedureTree tree = WALProcedureTree.build(this.procedureMap.getProcedures());
        this.loader.load(tree.getValidProcs());
        this.loader.handleCorrupted(tree.getCorruptedProcs());
    }

    private void setDeletedIfPartial(ProcedureStoreTracker tracker, long procId) {
        if (tracker.isPartial()) {
            tracker.setDeleted(procId, true);
        }
    }

    private void insertIfPartial(ProcedureStoreTracker tracker, ProcedureProtos.Procedure proc) {
        if (tracker.isPartial()) {
            tracker.insert(proc.getProcId());
        }
    }

    private void loadProcedure(ProcedureProtos.ProcedureWALEntry entry, ProcedureProtos.Procedure proc) {
        this.maxProcId = Math.max(this.maxProcId, proc.getProcId());
        if (this.isRequired(proc.getProcId())) {
            LOG.trace("Read {} entry {}", (Object)entry.getType(), (Object)proc.getProcId());
            this.localProcedureMap.add(proc);
            this.insertIfPartial(this.tracker, proc);
        }
        this.insertIfPartial(this.localTracker, proc);
    }

    private void readInitEntry(ProcedureProtos.ProcedureWALEntry entry) {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadProcedure(entry, entry.getProcedure(0));
    }

    private void readInsertEntry(ProcedureProtos.ProcedureWALEntry entry) {
        assert (entry.getProcedureCount() >= 1) : "Expected one or more procedures";
        this.loadProcedure(entry, entry.getProcedure(0));
        for (int i = 1; i < entry.getProcedureCount(); ++i) {
            this.loadProcedure(entry, entry.getProcedure(i));
        }
    }

    private void readUpdateEntry(ProcedureProtos.ProcedureWALEntry entry) {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadProcedure(entry, entry.getProcedure(0));
    }

    private void readDeleteEntry(ProcedureProtos.ProcedureWALEntry entry) {
        assert (entry.hasProcId()) : "expected ProcID";
        if (entry.getChildIdCount() > 0) {
            assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
            this.loadProcedure(entry, entry.getProcedure(0));
            int count = entry.getChildIdCount();
            for (int i = 0; i < count; ++i) {
                this.deleteEntry(entry.getChildId(i));
            }
        } else {
            assert (entry.getProcedureCount() == 0) : "Expected no procedures";
            this.deleteEntry(entry.getProcId());
        }
    }

    private void deleteEntry(long procId) {
        LOG.trace("delete entry {}", (Object)procId);
        this.maxProcId = Math.max(this.maxProcId, procId);
        this.localProcedureMap.remove(procId);
        assert (!this.procedureMap.contains(procId));
        this.setDeletedIfPartial(this.tracker, procId);
        this.setDeletedIfPartial(this.localTracker, procId);
    }

    private boolean isDeleted(long procId) {
        return this.tracker.isDeleted(procId) == ProcedureStoreTracker.DeleteState.YES;
    }

    private boolean isRequired(long procId) {
        return !this.isDeleted(procId) && !this.procedureMap.contains(procId);
    }
}

