/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.input;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.format.IAvroLookupField;

public class AvroLookupField
implements IAvroLookupField {
    @Injection(name="LOOKUP_FIELD_NAME", group="LOOKUP_FIELDS")
    public String fieldName = "";
    @Injection(name="LOOKUP_VARIABLE_NAME", group="LOOKUP_FIELDS")
    public String variableName = "";
    @Injection(name="LOOKUP_DEFAULT_VALUE", group="LOOKUP_FIELDS")
    public String defaultValue = "";
    protected String cleansedVariableName;
    protected String resolvedFieldName;
    protected String resolvedDefaultvalue;
    protected boolean isValid = true;
    protected int inputIndex = -1;
    protected ValueMetaInterface fieldVM;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean init(RowMetaInterface inRowMeta, VariableSpace space) {
        if (inRowMeta == null) {
            this.isValid = false;
            return false;
        }
        this.resolvedFieldName = space != null ? space.environmentSubstitute(this.fieldName) : this.fieldName;
        this.inputIndex = inRowMeta.indexOfValue(this.resolvedFieldName);
        if (this.inputIndex < 0) {
            this.isValid = false;
            return this.isValid;
        }
        this.fieldVM = inRowMeta.getValueMeta(this.inputIndex);
        if (Const.isEmpty((String)this.variableName)) {
            this.isValid = false;
            return this.isValid;
        }
        this.cleansedVariableName = this.variableName.replaceAll("\\.", "_");
        this.resolvedDefaultvalue = space.environmentSubstitute(this.defaultValue);
        return this.isValid;
    }

    public void setVariable(VariableSpace space, Object[] inRow) {
        if (!this.isValid) {
            return;
        }
        String valueToSet = "";
        try {
            valueToSet = this.fieldVM.isNull(inRow[this.inputIndex]) ? (!Const.isEmpty((String)this.resolvedDefaultvalue) ? this.resolvedDefaultvalue : "null") : this.fieldVM.getString(inRow[this.inputIndex]);
        }
        catch (KettleValueException e) {
            valueToSet = "null";
        }
        space.setVariable(this.cleansedVariableName, valueToSet);
    }
}

