/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.SqlManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.cli.RelatedOptions;

public class GenericJdbcManager
extends SqlManager {
    public static final Log LOG = LogFactory.getLog((String)GenericJdbcManager.class.getName());
    private String jdbcDriverClass;
    private Connection connection;
    private static final String SCHEMA = "schema";

    public GenericJdbcManager(String driverClass, SqoopOptions opts) {
        super(opts);
        this.jdbcDriverClass = driverClass;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (null == this.connection) {
            this.connection = this.makeConnection();
        }
        return this.connection;
    }

    protected boolean hasOpenConnection() {
        return this.connection != null;
    }

    @Override
    public void discardConnection(boolean doClose) {
        if (doClose && this.hasOpenConnection()) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.discardConnection(true);
    }

    @Override
    public String getDriverClass() {
        return this.jdbcDriverClass;
    }

    public String parseExtraScheArgs(String[] args, RelatedOptions opts) throws ParseException {
        if (args == null || args.length == 0) {
            return null;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = parser.parse((Options)opts, args, true);
        return this.applyExtraScheArguments(cmdLine);
    }

    public String applyExtraScheArguments(CommandLine cmdLine) {
        if (cmdLine.hasOption(SCHEMA)) {
            String schemaName = cmdLine.getOptionValue(SCHEMA);
            LOG.info((Object)("We will use schema " + schemaName));
            return schemaName;
        }
        return null;
    }
}

