/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.xml.sax.SAXException;

public class SchemaService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.SchemaService.";
    public static final String WF_CONF_SCHEMAS = "oozie.service.SchemaService.wf.schemas";
    public static final String WF_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.wf.ext.schemas";
    public static final String COORD_CONF_SCHEMAS = "oozie.service.SchemaService.coord.schemas";
    public static final String COORD_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.coord.ext.schemas";
    public static final String BUNDLE_CONF_SCHEMAS = "oozie.service.SchemaService.bundle.schemas";
    public static final String BUNDLE_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.bundle.ext.schemas";
    public static final String SLA_CONF_SCHEMAS = "oozie.service.SchemaService.sla.schemas";
    public static final String SLA_CONF_EXT_SCHEMAS = "oozie.service.SchemaService.sla.ext.schemas";
    @Deprecated
    public static final String SLA_NAME_SPACE_URI = "uri:oozie:sla:0.1";
    public static final String SLA_NAMESPACE_URI_2 = "uri:oozie:sla:0.2";
    public static final String COORDINATOR_NAMESPACE_URI_1 = "uri:oozie:coordinator:0.1";
    private Schema wfSchema;
    private Schema coordSchema;
    private Schema bundleSchema;
    private Schema slaSchema;

    private Schema loadSchema(String baseSchemas, String extSchema) throws SAXException, IOException {
        HashSet<String> schemaNames = new HashSet<String>();
        String[] schemas = ConfigurationService.getStrings(baseSchemas);
        if (schemas != null) {
            for (String schema : schemas) {
                if ((schema = schema.trim()).isEmpty()) continue;
                schemaNames.add(schema);
            }
        }
        if ((schemas = ConfigurationService.getStrings(extSchema)) != null) {
            for (String schema : schemas) {
                if ((schema = schema.trim()).isEmpty()) continue;
                schemaNames.add(schema);
            }
        }
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (String schemaName : schemaNames) {
            sources.add(new StreamSource(IOUtils.getResourceAsStream(schemaName, -1)));
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(sources.toArray(new StreamSource[sources.size()]));
    }

    @Override
    public void init(Services services) throws ServiceException {
        try {
            this.wfSchema = this.loadSchema(WF_CONF_SCHEMAS, WF_CONF_EXT_SCHEMAS);
            this.coordSchema = this.loadSchema(COORD_CONF_SCHEMAS, COORD_CONF_EXT_SCHEMAS);
            this.bundleSchema = this.loadSchema(BUNDLE_CONF_SCHEMAS, BUNDLE_CONF_EXT_SCHEMAS);
            this.slaSchema = this.loadSchema(SLA_CONF_SCHEMAS, SLA_CONF_EXT_SCHEMAS);
        }
        catch (SAXException ex) {
            throw new ServiceException(ErrorCode.E0130, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0131, ex.getMessage(), ex);
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SchemaService.class;
    }

    @Override
    public void destroy() {
        this.wfSchema = null;
        this.bundleSchema = null;
        this.slaSchema = null;
        this.coordSchema = null;
    }

    public Schema getSchema(SchemaName schemaName) {
        Schema returnSchema = null;
        if (schemaName == SchemaName.WORKFLOW) {
            returnSchema = this.wfSchema;
        } else if (schemaName == SchemaName.COORDINATOR) {
            returnSchema = this.coordSchema;
        } else if (schemaName == SchemaName.BUNDLE) {
            returnSchema = this.bundleSchema;
        } else if (schemaName == SchemaName.SLA_ORIGINAL) {
            returnSchema = this.slaSchema;
        } else {
            throw new RuntimeException("No schema found with name " + (Object)((Object)schemaName));
        }
        return returnSchema;
    }

    public static enum SchemaName {
        WORKFLOW(1),
        COORDINATOR(2),
        SLA_ORIGINAL(3),
        BUNDLE(4);

        private final int id;

        private SchemaName(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

