/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

public class INodeMap {
    private final GSet<INode, INodeWithAdditionalFields> map;

    static INodeMap newInstance(INodeDirectory rootDir) {
        int capacity = LightWeightGSet.computeCapacity((double)1.0, (String)"INodeMap");
        LightWeightGSet map = new LightWeightGSet(capacity);
        map.put((Object)rootDir);
        return new INodeMap((GSet<INode, INodeWithAdditionalFields>)map);
    }

    public Iterator<INodeWithAdditionalFields> getMapIterator() {
        return this.map.iterator();
    }

    private INodeMap(GSet<INode, INodeWithAdditionalFields> map) {
        Preconditions.checkArgument((map != null ? 1 : 0) != 0);
        this.map = map;
    }

    public final void put(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.map.put((Object)((INodeWithAdditionalFields)inode));
        }
    }

    public final void remove(INode inode) {
        this.map.remove((Object)inode);
    }

    public int size() {
        return this.map.size();
    }

    public INode get(long id) {
        INodeWithAdditionalFields inode = new INodeWithAdditionalFields(id, null, new PermissionStatus("", "", new FsPermission(0)), 0L, 0L){

            @Override
            void recordModification(int latestSnapshotId) {
            }

            @Override
            public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
            }

            @Override
            public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
                return null;
            }

            @Override
            public ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
                return null;
            }

            @Override
            public Quota.Counts cleanSubtree(int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
                return null;
            }

            @Override
            public byte getStoragePolicyID() {
                return 0;
            }

            @Override
            public byte getLocalStoragePolicyID() {
                return 0;
            }
        };
        return (INode)this.map.get((Object)inode);
    }

    public void clear() {
        this.map.clear();
    }
}

