/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.io.api.Binary;

public class LeafFilterFactory {
    private static final Log LOG = LogFactory.getLog(LeafFilterFactory.class);

    public FilterPredicateLeafBuilder getLeafFilterBuilderByType(PredicateLeaf.Type type) {
        switch (type) {
            case INTEGER: {
                return new IntFilterPredicateLeafBuilder();
            }
            case LONG: {
                return new LongFilterPredicateLeafBuilder();
            }
            case FLOAT: {
                return new DoubleFilterPredicateLeafBuilder();
            }
            case STRING: {
                return new BinaryFilterPredicateLeafBuilder();
            }
            case BOOLEAN: {
                return new BooleanFilterPredicateLeafBuilder();
            }
        }
        LOG.debug((Object)("Conversion to Parquet FilterPredicate not supported for " + (Object)((Object)type)));
        return null;
    }

    class BinaryFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BinaryFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.binaryColumn(columnName), Binary.fromString((String)constant));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.binaryColumn(columnName), constant == null ? null : Binary.fromString((String)constant));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.binaryColumn(columnName), Binary.fromString((String)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class BooleanFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BooleanFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.booleanColumn(columnName), constant == null ? null : Boolean.valueOf((Boolean)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class DoubleFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        DoubleFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.doubleColumn(columnName), ((Number)constant).doubleValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.doubleColumn(columnName), constant == null ? null : Double.valueOf(((Number)constant).doubleValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.doubleColumn(columnName), ((Number)constant).doubleValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class LongFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        LongFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.longColumn(columnName), ((Number)constant).longValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.longColumn(columnName), constant == null ? null : Long.valueOf(((Number)constant).longValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.longColumn(columnName), ((Number)constant).longValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class IntFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        IntFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object literal, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt(FilterApi.intColumn(columnName), ((Number)literal).intValue());
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq(FilterApi.intColumn(columnName), literal == null ? null : Integer.valueOf(((Number)literal).intValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq(FilterApi.intColumn(columnName), ((Number)literal).intValue());
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }
}

