/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinInnerLongOperator
extends VectorMapJoinInnerGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerLongOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerLongOperator.class.getName();
    private transient VectorMapJoinLongHashMap hashMap;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    public VectorMapJoinInnerLongOperator() {
    }

    public VectorMapJoinInnerLongOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinLongHashMap)this.vectorMapJoinHashTable;
                this.useMinMax = this.hashMap.useMinMax();
                if (this.useMinMax) {
                    this.min = this.hashMap.min();
                    this.max = this.hashMap.max();
                }
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.innerPerBatchSetup(batch);
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    long key = vector[0];
                    joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(key, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                this.finishInnerRepeated(batch, joinResult, this.hashMapResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    boolean isNull;
                    long currentKey;
                    int batchIndex;
                    int n = batchIndex = selectedInUse ? selected[logical] : logical;
                    if (!joinColVector.noNulls && joinColVector.isNull[batchIndex]) {
                        currentKey = 0L;
                        isNull = true;
                    } else {
                        currentKey = vector[batchIndex];
                        isNull = false;
                    }
                    if (isNull || !haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        if (isNull) {
                            saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            saveKey = currentKey;
                            saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMap.lookup(currentKey, this.hashMapResults[hashMapResultCount]);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n2 = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n2] = this.equalKeySeriesDuplicateCounts[n2] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " allMatchs " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " spills " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount))));
                }
                this.finishInner(batch, allMatchCount, equalKeySeriesCount, spillCount, hashMapResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

