/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.utils;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;

public class EscapeUtils {
    public static String escapeJson(String text) throws IOException {
        return EscapeUtils.escapeJson(text, null);
    }

    public static String escapeJson(String text, DefaultPrettyPrinter prettyPrinter) throws IOException {
        if (text == null) {
            return null;
        }
        JsonNode parsedJson = new ObjectMapper().readTree(text);
        return EscapeUtils.getObjectWriter(prettyPrinter).writeValueAsString((Object)parsedJson);
    }

    public static String escapeRaw(String text) {
        return EscapeUtils.escapeRaw(text, null);
    }

    public static String escapeRaw(String text, DefaultPrettyPrinter prettyPrinter) {
        if (text == null) {
            return null;
        }
        String result = null;
        try {
            String escapedValue = EscapeUtils.getObjectWriter(prettyPrinter).writeValueAsString((Object)text);
            result = escapedValue.substring(1, escapedValue.length() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String escapeJsonOrRaw(String text) {
        return EscapeUtils.escapeJsonOrRaw(text, null);
    }

    public static String escapeJsonOrRaw(String text, DefaultPrettyPrinter prettyPrinter) {
        if (text == null) {
            return null;
        }
        try {
            return EscapeUtils.escapeJson(text, prettyPrinter);
        }
        catch (Exception e) {
            return EscapeUtils.escapeRaw(text, prettyPrinter);
        }
    }

    private static ObjectWriter getObjectWriter(DefaultPrettyPrinter prettyPrinter) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getFactory().setCharacterEscapes((CharacterEscapes)new HTMLCharacterEscapes());
        return mapper.writer((PrettyPrinter)prettyPrinter);
    }

    static class HTMLCharacterEscapes
    extends CharacterEscapes {
        private final int[] asciiEscapes;

        public HTMLCharacterEscapes() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            esc[34] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

