/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.sqlserver;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.UpdateOutputFormat;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.UpdateOutputFormat;

public class SqlServerUpsertOutputFormat<K extends SqoopRecord, V>
extends UpdateOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(SqlServerUpsertOutputFormat.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new SqlServerUpsertRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class SqlServerUpsertRecordWriter
    extends UpdateOutputFormat.UpdateRecordWriter {
        public SqlServerUpsertRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
        }

        @Override
        protected String getUpdateStatement() {
            List<String> updateKeyLookup = Arrays.asList(this.updateCols);
            StringBuilder sb = new StringBuilder();
            if (this.getConf().getBoolean("org.apache.sqoop.manager.sqlserver.table.identity", false)) {
                LOG.info((Object)"Enabling identity inserts");
                sb.append("SET IDENTITY_INSERT ").append(this.tableName).append(" ON ");
            }
            sb.append("MERGE INTO ").append(this.tableName).append(" AS _target");
            sb.append(" USING ( VALUES ( ");
            boolean first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(" ) )").append(" AS _source ( ");
            first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(col);
            }
            sb.append(" )");
            sb.append(" ON ");
            first = true;
            for (String updateCol : this.updateCols) {
                if (!updateKeyLookup.contains(updateCol)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append("_source.").append(updateCol).append(" = _target.").append(updateCol);
            }
            sb.append("  WHEN MATCHED THEN UPDATE SET ");
            first = true;
            for (String col : this.columnNames) {
                if (updateKeyLookup.contains(col)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("_target.").append(col).append(" = _source.").append(col);
            }
            sb.append("  WHEN NOT MATCHED THEN ").append("INSERT ( ");
            first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(col);
            }
            sb.append(" ) VALUES ( ");
            first = true;
            for (String col : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("_source.").append(col);
            }
            sb.append(" )");
            sb.append(";");
            return sb.toString();
        }
    }
}

