/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;

public class SqoopHCatExportHelper {
    private InputJobInfo jobInfo;
    private HCatSchema hCatFullTableSchema;
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatExportHelper.class.getName());
    private SqoopRecord sqoopRecord;
    private boolean bigDecimalFormatString;
    private static final String TIMESTAMP_TYPE = "java.sql.Timestamp";
    private static final String TIME_TYPE = "java.sql.Time";
    private static final String DATE_TYPE = "java.sql.Date";
    private static final String MAP_TYPE = "java.util.Map";
    private static final String LIST_TYPE = "java.util.List";
    private static final String BIG_DECIMAL_TYPE = "java.math.BigDecimal";
    private static final String FLOAT_TYPE = "Float";
    private static final String DOUBLE_TYPE = "Double";
    private static final String BYTE_TYPE = "Byte";
    private static final String SHORT_TYPE = "Short";
    private static final String INTEGER_TYPE = "Integer";
    private static final String LONG_TYPE = "Long";
    private static final String BOOLEAN_TYPE = "Boolean";
    private static final String STRING_TYPE = "String";
    private static final String BYTESWRITABLE = "org.apache.hadoop.io.BytesWritable";
    private static boolean debugHCatExportMapper = false;
    private MapWritable colTypesJava;
    private MapWritable colTypesSql;
    private ObjectMapper mapper;
    public static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> timestampFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public SqoopHCatExportHelper(Configuration conf) throws IOException, InterruptedException {
        this.colTypesJava = (MapWritable)DefaultStringifier.load((Configuration)conf, (String)"sqoop.hcat.db.output.coltypes.java", MapWritable.class);
        this.colTypesSql = (MapWritable)DefaultStringifier.load((Configuration)conf, (String)"sqoop.hcat.db.output.coltypes.sql", MapWritable.class);
        String recordClassName = conf.get("sqoop.mapreduce.export.table.class");
        if (null == recordClassName) {
            throw new IOException("Export table class name (sqoop.mapreduce.export.table.class) is not set!");
        }
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        debugHCatExportMapper = conf.getBoolean("sqoop.hcat.debug.export.mapper", false);
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.sqoopRecord = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.sqoopRecord) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
        String inputJobInfoStr = conf.get("mapreduce.lib.hcat.job.info");
        this.jobInfo = (InputJobInfo)HCatUtil.deserialize((String)inputJobInfoStr);
        HCatSchema tableSchema = this.jobInfo.getTableInfo().getDataColumns();
        HCatSchema partitionSchema = this.jobInfo.getTableInfo().getPartitionColumns();
        this.hCatFullTableSchema = new HCatSchema(tableSchema.getFields());
        for (HCatFieldSchema hfs : partitionSchema.getFields()) {
            this.hCatFullTableSchema.append(hfs);
        }
        this.mapper = new ObjectMapper();
        SimpleModule hiveTypesModule = new SimpleModule("HiveTypesModule", Version.unknownVersion());
        hiveTypesModule.addSerializer(HiveVarchar.class, (JsonSerializer)new HiveVarcharSerializer());
        hiveTypesModule.addSerializer(HiveChar.class, (JsonSerializer)new HiveCharSerializer());
        hiveTypesModule.addSerializer(HiveDecimal.class, (JsonSerializer)new HiveDecimalSerializer());
        hiveTypesModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        hiveTypesModule.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
        this.mapper.registerModule((Module)hiveTypesModule);
    }

    public SqoopRecord convertToSqoopRecord(HCatRecord hcr) throws IOException {
        Text key = new Text();
        for (Map.Entry<String, Object> e : this.sqoopRecord.getFieldMap().entrySet()) {
            String colName = e.getKey();
            String hfn = colName.toLowerCase();
            key.set(hfn);
            String javaColType = this.colTypesJava.get((Object)key).toString();
            int sqlType = ((IntWritable)this.colTypesSql.get((Object)key)).get();
            HCatFieldSchema field = this.hCatFullTableSchema.get(hfn);
            HCatFieldSchema.Type fieldType = field.getType();
            Object hCatVal = hcr.get(hfn, this.hCatFullTableSchema);
            String hCatTypeString = field.getTypeString();
            Object sqlVal = this.convertToSqoop(hCatVal, fieldType, javaColType, hCatTypeString);
            if (debugHCatExportMapper) {
                LOG.debug((Object)("hCatVal " + hCatVal + " of type " + (hCatVal == null ? null : hCatVal.getClass().getName()) + ",sqlVal " + sqlVal + " of type " + (sqlVal == null ? null : sqlVal.getClass().getName()) + ",java type " + javaColType + ", sql type = " + SqoopHCatUtilities.sqlTypeString(sqlType)));
            }
            this.sqoopRecord.setField(colName, sqlVal);
        }
        return this.sqoopRecord;
    }

    private Object convertToSqoop(Object val, HCatFieldSchema.Type fieldType, String javaColType, String hCatTypeString) throws IOException {
        if (val == null) {
            return null;
        }
        switch (fieldType) {
            case INT: 
            case TINYINT: 
            case SMALLINT: 
            case FLOAT: 
            case DOUBLE: {
                val = this.convertNumberTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            case BOOLEAN: {
                val = this.convertBooleanTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            case BIGINT: {
                if (javaColType.equals(DATE_TYPE)) {
                    return new Date((Long)val);
                }
                if (javaColType.equals(TIME_TYPE)) {
                    return new Time((Long)val);
                }
                if (javaColType.equals(TIMESTAMP_TYPE)) {
                    return new Timestamp((Long)val);
                }
                if ((val = this.convertNumberTypes(val, javaColType)) == null) break;
                return val;
            }
            case DATE: {
                Date date = (Date)val;
                if (javaColType.equals(DATE_TYPE)) {
                    return date;
                }
                if (javaColType.equals(TIME_TYPE)) {
                    return new Time(date.getTime());
                }
                if (!javaColType.equals(TIMESTAMP_TYPE)) break;
                return new Timestamp(date.getTime());
            }
            case TIMESTAMP: {
                Timestamp ts = (Timestamp)val;
                if (javaColType.equals(DATE_TYPE)) {
                    return new Date(ts.getTime());
                }
                if (javaColType.equals(TIME_TYPE)) {
                    return new Time(ts.getTime());
                }
                if (!javaColType.equals(TIMESTAMP_TYPE)) break;
                return ts;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                val = this.convertStringTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            case BINARY: {
                val = this.convertBinaryTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            case DECIMAL: {
                val = this.convertDecimalTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                val = this.convertComplexTypes(val, javaColType);
                if (val == null) break;
                return val;
            }
            default: {
                throw new IOException("Cannot convert HCatalog type " + fieldType);
            }
        }
        LOG.error((Object)("Cannot convert HCatalog object of  type " + hCatTypeString + " to java object type " + javaColType));
        return null;
    }

    private Object convertDecimalTypes(Object val, String javaColType) {
        HiveDecimal hd = (HiveDecimal)val;
        BigDecimal bd = hd.bigDecimalValue();
        if (javaColType.equals(BIG_DECIMAL_TYPE)) {
            return bd;
        }
        if (javaColType.equals(STRING_TYPE)) {
            String bdStr = null;
            bdStr = this.bigDecimalFormatString ? bd.toPlainString() : bd.toString();
            return bdStr;
        }
        return null;
    }

    private Object convertBinaryTypes(Object val, String javaColType) {
        byte[] bb = (byte[])val;
        if (javaColType.equals(BYTESWRITABLE)) {
            BytesWritable bw = new BytesWritable();
            bw.set(bb, 0, bb.length);
            return bw;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object convertStringTypes(Object val, String javaColType) {
        String valStr = val.toString();
        if (javaColType.equals(BIG_DECIMAL_TYPE)) {
            return new BigDecimal(valStr);
        }
        if (javaColType.equals(DATE_TYPE) || javaColType.equals(TIME_TYPE) || javaColType.equals(TIMESTAMP_TYPE)) {
            if (valStr.length() == 10 && valStr.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
                Date d = Date.valueOf(valStr);
                if (javaColType.equals(DATE_TYPE)) {
                    return d;
                }
                if (javaColType.equals(TIME_TYPE)) {
                    return new Time(d.getTime());
                }
                if (!javaColType.equals(TIMESTAMP_TYPE)) return null;
                return new Timestamp(d.getTime());
            }
            if (valStr.length() == 8 && valStr.matches("^\\d{2}:\\d{2}:\\d{2}$")) {
                Time t = Time.valueOf(valStr);
                if (javaColType.equals(DATE_TYPE)) {
                    return new Date(t.getTime());
                }
                if (javaColType.equals(TIME_TYPE)) {
                    return t;
                }
                if (!javaColType.equals(TIMESTAMP_TYPE)) return null;
                return new Timestamp(t.getTime());
            }
            if (valStr.length() < 19 || valStr.length() > 26 || !valStr.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(.\\d+)?$")) return null;
            Timestamp ts = Timestamp.valueOf(valStr);
            if (javaColType.equals(DATE_TYPE)) {
                return new Date(ts.getTime());
            }
            if (javaColType.equals(TIME_TYPE)) {
                return new Time(ts.getTime());
            }
            if (!javaColType.equals(TIMESTAMP_TYPE)) return null;
            return ts;
        }
        if (javaColType.equals(STRING_TYPE)) {
            return valStr;
        }
        if (javaColType.equals(BOOLEAN_TYPE)) {
            return Boolean.valueOf(valStr);
        }
        if (javaColType.equals(BYTE_TYPE)) {
            return Byte.parseByte(valStr);
        }
        if (javaColType.equals(SHORT_TYPE)) {
            return Short.parseShort(valStr);
        }
        if (javaColType.equals(INTEGER_TYPE)) {
            return Integer.parseInt(valStr);
        }
        if (javaColType.equals(LONG_TYPE)) {
            return Long.parseLong(valStr);
        }
        if (javaColType.equals(FLOAT_TYPE)) {
            return Float.valueOf(Float.parseFloat(valStr));
        }
        if (!javaColType.equals(DOUBLE_TYPE)) return null;
        return Double.parseDouble(valStr);
    }

    private Object convertBooleanTypes(Object val, String javaColType) {
        Boolean b = (Boolean)val;
        if (javaColType.equals(BOOLEAN_TYPE)) {
            return b;
        }
        if (javaColType.equals(BYTE_TYPE)) {
            return (byte)(b != false ? 1 : 0);
        }
        if (javaColType.equals(SHORT_TYPE)) {
            return (short)(b != false ? 1 : 0);
        }
        if (javaColType.equals(INTEGER_TYPE)) {
            return b != false ? 1 : 0;
        }
        if (javaColType.equals(LONG_TYPE)) {
            return (long)(b != false ? 1 : 0);
        }
        if (javaColType.equals(FLOAT_TYPE)) {
            return Float.valueOf(b != false ? 1 : 0);
        }
        if (javaColType.equals(DOUBLE_TYPE)) {
            return (double)(b != false ? 1 : 0);
        }
        if (javaColType.equals(BIG_DECIMAL_TYPE)) {
            return new BigDecimal(b != false ? 1 : 0);
        }
        if (javaColType.equals(STRING_TYPE)) {
            return val.toString();
        }
        return null;
    }

    private Object convertNumberTypes(Object val, String javaColType) {
        Number n = (Number)val;
        if (javaColType.equals(BYTE_TYPE)) {
            return n.byteValue();
        }
        if (javaColType.equals(SHORT_TYPE)) {
            return n.shortValue();
        }
        if (javaColType.equals(INTEGER_TYPE)) {
            return n.intValue();
        }
        if (javaColType.equals(LONG_TYPE)) {
            return n.longValue();
        }
        if (javaColType.equals(FLOAT_TYPE)) {
            return Float.valueOf(n.floatValue());
        }
        if (javaColType.equals(DOUBLE_TYPE)) {
            return n.doubleValue();
        }
        if (javaColType.equals(BIG_DECIMAL_TYPE)) {
            return new BigDecimal(n.doubleValue());
        }
        if (javaColType.equals(BOOLEAN_TYPE)) {
            return n.byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (javaColType.equals(STRING_TYPE)) {
            return n.toString();
        }
        return null;
    }

    private Object convertComplexTypes(Object val, String javaColType) throws IOException {
        if (javaColType.equals(STRING_TYPE)) {
            return this.mapper.writeValueAsString(val);
        }
        if (val instanceof List && javaColType.equals(LIST_TYPE)) {
            return val;
        }
        if (val instanceof Map && javaColType.equals(MAP_TYPE)) {
            return val;
        }
        return null;
    }

    public static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(timestampFormat.get().format(value));
        }
    }

    public static class DateSerializer
    extends JsonSerializer<Date> {
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(dateFormat.get().format(value));
        }
    }

    public static class HiveDecimalSerializer
    extends JsonSerializer<HiveDecimal> {
        public void serialize(HiveDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class HiveCharSerializer
    extends JsonSerializer<HiveChar> {
        public void serialize(HiveChar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class HiveVarcharSerializer
    extends JsonSerializer<HiveVarchar> {
        public void serialize(HiveVarchar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

