/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StringSerializationUtil;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.NodeHandler;

public class NodeDef
implements Writable {
    private String nodeDefVersion = null;
    private String name = null;
    private Class<? extends NodeHandler> handlerClass;
    private String conf = null;
    private List<String> transitions = new ArrayList<String>();
    private String cred = null;
    private String userRetryMax = "null";
    private String userRetryInterval = "null";

    NodeDef() {
    }

    NodeDef(String name, String conf, Class<? extends NodeHandler> handlerClass, List<String> transitions) {
        this.name = ParamChecker.notEmpty(name, "name");
        this.conf = conf;
        this.handlerClass = ParamChecker.notNull(handlerClass, "handlerClass");
        this.transitions = Collections.unmodifiableList(ParamChecker.notEmptyElements(transitions, "transitions"));
    }

    NodeDef(String name, String conf, Class<? extends NodeHandler> handlerClass, List<String> transitions, String cred) {
        this(name, conf, handlerClass, transitions);
        if (cred != null) {
            this.cred = cred;
        }
    }

    NodeDef(String name, String conf, Class<? extends NodeHandler> handlerClass, List<String> transitions, String cred, String userRetryMax, String userRetryInterval) {
        this(name, conf, handlerClass, transitions, cred);
        if (userRetryMax != null) {
            this.userRetryMax = userRetryMax;
        }
        if (userRetryInterval != null) {
            this.userRetryInterval = userRetryInterval;
        }
    }

    public boolean equals(NodeDef other) {
        return other != null && this.getClass() == other.getClass() && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getCred() {
        return this.cred;
    }

    public Class<? extends NodeHandler> getHandlerClass() {
        return this.handlerClass;
    }

    public List<String> getTransitions() {
        return this.transitions;
    }

    public String getConf() {
        return this.conf;
    }

    public String getUserRetryMax() {
        return this.userRetryMax;
    }

    public String getUserRetryInterval() {
        return this.userRetryInterval;
    }

    public String getNodeDefVersion() {
        if (this.nodeDefVersion == null) {
            try {
                this.nodeDefVersion = LiteWorkflowStoreService.getNodeDefDefaultVersion();
            }
            catch (WorkflowException e) {
                this.nodeDefVersion = "_oozie_inst_v_1";
            }
        }
        return this.nodeDefVersion;
    }

    private void readVersionZero(DataInput dataInput, String firstField) throws IOException {
        this.name = firstField.equals("_oozie_inst_v_0") ? dataInput.readUTF() : firstField;
        this.nodeDefVersion = "_oozie_inst_v_0";
        this.cred = dataInput.readUTF();
        String handlerClassName = dataInput.readUTF();
        if (handlerClassName != null && handlerClassName.length() > 0) {
            try {
                this.handlerClass = Class.forName(handlerClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        }
        this.conf = this.readString(dataInput);
        if (this.conf.equals("null")) {
            this.conf = null;
        }
        int numTrans = dataInput.readInt();
        this.transitions = new ArrayList<String>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            this.transitions.add(dataInput.readUTF());
        }
    }

    private void readVersionOne(DataInput dataInput, String firstField) throws IOException {
        String handlerClassName;
        this.nodeDefVersion = "_oozie_inst_v_1";
        this.name = dataInput.readUTF();
        this.cred = dataInput.readUTF();
        if (this.cred.equals("null")) {
            this.cred = null;
        }
        if ((handlerClassName = dataInput.readUTF()) != null && handlerClassName.length() > 0) {
            try {
                this.handlerClass = Class.forName(handlerClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        }
        this.conf = this.readString(dataInput);
        if (this.conf.equals("null")) {
            this.conf = null;
        }
        int numTrans = dataInput.readInt();
        this.transitions = new ArrayList<String>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            this.transitions.add(dataInput.readUTF());
        }
        this.userRetryMax = dataInput.readUTF();
        this.userRetryInterval = dataInput.readUTF();
    }

    public void readFields(DataInput dataInput) throws IOException {
        String firstField = dataInput.readUTF();
        if (!firstField.equals("_oozie_inst_v_1")) {
            this.readVersionZero(dataInput, firstField);
        } else {
            this.readVersionOne(dataInput, firstField);
        }
    }

    private void writeVersionZero(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.nodeDefVersion);
        dataOutput.writeUTF(this.name);
        if (this.cred != null) {
            dataOutput.writeUTF(this.cred);
        } else {
            dataOutput.writeUTF("null");
        }
        dataOutput.writeUTF(this.handlerClass.getName());
        if (this.conf != null) {
            this.writeString(dataOutput, this.conf);
        } else {
            dataOutput.writeUTF("null");
        }
        dataOutput.writeInt(this.transitions.size());
        for (String transition : this.transitions) {
            dataOutput.writeUTF(transition);
        }
    }

    private void writeString(DataOutput dataOutput, String value) throws IOException {
        StringSerializationUtil.writeString(dataOutput, value);
    }

    private String readString(DataInput dataInput) throws IOException {
        return StringSerializationUtil.readString(dataInput);
    }

    private void writeVersionOne(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.nodeDefVersion);
        dataOutput.writeUTF(this.name);
        if (this.cred != null) {
            this.writeString(dataOutput, this.cred);
        } else {
            dataOutput.writeUTF("null");
        }
        this.writeString(dataOutput, this.handlerClass.getName());
        if (this.conf != null) {
            this.writeString(dataOutput, this.conf);
        } else {
            dataOutput.writeUTF("null");
        }
        dataOutput.writeInt(this.transitions.size());
        for (String transition : this.transitions) {
            dataOutput.writeUTF(transition);
        }
        if (this.userRetryMax != null) {
            dataOutput.writeUTF(this.userRetryMax);
        } else {
            dataOutput.writeUTF("null");
        }
        if (this.userRetryInterval != null) {
            dataOutput.writeUTF(this.userRetryInterval);
        } else {
            dataOutput.writeUTF("null");
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (!this.getNodeDefVersion().equals("_oozie_inst_v_1")) {
            this.writeVersionZero(dataOutput);
        } else {
            this.writeVersionOne(dataOutput);
        }
    }
}

