/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.XServletException;
import org.json.simple.JSONObject;

public class V2JobServlet
extends V1JobServlet {
    private static final String INSTRUMENTATION_NAME = "v2job";

    public V2JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JsonBean getWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = super.getWorkflowJobBean(request, response);
        return jobBean;
    }

    @Override
    protected JsonBean getWorkflowAction(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean actionBean = super.getWorkflowActionBean(request, response);
        return actionBean;
    }

    @Override
    protected int getCoordinatorJobLength(int defaultLen, int len) {
        return len < 0 ? defaultLen : len;
    }

    @Override
    protected String getJMSTopicName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String topicName;
        String jobId = this.getResourceName(request);
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        try {
            topicName = dagEngine.getJMSTopicName(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return topicName;
    }

    @Override
    protected JSONObject getJobsByParentId(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        return super.getJobsByParentId(request, response);
    }

    @Override
    protected JSONObject updateJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        JSONObject json = new JSONObject();
        try {
            String jobId = this.getResourceName(request);
            boolean dryrun = StringUtils.isEmpty((String)request.getParameter("dryrun")) ? false : Boolean.parseBoolean(request.getParameter("dryrun"));
            boolean showDiff = StringUtils.isEmpty((String)request.getParameter("diff")) ? true : Boolean.parseBoolean(request.getParameter("diff"));
            String diff = coordEngine.updateJob(conf, jobId, dryrun, showDiff);
            JSONObject diffJson = new JSONObject();
            diffJson.put((Object)"diff", (Object)diff);
            json.put((Object)"update", (Object)diffJson);
        }
        catch (CoordinatorEngineException e) {
            throw new XServletException(400, e);
        }
        return json;
    }

    @Override
    protected JSONObject ignoreJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            throw new XServletException(400, ErrorCode.E0302, "Workflow Ignore Not supported");
        }
        if (jobId.endsWith("-B")) {
            throw new XServletException(400, ErrorCode.E0302, "Bundle Ignore Not supported");
        }
        return this.ignoreCoordinatorJob(request, response);
    }

    private JSONObject ignoreCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JSONObject json = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String type = request.getParameter("type");
        String scope = request.getParameter("scope");
        String changeValue = "status=" + CoordinatorAction.Status.IGNORED;
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList();
        try {
            if (type != null && !type.equals("action")) {
                throw new CommandException(ErrorCode.E1024, "Currently ignore only support -action option");
            }
            CoordinatorActionInfo coordInfo = null;
            if (scope == null || scope.isEmpty()) {
                coordEngine.change(jobId, changeValue);
            } else {
                coordInfo = coordEngine.ignore(jobId, type, scope);
            }
            if (coordInfo != null) {
                coordActions = coordInfo.getCoordActions();
                json = new JSONObject();
                json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(coordActions, "GMT"));
            }
            return json;
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected String getJobStatus(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String status;
        String jobId = this.getResourceName(request);
        try {
            if (jobId.endsWith("-B")) {
                BundleEngine engine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
                status = engine.getJobStatus(jobId);
            } else if (jobId.endsWith("-W")) {
                DagEngine engine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
                status = engine.getJobStatus(jobId);
            } else {
                CoordinatorEngine engine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
                status = jobId.contains("-C@") ? engine.getActionStatus(jobId) : engine.getJobStatus(jobId);
            }
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return status;
    }
}

