/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XConfiguration;

public class WfEndXCommand
extends WorkflowXCommand<Void> {
    private WorkflowJobBean jobBean = null;

    public WfEndXCommand(WorkflowJobBean jobBean) {
        super("wf_end", "wf_end", 1);
        this.jobBean = jobBean;
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED WFEndXCommand " + this.jobBean.getId());
        this.deleteWFDir();
        this.LOG.debug("ENDED WFEndXCommand " + this.jobBean.getId());
        return null;
    }

    private void deleteWFDir() throws CommandException {
        try {
            FileSystem fs = this.getAppFileSystem(this.jobBean);
            String wfDir = Services.get().getSystemId() + "/" + this.jobBean.getId();
            Path wfDirPath = new Path(fs.getHomeDirectory(), wfDir);
            this.LOG.debug("WF tmp dir :" + wfDirPath);
            boolean keepActionDir = this.keepWfActionDir();
            if (!keepActionDir && fs.exists(wfDirPath)) {
                fs.delete(wfDirPath, true);
            } else if (keepActionDir) {
                this.LOG.debug("oozie.action.keep.action.dir is set to true");
            } else {
                this.LOG.debug("Tmp dir doesn't exist :" + wfDirPath);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Unable to delete WF temp dir of wf id :" + this.jobBean.getId()), e);
            throw new CommandException(ErrorCode.E0819, this.jobBean.getId(), e);
        }
    }

    @VisibleForTesting
    protected boolean keepWfActionDir() throws IOException {
        if (this.jobBean.getProtoActionConf() == null) {
            return false;
        }
        Configuration wfConf = this.getWfConfiguration();
        return wfConf.getBoolean("oozie.action.keep.action.dir", false);
    }

    @VisibleForTesting
    protected Configuration getWfConfiguration() throws IOException {
        return new XConfiguration(new StringReader(this.jobBean.getProtoActionConf()));
    }

    protected FileSystem getAppFileSystem(WorkflowJob workflow) throws HadoopAccessorException, IOException, URISyntaxException {
        URI uri = new URI(workflow.getAppPath());
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        JobConf fsConf = has.createJobConf(uri.getAuthority());
        return has.createFileSystem(workflow.getUser(), uri, (Configuration)fsConf);
    }

    @Override
    public String getEntityKey() {
        return this.jobBean.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

