/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionSkipXCommand;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetReadyActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetRunningActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;
import org.jdom.JDOMException;

public class CoordActionReadyXCommand
extends CoordinatorXCommand<Void> {
    private final String jobId;
    private final XLog log = this.getLog();
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;

    public CoordActionReadyXCommand(String id) {
        super("coord_action_ready", "coord_action_ready", 1);
        this.jobId = id;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.jobId);
    }

    @Override
    protected Void execute() throws CommandException {
        CoordinatorActionBean action;
        Iterator<CoordinatorActionBean> it;
        List<CoordinatorActionBean> actions;
        int numActionsToStart = -1;
        CoordinatorJob.Execution jobExecution = this.coordJob.getExecutionOrder();
        int jobConcurrency = this.coordJob.getConcurrency();
        if (jobConcurrency >= 0) {
            int numRunningJobs;
            try {
                numRunningJobs = this.jpaService.execute(new CoordJobGetRunningActionsCountJPAExecutor(this.jobId));
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            numActionsToStart = jobConcurrency - numRunningJobs;
            if (numActionsToStart < 0) {
                numActionsToStart = 0;
            }
            this.log.debug("concurrency=" + jobConcurrency + ", execution=" + jobExecution + ", numRunningJobs=" + numRunningJobs + ", numLeftover=" + numActionsToStart);
            if (numActionsToStart == 0) {
                this.log.info("Not starting any additional actions because max concurrency [{0}] for coordinator [{1}] has been reached.", jobConcurrency, this.jobId);
            }
        }
        try {
            actions = this.jpaService.execute(new CoordJobGetReadyActionsJPAExecutor(this.jobId, jobExecution.name()));
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        this.log.debug("Number of READY actions = " + actions.size());
        Date now = new Date();
        if (jobExecution.equals((Object)CoordinatorJob.Execution.LAST_ONLY)) {
            it = actions.iterator();
            while (it.hasNext()) {
                action = it.next();
                try {
                    Date nextNominalTime = CoordCommandUtils.computeNextNominalTime(this.coordJob, action);
                    if (nextNominalTime == null) continue;
                    if (now.after(nextNominalTime)) {
                        this.LOG.info("LAST_ONLY execution: Preparing to skip action [{0}] because the current time [{1}] is later than the nominal time [{2}] of the next action]", action.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                        this.queue(new CoordActionSkipXCommand(action, this.coordJob.getUser(), this.coordJob.getAppName()));
                        it.remove();
                        continue;
                    }
                    this.LOG.debug("LAST_ONLY execution: Not skipping action [{0}] because the current time [{1}] is earlier than the nominal time [{2}] of the next action]", action.getId(), DateUtils.formatDateOozieTZ(now), DateUtils.formatDateOozieTZ(nextNominalTime));
                }
                catch (ParseException e) {
                    this.LOG.error((Object)"Should not happen", e);
                }
                catch (JDOMException e) {
                    this.LOG.error((Object)"Should not happen", e);
                }
            }
        } else if (jobExecution.equals((Object)CoordinatorJob.Execution.NONE)) {
            it = actions.iterator();
            while (it.hasNext()) {
                action = it.next();
                Calendar cal = Calendar.getInstance(DateUtils.getTimeZone(this.coordJob.getTimeZone()));
                cal.setTime(action.getNominalTime());
                int tolerance = ConfigurationService.getInt("oozie.coord.execution.none.tolerance");
                cal.add(12, tolerance);
                if (now.after(cal.getTime())) {
                    this.LOG.info("NONE execution: Preparing to skip action [{0}] because the current time [{1}] is more than [{2}] minutes later than the nominal time [{3}] of the current action]", action.getId(), DateUtils.formatDateOozieTZ(now), tolerance, DateUtils.formatDateOozieTZ(action.getNominalTime()));
                    this.queue(new CoordActionSkipXCommand(action, this.coordJob.getUser(), this.coordJob.getAppName()));
                    it.remove();
                    continue;
                }
                this.LOG.debug("NONE execution: Not skipping action [{0}] because the current time [{1}] is earlier than [{2}] minutes later than the nominal time [{3}] of the current action]", action.getId(), DateUtils.formatDateOozieTZ(now), tolerance, DateUtils.formatDateOozieTZ(action.getNominalTime()));
            }
        }
        int counter = 0;
        for (CoordinatorActionBean action2 : actions) {
            if (numActionsToStart >= 0 && counter >= numActionsToStart) break;
            this.log.debug("Set status to SUBMITTED for id: " + action2.getId());
            action2.setStatus(CoordinatorAction.Status.SUBMITTED);
            try {
                CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, action2);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            new CoordActionStartXCommand(action2.getId(), this.coordJob.getUser(), this.coordJob.getAppName(), action2.getJobId()).call(this.getEntityKey());
            ++counter;
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_ACTION_READY, this.jobId);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.RUNNINGWITHERROR && this.coordJob.getStatus() != Job.Status.SUCCEEDED && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.jobId + "]::CoordActionReady:: Ignoring job. Coordinator job is not in RUNNING state, but state=" + this.coordJob.getStatus());
        }
    }
}

