/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TreeMap;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.osgi.service.cm.Configuration;

@Command(scope="config", name="list", description="Lists existing configurations.")
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="query", description="Query in LDAP syntax. Example: \"(service.pid=org.apache.karaf.log)\"", required=false, multiValued=false)
    String query;

    protected Object doExecute() throws Exception {
        Configuration[] configs = this.configRepository.getConfigAdmin().listConfigurations(this.query);
        if (configs != null) {
            TreeMap<String, Configuration> sortedConfigs = new TreeMap<String, Configuration>();
            for (Configuration config : configs) {
                sortedConfigs.put(config.getPid(), config);
            }
            for (String pid : sortedConfigs.keySet()) {
                Configuration config = (Configuration)sortedConfigs.get(pid);
                System.out.println("----------------------------------------------------------------");
                System.out.println("Pid:            " + config.getPid());
                if (config.getFactoryPid() != null) {
                    System.out.println("FactoryPid:     " + config.getFactoryPid());
                }
                System.out.println("BundleLocation: " + config.getBundleLocation());
                if (config.getProperties() == null) continue;
                System.out.println("Properties:");
                Dictionary props = config.getProperties();
                TreeMap sortedProps = new TreeMap();
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    sortedProps.put(key.toString(), props.get(key));
                }
                for (Object key : sortedProps.keySet()) {
                    System.out.println("   " + key + " = " + sortedProps.get(key));
                }
            }
        }
        return null;
    }
}

