/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import mondrian.util.Base64;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceRecordValue;
import org.pentaho.di.trans.steps.salesforce.SalesforceStep;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputData;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputField;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputMeta;

public class SalesforceInput
extends SalesforceStep {
    private static Class<?> PKG = SalesforceInputMeta.class;
    private SalesforceInputMeta meta;
    private SalesforceInputData data;

    public SalesforceInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
            this.data.connection.query(this.meta.isSpecifyQuery());
            this.data.limitReached = true;
            this.data.recordcount = this.data.connection.getQueryResultSize();
            if (this.data.recordcount > 0) {
                this.data.limitReached = false;
                this.data.nrRecords = this.data.connection.getRecordsCount();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.RecordCount", (String[])new String[0]) + " : " + this.data.recordcount);
            }
        }
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
            }
            ++this.data.rownr;
            ++this.data.recordIndex;
            return true;
        }
        catch (KettleException e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "SalesforceInput001");
            }
            return true;
        }
    }

    private Object[] getOneRow() throws KettleException {
        if (this.data.limitReached || this.data.rownr >= (long)this.data.recordcount) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            RowMetaInterface irow;
            if (this.data.limit > 0L && this.data.rownr >= this.data.limit) {
                this.data.limitReached = true;
                return null;
            }
            if ((this.data.rownr >= (long)this.data.nrRecords || this.data.finishedRecord) && this.meta.getRecordsFilter() != 1) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.NeedQueryMore", (String[])new String[]{"" + this.data.rownr}));
                }
                if (this.data.connection.queryMore()) {
                    int nr = this.data.connection.getRecordsCount();
                    this.data.nrRecords += nr;
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.QueryMoreRetrieved", (String[])new String[]{"" + nr}));
                    }
                    this.data.recordIndex = 0;
                    this.data.finishedRecord = false;
                } else {
                    return null;
                }
            }
            SalesforceRecordValue srvalue = this.data.connection.getRecord(this.data.recordIndex);
            this.data.finishedRecord = srvalue.isAllRecordsProcessed();
            if (this.meta.getRecordsFilter() == 2) {
                if (srvalue.isRecordIndexChanges()) {
                    this.data.recordIndex = srvalue.getRecordIndex();
                }
                if (this.data.finishedRecord && srvalue.getRecordValue() == null) {
                    return null;
                }
            }
            for (int i = 0; i < this.data.nrfields; ++i) {
                String value = this.data.connection.getRecordValue(srvalue.getRecordValue(), this.meta.getInputFields()[i].getField());
                switch (this.meta.getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                this.doConversions(outputRowData, i, value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Utils.isEmpty((CharSequence)value)) continue;
                outputRowData[i] = this.data.previousRow[i];
            }
            int rowIndex = this.data.nrfields;
            if (this.meta.includeTargetURL() && !Utils.isEmpty((CharSequence)this.meta.getTargetURLField())) {
                outputRowData[rowIndex++] = this.data.connection.getURL();
            }
            if (this.meta.includeModule() && !Utils.isEmpty((CharSequence)this.meta.getModuleField())) {
                outputRowData[rowIndex++] = this.data.connection.getModule();
            }
            if (this.meta.includeSQL() && !Utils.isEmpty((CharSequence)this.meta.getSQLField())) {
                outputRowData[rowIndex++] = this.data.connection.getSQL();
            }
            if (this.meta.includeTimestamp() && !Utils.isEmpty((CharSequence)this.meta.getTimestampField())) {
                outputRowData[rowIndex++] = this.data.connection.getServerTimestamp();
            }
            if (this.meta.includeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                outputRowData[rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.includeDeletionDate() && !Utils.isEmpty((CharSequence)this.meta.getDeletionDateField())) {
                outputRowData[rowIndex++] = srvalue.getDeletionDate();
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInput.Exception.CanNotReadFromSalesforce", (String[])new String[0]), (Throwable)e);
        }
        return outputRowData;
    }

    void doConversions(Object[] outputRowData, int i, String value) throws KettleValueException {
        ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
        outputRowData[i] = 8 != targetValueMeta.getType() ? targetValueMeta.convertData(sourceValueMeta, (Object)value) : (value != null ? (Object)Base64.decode((String)value) : null);
    }

    private String BuiltSOQl() {
        String sql = "";
        SalesforceInputField[] fields = this.meta.getInputFields();
        switch (this.meta.getRecordsFilter()) {
            case 1: {
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                break;
            }
            case 2: {
                sql = sql + "SELECT ";
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + " FROM " + this.environmentSubstitute(this.meta.getModule()) + " WHERE isDeleted = true";
                break;
            }
            default: {
                sql = sql + "SELECT ";
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + " FROM " + this.environmentSubstitute(this.meta.getModule());
                if (Utils.isEmpty((CharSequence)this.environmentSubstitute(this.meta.getCondition()))) break;
                sql = sql + " WHERE " + this.environmentSubstitute(this.meta.getCondition().replace("\n\r", "").replace("\n", ""));
            }
        }
        return sql;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInputMeta)smi;
        this.data = (SalesforceInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.nrfields = this.meta.getInputFields().length;
            if (this.data.nrfields == 0) {
                this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
                return false;
            }
            String soSQL = this.environmentSubstitute(this.meta.getQuery());
            try {
                if (this.meta.isSpecifyQuery()) {
                    if (Utils.isEmpty((CharSequence)soSQL)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.QueryMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                } else if (this.meta.getRecordsFilter() != 0) {
                    String realFromDateString = this.environmentSubstitute(this.meta.getReadFrom());
                    if (Utils.isEmpty((CharSequence)realFromDateString)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FromDateMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                    String realToDateString = this.environmentSubstitute(this.meta.getReadTo());
                    if (Utils.isEmpty((CharSequence)realToDateString)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.ToDateMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(SalesforceInputMeta.DATE_TIME_FORMAT);
                        this.data.startCal = new GregorianCalendar();
                        this.data.startCal.setTime(dateFormat.parse(realFromDateString));
                        this.data.endCal = new GregorianCalendar();
                        this.data.endCal.setTime(dateFormat.parse(realToDateString));
                        dateFormat = null;
                    }
                    catch (Exception e) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.ErrorParsingDate", (String[])new String[0]), (Throwable)e);
                        return false;
                    }
                }
                this.data.limit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)0L);
                this.data.connection.setQueryAll(this.meta.isQueryAll());
                if (this.meta.isSpecifyQuery()) {
                    this.data.connection.setSQL(soSQL.replace("\n\r", " ").replace("\n", " "));
                } else {
                    if (this.meta.getRecordsFilter() != 0) {
                        this.data.connection.setCalendar(this.meta.getRecordsFilter(), this.data.startCal, this.data.endCal);
                    }
                    if (this.meta.getRecordsFilter() == 1) {
                        this.data.connection.setFieldsList(this.BuiltSOQl());
                    } else {
                        this.data.connection.setSQL(this.BuiltSOQl());
                    }
                }
                this.data.connection.connect();
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.outputRowMeta != null) {
            this.data.outputRowMeta = null;
        }
        if (this.data.convertRowMeta != null) {
            this.data.convertRowMeta = null;
        }
        if (this.data.previousRow != null) {
            this.data.previousRow = null;
        }
        if (this.data.startCal != null) {
            this.data.startCal = null;
        }
        if (this.data.endCal != null) {
            this.data.endCal = null;
        }
        super.dispose(smi, sdi);
    }
}

