/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.couchdbinput;

import java.util.List;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInput;
import org.pentaho.di.trans.steps.couchdbinput.CouchDbInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="CouchDbInput", image="couchdb-input.svg", name="CouchDbInput.Name", description="CouchDbInput.Description", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/CouchDB_Input", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.couchdbinput")
@InjectionSupported(localizationPrefix="CouchDbInput.Injection.")
public class CouchDbInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_PORT = "5984";
    public static final String DEFAULT_DB_NAME = "db";
    public static final String DEFAULT_VIEW_NAME = "design-document/view-name";
    public static final String VALUE_META_NAME = "json";
    private static Class<?> PKG = CouchDbInputMeta.class;
    @Injection(name="HOSTNAME")
    private String hostname;
    @Injection(name="PORT")
    private String port;
    @Injection(name="DBNAME")
    private String dbName;
    @Injection(name="DESIGN_DOCUMENT")
    private String designDocument;
    @Injection(name="VIEW_NAME")
    private String viewName;
    @Injection(name="AUTHENTICATION_USER")
    private String authenticationUser;
    @Injection(name="AUTHENTICATION_PASSWORD")
    private String authenticationPassword;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.hostname = XMLHandler.getTagValue((Node)stepnode, (String)"hostname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.dbName = XMLHandler.getTagValue((Node)stepnode, (String)"db_name");
            this.designDocument = XMLHandler.getTagValue((Node)stepnode, (String)"design_document");
            this.viewName = XMLHandler.getTagValue((Node)stepnode, (String)"view_name");
            this.authenticationUser = XMLHandler.getTagValue((Node)stepnode, (String)"auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.hostname = DEFAULT_HOSTNAME;
        this.port = DEFAULT_PORT;
        this.dbName = DEFAULT_DB_NAME;
        this.viewName = DEFAULT_VIEW_NAME;
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta idValueMeta = new ValueMeta(VALUE_META_NAME, 2);
        idValueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)idValueMeta);
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"db_name", (String)this.dbName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"design_document", (String)this.designDocument));
        retval.append("    ").append(XMLHandler.addTagValue((String)"view_name", (String)this.viewName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.hostname = rep.getStepAttributeString(id_step, "hostname");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.dbName = rep.getStepAttributeString(id_step, "db_name");
            this.designDocument = rep.getStepAttributeString(id_step, "design_document");
            this.viewName = rep.getStepAttributeString(id_step, "view_name");
            this.authenticationUser = rep.getStepAttributeString(id_step, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "hostname", this.hostname);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "db_name", this.dbName);
            rep.saveStepAttribute(id_transformation, id_step, "design_document", this.designDocument);
            rep.saveStepAttribute(id_transformation, id_step, "view_name", this.viewName);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.authenticationUser);
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CouchDbInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CouchDbInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new CouchDbInputData();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getDesignDocument() {
        return this.designDocument;
    }

    public void setDesignDocument(String designDocument) {
        this.designDocument = designDocument;
    }
}

