/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VSystemValue;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class VSysvalTextDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private JTextField valueText_;
    private VSystemValue systemValue_;
    private Frame frame_;
    private JButton okButton_;
    private JButton cancelButton_;
    private JButton applyButton_;
    private static final String okButtonText_ = ResourceLoader.getText("DLG_OK");
    private static final String cancelButtonText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String applyButtonText_ = ResourceLoader.getText("DLG_APPLY");
    private static final String modifyDialogTitle_ = ResourceLoader.getText("DLG_MODIFY_0");
    private static final String modifyActionTab_ = ResourceLoader.getText("ACTION_MODIFY");
    private static final String valueName_ = ResourceLoader.getText("COLUMN_NAME");
    private static final String valueDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION");
    private static final String valueInformation_ = ResourceLoader.getText("COLUMN_VALUE");

    public VSysvalTextDialog(VSystemValue vSystemValue, Frame frame) {
        super(frame, ResourceLoader.substitute(modifyDialogTitle_, vSystemValue.getName()), true);
        this.systemValue_ = vSystemValue;
        this.frame_ = frame;
        int n = this.systemValue_.getDescription().length();
        if (n <= 29) {
            n = 30;
        }
        ((Component)this).setSize(30 + 8 * n, 200);
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        this.okButton_ = new JButton(okButtonText_);
        this.cancelButton_ = new JButton(cancelButtonText_);
        this.applyButton_ = new JButton(applyButtonText_);
        this.applyButton_.setEnabled(false);
        this.okButton_.addActionListener(this);
        this.cancelButton_.addActionListener(this);
        this.applyButton_.addActionListener(this);
        jPanel.add(this.okButton_);
        jPanel.add(this.cancelButton_);
        jPanel.add(this.applyButton_);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(modifyActionTab_, this.getComponent());
        Container container = this.getContentPane();
        container.add("North", jTabbedPane);
        container.add("South", jPanel);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton_)) {
            try {
                this.applyChanges();
                this.dispose();
            }
            catch (Exception exception) {
                exception.fillInStackTrace();
                this.systemValue_.errorEventSupport_.fireError(exception);
            }
        }
        if (actionEvent.getSource().equals(this.cancelButton_)) {
            this.dispose();
        }
        if (actionEvent.getSource().equals(this.applyButton_)) {
            try {
                this.applyChanges();
                this.applyButton_.setEnabled(false);
            }
            catch (Exception exception) {
                exception.fillInStackTrace();
                this.systemValue_.errorEventSupport_.fireError(exception);
            }
        }
    }

    public void applyChanges() {
        Object object;
        int n = this.systemValue_.getType();
        switch (n) {
            case 3: {
                object = null;
                object = new Integer(this.valueText_.getText());
                this.systemValue_.setValue(object);
                break;
            }
            case 2: {
                BigDecimal bigDecimal = null;
                bigDecimal = new BigDecimal(this.valueText_.getText());
                this.systemValue_.setValue(bigDecimal);
                break;
            }
            case 1: {
                this.systemValue_.setValue(this.valueText_.getText());
            }
        }
        object = null;
        object = this.systemValue_.getValue();
        this.applyButton_.setEnabled(false);
        this.systemValue_.load();
    }

    private Component getComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        int n2 = ++n;
        ++n;
        VUtilities.constrain(valueName_ + ": ", this.systemValue_.getName(), jPanel, gridBagLayout, n2);
        ++n;
        this.valueText_ = new JTextField();
        this.valueText_.addKeyListener(this);
        int n3 = this.systemValue_.getType();
        String string = null;
        Object object = null;
        object = this.systemValue_.getValue();
        Integer n4 = null;
        BigDecimal bigDecimal = null;
        switch (n3) {
            case 3: {
                n4 = (Integer)object;
                string = n4.toString();
                break;
            }
            case 2: {
                bigDecimal = (BigDecimal)object;
                string = bigDecimal.toString();
                break;
            }
            case 1: {
                string = (String)object;
            }
        }
        this.valueText_.setText(string);
        VUtilities.constrain(new JLabel(valueInformation_ + ": "), jPanel, gridBagLayout, 0, n, 1, 1);
        VUtilities.constrain(this.valueText_, jPanel, gridBagLayout, 1, n++, 1, 1);
        ++n;
        int n5 = this.systemValue_.getDescription().length();
        if (n5 < 29) {
            StringBuffer stringBuffer = new StringBuffer(this.systemValue_.getDescription());
            for (int i = 0; i < 29 - n5; ++i) {
                stringBuffer.append(" ");
            }
            VUtilities.constrain(valueDescription_ + ": ", stringBuffer.toString(), jPanel, gridBagLayout, n++);
        } else {
            VUtilities.constrain(valueDescription_ + ": ", this.systemValue_.getDescription(), jPanel, gridBagLayout, n++);
        }
        return jPanel;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.applyButton_.setEnabled(true);
    }
}

