/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.network.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.HttpClientUtil;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.network.impl.ConnectivityTestImpl;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.test.impl.RuntimeTestResultEntryImpl;

public class GatewayConnectivityTestImpl
extends ConnectivityTestImpl {
    public static final String GATEWAY_CONNECT_TEST_CONNECT_SUCCESS_DESC = "GatewayConnectTest.Success.Desc";
    public static final String GATEWAY_CONNECT_TEST_CONNECT_SUCCESS_MESSAGE = "GatewayConnectTest.Success.Message";
    public static final String GATEWAY_CONNECT_TEST_CONNECT_UNKNOWN_RETURN_CODE_DESC = "GatewayConnectTest.UnknownReturnCode.Desc";
    public static final String GATEWAY_CONNECT_TEST_CONNECT_UNKNOWN_RETURN_CODE_MESSAGE = "GatewayConnectTest.UnknownReturnCode.Message";
    public static final String GATEWAY_CONNECT_TEST_SERVICE_NOT_FOUND_DESC = "GatewayConnectTest.ServiceNotFound.Desc";
    public static final String GATEWAY_CONNECT_TEST_SERVICE_NOT_FOUND_MESSAGE = "GatewayConnectTest.ServiceNotFound.Message";
    public static final String GATEWAY_CONNECT_TEST_FORBIDDEN_DESC = "GatewayConnectTest.Forbidden.Desc";
    public static final String GATEWAY_CONNECT_TEST_FORBIDDEN_MESSAGE = "GatewayConnectTest.Forbidden.Message";
    public static final String GATEWAY_CONNECT_TLSCONTEXT_DESC = "GatewayConnectTest.TLSContext.Desc";
    public static final String GATEWAY_CONNECT_SSLEXCEPTION_MESSAGE = "GatewayConnectTest.SSLException.Message";
    public static final String GATEWAY_CONNECT_SSLEXCEPTION_DESC = "GatewayConnectTest.SSLException.Desc";
    public static final String GATEWAY_CONNECT_TLSCONTEXT_MESSAGE = "GatewayConnectTest.TLSContext.Message";
    public static final String GATEWAY_CONNECT_TEST_UNAUTHORIZED_DESC = "GatewayConnectTest.Unauthorized.Desc";
    public static final String GATEWAY_CONNECT_TEST_UNAUTHORIZED_MESSAGE = "GatewayConnectTest.Unauthorized.Message";
    public static final String GATEWAY_CONNECT_TLSCONTEXTINIT_DESC = "GatewayConnectTest.TLSContextInit.Desc";
    public static final String GATEWAY_CONNECT_TLSCONTEXTINIT_MESSAGE = "GatewayConnectTest.TLSContextInit.Message";
    public static final String GATEWAY_CONNECT_EXECUTION_FAILED_DESC = "GatewayConnectTest.ExecutionFailed.Desc";
    public static final String GATEWAY_CONNECT_EXECUTION_FAILED_MESSAGE = "GatewayConnectTest.ExecutionFailed.Message";
    private static final Class<?> PKG = GatewayConnectivityTestImpl.class;
    private final URI uri;
    private final String path;
    private final String user;
    private final String password;
    private final Variables variables;
    private HttpClientManager httpClientManager = HttpClientManager.getInstance();

    public GatewayConnectivityTestImpl(MessageGetterFactory messageGetterFactory, URI uri, String testPath, String user, String password, RuntimeTestEntrySeverity severity) {
        super(messageGetterFactory, uri.getHost(), Integer.toString(uri.getPort()), true, severity);
        this.variables = new Variables();
        this.variables.initializeVariablesFrom(null);
        this.path = this.variables.environmentSubstitute(testPath);
        this.password = this.variables.environmentSubstitute(password);
        this.user = this.variables.environmentSubstitute(user);
        this.uri = uri.resolve(uri.getPath() + this.path);
    }

    @Override
    public RuntimeTestResultEntry runTest() {
        if (StringUtils.isBlank((String)this.hostname)) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage("ConnectTest.HostBlank.Desc", new String[0]), this.messageGetter.getMessage("ConnectTest.HostBlank.Message", new String[0]));
        }
        try {
            HttpClient httpClient;
            Integer portInt = Integer.parseInt(this.port);
            if (this.variables.getBooleanValueOfVariable("${KETTLE_KNOX_IGNORE_SSL}", false)) {
                SSLContext ctx = this.getTlsContext();
                this.initContextWithTrustAll(ctx);
                SSLContext.setDefault(ctx);
            }
            String userString = "";
            HttpClientContext context = null;
            HttpGet method = new HttpGet(this.uri.toString());
            if (StringUtils.isNotBlank((String)this.user)) {
                userString = this.user;
                httpClient = this.getHttpClient(this.user, this.password);
                context = HttpClientUtil.createPreemptiveBasicAuthentication((String)this.uri.getHost(), (int)portInt, (String)this.user, (String)this.password);
            } else {
                httpClient = this.getHttpClient();
            }
            HttpResponse httpResponse = context != null ? httpClient.execute((HttpUriRequest)method, context) : httpClient.execute((HttpUriRequest)method);
            Integer returnCode = httpResponse.getStatusLine().getStatusCode();
            switch (returnCode) {
                case 200: {
                    return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_CONNECT_SUCCESS_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_CONNECT_SUCCESS_MESSAGE, this.uri.toString()));
                }
                case 404: {
                    return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_SERVICE_NOT_FOUND_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_SERVICE_NOT_FOUND_MESSAGE, this.uri.toString()));
                }
                case 403: {
                    return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_FORBIDDEN_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_FORBIDDEN_MESSAGE, this.uri.toString(), userString));
                }
                case 401: {
                    return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_UNAUTHORIZED_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_UNAUTHORIZED_MESSAGE, this.uri.toString(), userString));
                }
            }
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.WARNING, this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_CONNECT_UNKNOWN_RETURN_CODE_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TEST_CONNECT_UNKNOWN_RETURN_CODE_MESSAGE, userString, returnCode.toString(), this.uri.toString()));
        }
        catch (NoSuchAlgorithmException e) {
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(GATEWAY_CONNECT_TLSCONTEXT_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TLSCONTEXT_MESSAGE, new String[0]), e);
        }
        catch (SSLException e) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(GATEWAY_CONNECT_SSLEXCEPTION_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_SSLEXCEPTION_MESSAGE, this.uri.toString(), e.getMessage()), e);
        }
        catch (UnknownHostException e) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage("ConnectTest.UnknownHostname.Desc", new String[0]), this.messageGetter.getMessage("ConnectTest.UnknownHostname.Message", this.uri.getHost()), e);
        }
        catch (KeyManagementException e) {
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage(GATEWAY_CONNECT_TLSCONTEXTINIT_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_TLSCONTEXTINIT_MESSAGE, new String[0]), e);
        }
        catch (IOException e) {
            return new RuntimeTestResultEntryImpl(this.severityOfFalures, this.messageGetter.getMessage(GATEWAY_CONNECT_EXECUTION_FAILED_DESC, new String[0]), this.messageGetter.getMessage(GATEWAY_CONNECT_EXECUTION_FAILED_MESSAGE, this.uri.toString()), e);
        }
        catch (NumberFormatException e) {
            return new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.FATAL, this.messageGetter.getMessage("ConnectTest.PortNumberFormat.Desc", new String[0]), this.messageGetter.getMessage("ConnectTest.PortNumberFormat.Message", this.port), e);
        }
    }

    void initContextWithTrustAll(SSLContext ctx) throws KeyManagementException {
        ctx.init(new KeyManager[0], new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, new SecureRandom());
    }

    SSLContext getTlsContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance("TLS");
    }

    @VisibleForTesting
    HttpClient getHttpClient() {
        return this.httpClientManager.createDefaultClient();
    }

    @VisibleForTesting
    HttpClient getHttpClient(String user, String password) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = this.httpClientManager.createBuilder();
        clientBuilder.setCredentials(user, password);
        return clientBuilder.build();
    }
}

