/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.mapreduce.netezza.NetezzaExternalTableExportJob;
import org.apache.sqoop.mapreduce.netezza.NetezzaExternalTableImportJob;

public class DirectNetezzaManager
extends NetezzaManager {
    public static final Log LOG = LogFactory.getLog((String)DirectNetezzaManager.class.getName());
    public static final String NETEZZA_LOG_DIR_OPT = "netezza.log.dir";
    public static final String NETEZZA_LOG_DIR_LONG_ARG = "log-dir";
    public static final String NETEZZA_ERROR_THRESHOLD_OPT = "netezza.error.threshold";
    public static final String NETEZZA_ERROR_THRESHOLD_LONG_ARG = "max-errors";
    public static final String NETEZZA_CTRL_CHARS_OPT = "netezza.ctrl.chars";
    public static final String NETEZZA_CTRL_CHARS_LONG_ARG = "ctrl-chars";
    public static final String NETEZZA_CRIN_STRING_OPT = "netezza.crin.string";
    public static final String NETEZZA_CRIN_STRING_LONG_ARG = "crin-string";
    public static final String NETEZZA_IGNORE_ZERO_OPT = "netezza.ignore.zero";
    public static final String NETEZZA_IGNORE_ZERO_LONG_ARG = "ignore-zero";
    public static final String NETEZZA_TRUNC_STRING_OPT = "netezza.trunc.string";
    public static final String NETEZZA_TRUNC_STRING_LONG_ARG = "trunc-string";
    public static final String NETEZZA_TABLE_ENCODING_OPT = "netezza.table.encoding";
    public static final String NETEZZA_TABLE_ENCODING_LONG_ARG = "encoding";
    private static final String QUERY_CHECK_DICTIONARY_FOR_TABLE = "SELECT 1 FROM _V_TABLE WHERE OWNER= ?  AND TABLENAME = ?";
    public static final String NETEZZA_NULL_VALUE = "netezza.exttable.null.value";

    public DirectNetezzaManager(SqoopOptions opts) {
        super(opts);
        try {
            this.handleNetezzaExtraArgs(this.options);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe.getMessage(), pe);
        }
    }

    private void checkNullValueStrings(String nullStrValue, String nullNonStrValue) throws IOException {
        if (!StringUtils.equals((String)nullStrValue, (String)nullNonStrValue)) {
            throw new IOException("Detected different values of --input-string and --input-non-string parameters. Netezza direct manager does not support that. Please either use the same values or omit the --direct parameter.");
        }
        if (nullStrValue != null) {
            if ((nullStrValue = StringEscapeUtils.unescapeJava((String)nullStrValue)).length() > 4) {
                throw new IOException("Null string (and null non string) values for Netezza direct mode manager must be less than 4 characters in length");
            }
            this.options.getConf().set(NETEZZA_NULL_VALUE, nullStrValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTable() throws IOException, ExportException {
        String tableName;
        String tableOwner = this.options.getUsername();
        String shortTableName = tableName = this.options.getTableName();
        int qualifierIndex = tableName.indexOf(46);
        if (qualifierIndex != -1) {
            tableOwner = tableName.substring(0, qualifierIndex);
            shortTableName = tableName.substring(qualifierIndex + 1);
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.getConnection();
                ps = conn.prepareStatement(QUERY_CHECK_DICTIONARY_FOR_TABLE, 1003, 1007);
                ps.setString(1, tableOwner);
                ps.setString(2, shortTableName);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    String message = tableName + " is not a valid Netezza table.  Please make sure that you have connected to the Netezza DB and the table name is right.   The current values are\n\t  connection string : " + this.options.getConnectString() + "\n\t  table owner : " + tableOwner + "\n\t  table name : " + shortTableName;
                    LOG.error((Object)message);
                    throw new IOException(message);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                this.close();
            }
        }
        catch (SQLException sqle) {
            throw new IOException("SQL exception checking table " + sqle.getMessage(), sqle);
        }
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        this.options = context.getOptions();
        context.setConnManager(this);
        this.checkTable();
        NetezzaExternalTableExportJob exporter = null;
        char qc = this.options.getInputEnclosedBy();
        char ec = this.options.getInputEscapedBy();
        this.checkNullValueStrings(this.options.getInNullStringValue(), this.options.getInNullNonStringValue());
        if (qc > '\u0000' && qc != '\"' && qc != '\'') {
            throw new ExportException("Input enclosed-by character must be '\"' or ''' for netezza direct mode exports");
        }
        if (ec > '\u0000' && ec != '\\') {
            throw new ExportException("Input escaped-by character must be '\\' for netezza direct mode exports");
        }
        exporter = new NetezzaExternalTableExportJob(context);
        exporter.runExport();
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        String tableName = context.getTableName();
        String jarFile = context.getJarFile();
        SqoopOptions options = context.getOptions();
        if (null == tableName) {
            LOG.error((Object)"Netezza external table import does not support query imports.");
            LOG.error((Object)"Do not use --direct and --query together for Netezza.");
            throw new IOException("Null tableName for Netezza external table import.");
        }
        this.checkNullValueStrings(options.getNullStringValue(), options.getNullNonStringValue());
        char qc = options.getOutputEnclosedBy();
        char ec = options.getOutputEscapedBy();
        if (qc > '\u0000' && qc != '\"' && qc != '\'') {
            throw new ImportException("Output enclosed-by character must be '\"' or ''' for netezza direct mode imports");
        }
        if (ec > '\u0000' && ec != '\\') {
            throw new ImportException("Output escaped-by character must be '\\' for netezza direct mode exports");
        }
        NetezzaExternalTableImportJob importer = null;
        importer = new NetezzaExternalTableImportJob(options, context);
        LOG.info((Object)"Beginning netezza fast path import");
        if (options.getFileLayout() != SqoopOptions.FileLayout.TextFile) {
            LOG.warn((Object)("File import layout " + (Object)((Object)options.getFileLayout()) + " is not supported by"));
            LOG.warn((Object)"Netezza direct import; import will proceed as text files.");
        }
        importer.runImport(tableName, jarFile, null, options.getConf());
    }

    @Override
    protected RelatedOptions getNetezzaExtraOpts() {
        RelatedOptions netezzaOpts = new RelatedOptions("Netezza Connector Direct mode options");
        OptionBuilder.withArgName((String)NETEZZA_ERROR_THRESHOLD_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Error threshold for the job");
        OptionBuilder.withLongOpt((String)NETEZZA_ERROR_THRESHOLD_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_LOG_DIR_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Netezza log directory");
        OptionBuilder.withLongOpt((String)NETEZZA_LOG_DIR_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_CTRL_CHARS_OPT);
        OptionBuilder.withDescription((String)"Allow control chars in data");
        OptionBuilder.withLongOpt((String)NETEZZA_CTRL_CHARS_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_TRUNC_STRING_OPT);
        OptionBuilder.withDescription((String)"Truncate string to declared storage size");
        OptionBuilder.withLongOpt((String)NETEZZA_TRUNC_STRING_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_CRIN_STRING_OPT);
        OptionBuilder.withDescription((String)"Truncate string to declared storage size");
        OptionBuilder.withLongOpt((String)NETEZZA_CRIN_STRING_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_IGNORE_ZERO_OPT);
        OptionBuilder.withDescription((String)"Truncate string to declared storage size");
        OptionBuilder.withLongOpt((String)NETEZZA_IGNORE_ZERO_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)NETEZZA_TABLE_ENCODING_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Table encoding");
        OptionBuilder.withLongOpt((String)NETEZZA_TABLE_ENCODING_LONG_ARG);
        netezzaOpts.addOption(OptionBuilder.create());
        return netezzaOpts;
    }

    private void handleNetezzaExtraArgs(SqoopOptions opts) throws ParseException {
        Configuration conf = opts.getConf();
        String[] extraArgs = opts.getExtraArgs();
        RelatedOptions netezzaOpts = this.getNetezzaExtraOpts();
        CommandLine cmdLine = new GnuParser().parse((Options)netezzaOpts, extraArgs, true);
        if (cmdLine.hasOption(NETEZZA_ERROR_THRESHOLD_LONG_ARG)) {
            int threshold = Integer.parseInt(cmdLine.getOptionValue(NETEZZA_ERROR_THRESHOLD_LONG_ARG));
            conf.setInt(NETEZZA_ERROR_THRESHOLD_OPT, threshold);
        }
        if (cmdLine.hasOption(NETEZZA_LOG_DIR_LONG_ARG)) {
            String dir = cmdLine.getOptionValue(NETEZZA_LOG_DIR_LONG_ARG);
            conf.set(NETEZZA_LOG_DIR_OPT, dir);
        }
        if (cmdLine.hasOption(NETEZZA_TABLE_ENCODING_LONG_ARG)) {
            String encoding = cmdLine.getOptionValue(NETEZZA_TABLE_ENCODING_LONG_ARG);
            conf.set(NETEZZA_TABLE_ENCODING_OPT, encoding);
        }
        conf.setBoolean(NETEZZA_CTRL_CHARS_OPT, cmdLine.hasOption(NETEZZA_CTRL_CHARS_LONG_ARG));
        conf.setBoolean(NETEZZA_TRUNC_STRING_OPT, cmdLine.hasOption(NETEZZA_TRUNC_STRING_LONG_ARG));
        conf.setBoolean(NETEZZA_CRIN_STRING_OPT, cmdLine.hasOption(NETEZZA_CRIN_STRING_LONG_ARG));
        conf.setBoolean(NETEZZA_IGNORE_ZERO_OPT, cmdLine.hasOption(NETEZZA_IGNORE_ZERO_LONG_ARG));
        conf.setBoolean("netezza.dataslice.aligned.access", true);
    }

    @Override
    public boolean supportsStagingForExport() {
        return false;
    }

    @Override
    public boolean isORMFacilitySelfManaged() {
        return this.options.getHCatTableName() == null;
    }

    @Override
    public boolean isDirectModeHCatSupported() {
        return true;
    }

    public static String getLocalLogDir(TaskAttemptID attemptId) {
        int tid = attemptId.getTaskID().getId();
        int aid = attemptId.getId();
        String jid = attemptId.getJobID().toString();
        StringBuilder sb = new StringBuilder(jid).append('-');
        sb.append(tid).append('-').append(aid);
        String localLogDir = sb.toString();
        return localLogDir;
    }
}

