/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.Management;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;
import org.pentaho.di.version.BuildVersion;

public class SystemData
extends BaseStep
implements StepInterface {
    private SystemDataMeta meta;
    private SystemDataData data;

    public SystemData(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getSystemData(RowMetaInterface inputRowMeta, Object[] inputRowData) throws KettleException {
        int i;
        Object[] row = new Object[this.data.outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < this.meta.getFieldName().length) {
            int argnr = 0;
            switch (this.meta.getFieldType()[i]) {
                case TYPE_SYSTEM_INFO_SYSTEM_START: {
                    row[index] = this.getTrans().getCurrentDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_SYSTEM_DATE: {
                    row[index] = new Date();
                    break;
                }
                case TYPE_SYSTEM_INFO_TRANS_DATE_FROM: {
                    row[index] = this.getTrans().getStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_TRANS_DATE_TO: {
                    row[index] = this.getTrans().getEndDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_JOB_DATE_FROM: {
                    row[index] = this.getTrans().getJobStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_JOB_DATE_TO: {
                    row[index] = this.getTrans().getJobEndDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_COPYNR: {
                    row[index] = new Long(this.getCopy());
                    break;
                }
                case TYPE_SYSTEM_INFO_TRANS_NAME: {
                    row[index] = this.getTransMeta().getName();
                    break;
                }
                case TYPE_SYSTEM_INFO_MODIFIED_USER: {
                    row[index] = this.getTransMeta().getModifiedUser();
                    break;
                }
                case TYPE_SYSTEM_INFO_MODIFIED_DATE: {
                    row[index] = this.getTransMeta().getModifiedDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_TRANS_BATCH_ID: {
                    row[index] = new Long(this.getTrans().getBatchId());
                    break;
                }
                case TYPE_SYSTEM_INFO_JOB_BATCH_ID: {
                    row[index] = new Long(this.getTrans().getPassedBatchId());
                    break;
                }
                case TYPE_SYSTEM_INFO_HOSTNAME_REAL: {
                    row[index] = Const.getHostnameReal();
                    break;
                }
                case TYPE_SYSTEM_INFO_HOSTNAME: {
                    row[index] = Const.getHostname();
                    break;
                }
                case TYPE_SYSTEM_INFO_IP_ADDRESS: {
                    try {
                        row[index] = Const.getIPAddress();
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                }
                case TYPE_SYSTEM_INFO_FILENAME: {
                    row[index] = this.getTransMeta().getFilename();
                    break;
                }
                case TYPE_SYSTEM_INFO_ARGUMENT_01: 
                case TYPE_SYSTEM_INFO_ARGUMENT_02: 
                case TYPE_SYSTEM_INFO_ARGUMENT_03: 
                case TYPE_SYSTEM_INFO_ARGUMENT_04: 
                case TYPE_SYSTEM_INFO_ARGUMENT_05: 
                case TYPE_SYSTEM_INFO_ARGUMENT_06: 
                case TYPE_SYSTEM_INFO_ARGUMENT_07: 
                case TYPE_SYSTEM_INFO_ARGUMENT_08: 
                case TYPE_SYSTEM_INFO_ARGUMENT_09: 
                case TYPE_SYSTEM_INFO_ARGUMENT_10: {
                    argnr = this.meta.getFieldType()[i].ordinal() - SystemDataTypes.TYPE_SYSTEM_INFO_ARGUMENT_01.ordinal();
                    if (this.getTrans().getArguments() != null && argnr < this.getTrans().getArguments().length) {
                        row[index] = this.getTrans().getArguments()[argnr];
                        break;
                    }
                    row[index] = null;
                    break;
                }
                case TYPE_SYSTEM_INFO_KETTLE_VERSION: {
                    row[index] = BuildVersion.getInstance().getVersion();
                    break;
                }
                case TYPE_SYSTEM_INFO_KETTLE_BUILD_VERSION: {
                    row[index] = BuildVersion.getInstance().getVersion();
                    break;
                }
                case TYPE_SYSTEM_INFO_KETTLE_BUILD_DATE: {
                    row[index] = BuildVersion.getInstance().getBuildDateAsLocalDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_CURRENT_PID: {
                    row[index] = new Long(Management.getPID());
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_TOTAL_MEMORY: {
                    row[index] = Runtime.getRuntime().totalMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_FREE_MEMORY: {
                    row[index] = Runtime.getRuntime().freeMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_MAX_MEMORY: {
                    row[index] = Runtime.getRuntime().maxMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_AVAILABLE_MEMORY: {
                    Runtime rt = Runtime.getRuntime();
                    row[index] = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
                    break;
                }
                case TYPE_SYSTEM_INFO_AVAILABLE_PROCESSORS: {
                    row[index] = (long)Runtime.getRuntime().availableProcessors();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_CPU_TIME: {
                    row[index] = Management.getJVMCpuTime() / 1000000L;
                    break;
                }
                case TYPE_SYSTEM_INFO_TOTAL_PHYSICAL_MEMORY_SIZE: {
                    row[index] = Management.getTotalPhysicalMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_TOTAL_SWAP_SPACE_SIZE: {
                    row[index] = Management.getTotalSwapSpaceSize();
                    break;
                }
                case TYPE_SYSTEM_INFO_COMMITTED_VIRTUAL_MEMORY_SIZE: {
                    row[index] = Management.getCommittedVirtualMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_FREE_PHYSICAL_MEMORY_SIZE: {
                    row[index] = Management.getFreePhysicalMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_FREE_SWAP_SPACE_SIZE: {
                    row[index] = Management.getFreeSwapSpaceSize();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 0 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 2 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 5 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, -1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 2);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_RESULT: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    boolean result = false;
                    if (previousResult != null) {
                        result = previousResult.getResult();
                    }
                    row[index] = result;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_EXIT_STATUS: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getExitStatus();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_ENTRY_NR: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getEntryNr();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getResultFiles().size();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES_RETRIEVED: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrFilesRetrieved();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_DELETED: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesDeleted();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_INPUT: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesInput();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_OUTPUT: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesOutput();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_READ: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRead();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_REJECTED: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRejected();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_UPDATED: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesUpdated();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_WRITTEN: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesWritten();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ROWS: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getRows().size();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_IS_STOPPED: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    boolean stop = false;
                    if (previousResult != null) {
                        stop = previousResult.isStopped();
                    }
                    row[index] = stop;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ERRORS: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrErrors();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_LOG_TEXT: {
                    Result previousResult = this.getTrans().getPreviousResult();
                    String errorReason = null;
                    if (previousResult != null) {
                        errorReason = previousResult.getLogText();
                    }
                    row[index] = errorReason;
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        if (this.data.readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getSystemData(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel("System info returned: " + this.data.outputRowMeta.getString(row));
        }
        this.putRow(this.data.outputRowMeta, row);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SystemDataMeta)smi;
        this.data = (SystemDataData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

