/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ssh;

import com.trilead.ssh2.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;

public class SessionResult {
    private String stdout;
    private String stderr;
    private boolean stderrortype;

    public SessionResult(Session session) throws KettleException {
        this.readStd(session);
    }

    private void setStdErr(String value) {
        this.stderr = value;
        if (!Utils.isEmpty((CharSequence)this.getStdErr())) {
            this.setStdTypeErr(true);
        }
    }

    public String getStdErr() {
        return this.stderr;
    }

    public String getStd() {
        return this.getStdOut() + this.getStdErr();
    }

    private void setStdOut(String value) {
        this.stdout = value;
    }

    public String getStdOut() {
        return this.stdout;
    }

    private void setStdTypeErr(boolean value) {
        this.stderrortype = value;
    }

    public boolean isStdTypeErr() {
        return this.stderrortype;
    }

    private void readStd(Session session) throws KettleException {
        InputStream isOut = null;
        InputStream isErr = null;
        try {
            isOut = session.getStdout();
            isErr = session.getStderr();
            this.setStdOut(this.readInputStream(isOut));
            this.setStdErr(this.readInputStream(isErr));
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                if (isOut != null) {
                    isOut.close();
                }
                if (isErr != null) {
                    isErr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String readInputStream(InputStream std) throws KettleException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(std));
            String line = "";
            StringBuilder stringStdout = new StringBuilder();
            line = br.readLine();
            if (line != null) {
                stringStdout.append(line);
            }
            while ((line = br.readLine()) != null) {
                stringStdout.append("\n" + line);
            }
            String string = stringStdout.toString();
            return string;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

