/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fixedinput;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.w3c.dom.Node;

public class FixedFileInputField
implements Cloneable,
XMLInterface {
    public static final String XML_TAG = "field";
    private static final String[] date_formats = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMdd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy", "d-M-yy", "d/M/yy"};
    private static final String[] number_formats = new String[]{"", "#", Const.DEFAULT_NUMBER_FORMAT, "0.00", "0000000000000", "###,###,###.#######", "###############.###############", "#####.###############%"};
    private String name;
    private int type;
    private int width;
    private int length;
    private int precision;
    private String format;
    private int trimType;
    private String decimal;
    private String grouping;
    private String currency;
    private String[] samples;

    public FixedFileInputField(Node fnode) {
        this.name = XMLHandler.getTagValue((Node)fnode, (String)"name");
        this.type = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type"));
        this.format = XMLHandler.getTagValue((Node)fnode, (String)"format");
        this.trimType = ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type"));
        this.currency = XMLHandler.getTagValue((Node)fnode, (String)"currency");
        this.decimal = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
        this.grouping = XMLHandler.getTagValue((Node)fnode, (String)"group");
        this.width = Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"width"), (int)-1);
        this.length = Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1);
        this.precision = Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1);
    }

    public FixedFileInputField() {
        this.type = 2;
        this.length = -1;
        this.precision = -1;
        this.trimType = 0;
    }

    protected FixedFileInputField(String name) {
        this();
        this.name = name;
    }

    public boolean equals(Object obj) {
        return this.name.equalsIgnoreCase(((FixedFileInputField)obj).name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.type)));
        retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.format));
        retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMetaString.getTrimTypeCode((int)this.trimType)));
        retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency));
        retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal));
        retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.grouping));
        retval.append("        ").append(XMLHandler.addTagValue((String)"width", (int)this.width));
        retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.length));
        retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.precision));
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String decimal) {
        this.decimal = decimal;
    }

    public String getGrouping() {
        return this.grouping;
    }

    public void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public void guess() {
        this.guessType();
    }

    public void guessType() {
        NumberFormat nf = NumberFormat.getInstance();
        DecimalFormat df = (DecimalFormat)nf;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        SimpleDateFormat daf = new SimpleDateFormat();
        daf.setLenient(false);
        this.type = 2;
        if (this.samples == null) {
            return;
        }
        int datefmt_cnt = date_formats.length;
        boolean[] datefmt = new boolean[date_formats.length];
        for (int i = 0; i < date_formats.length; ++i) {
            datefmt[i] = true;
        }
        int datenul = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            for (int x = 0; x < date_formats.length; ++x) {
                if (this.samples[i] == null || Const.onlySpaces((String)this.samples[i]) || this.samples[i].length() == 0) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
                if (!datefmt[x]) continue;
                try {
                    daf.applyPattern(date_formats[x]);
                    Date date = daf.parse(this.samples[i]);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int year = cal.get(1);
                    if (year >= 1800 && year <= 2200) continue;
                    datefmt[x] = false;
                    --datefmt_cnt;
                    continue;
                }
                catch (Exception e) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
            }
        }
        if (datefmt_cnt > 0 && datenul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < date_formats.length && first < 0; ++i) {
                if (!datefmt[i]) continue;
                first = i;
            }
            this.type = 3;
            this.format = date_formats[first];
            return;
        }
        boolean isnumber = true;
        this.decimal = "" + dfs.getDecimalSeparator();
        this.grouping = "" + dfs.getGroupingSeparator();
        boolean[] numfmt = new boolean[number_formats.length];
        int[] maxprecision = new int[number_formats.length];
        for (int i = 0; i < numfmt.length; ++i) {
            numfmt[i] = true;
            maxprecision[i] = -1;
        }
        int numfmt_cnt = number_formats.length;
        int numnul = 0;
        for (int i = 0; i < this.samples.length && isnumber; ++i) {
            int x;
            boolean contains_dot = false;
            boolean contains_comma = false;
            String field = this.samples[i];
            for (x = 0; x < field.length() && isnumber; ++x) {
                char ch = field.charAt(x);
                if (!(Character.isDigit(ch) || ch == '.' || ch == ',' || ch == '-' && x <= 0 || ch == 'E' || ch == 'e')) {
                    isnumber = false;
                    numfmt_cnt = 0;
                    continue;
                }
                if (ch == '.') {
                    contains_dot = true;
                }
                if (ch != ',') continue;
                contains_comma = true;
            }
            if (!isnumber) continue;
            if (contains_dot && !contains_comma) {
                dfs.setDecimalSeparator('.');
                this.decimal = ".";
                dfs.setGroupingSeparator(',');
                this.grouping = ",";
            } else if (!contains_dot && contains_comma) {
                dfs.setDecimalSeparator(',');
                this.decimal = ",";
                dfs.setGroupingSeparator('.');
                this.grouping = ".";
            } else if (contains_dot && contains_comma) {
                int idx_com;
                int idx_dot = field.indexOf(46);
                if (idx_dot > (idx_com = field.indexOf(44))) {
                    dfs.setDecimalSeparator('.');
                    this.decimal = ".";
                    dfs.setGroupingSeparator(',');
                    this.grouping = ",";
                } else {
                    dfs.setDecimalSeparator(',');
                    this.decimal = ",";
                    dfs.setGroupingSeparator('.');
                    this.grouping = ".";
                }
            }
            for (x = 0; x < number_formats.length; ++x) {
                if (!numfmt[x]) continue;
                boolean islong = true;
                try {
                    int prec = -1;
                    if (!contains_dot && !contains_comma) {
                        try {
                            Long.parseLong(field);
                            prec = 0;
                        }
                        catch (Exception e) {
                            islong = false;
                        }
                    }
                    if (!islong) {
                        df.setDecimalFormatSymbols(dfs);
                        df.applyPattern(number_formats[x]);
                        double d = df.parse(field).doubleValue();
                        prec = FixedFileInputField.guessPrecision(d);
                    }
                    if (prec <= maxprecision[x]) continue;
                    maxprecision[x] = prec;
                    continue;
                }
                catch (Exception e) {
                    numfmt[x] = false;
                    --numfmt_cnt;
                }
            }
        }
        if (numfmt_cnt > 0 && numnul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < number_formats.length && first < 0; ++i) {
                if (!numfmt[i]) continue;
                first = i;
            }
            this.type = 1;
            this.format = number_formats[first];
            this.precision = maxprecision[first];
            return;
        }
        this.type = 2;
        this.format = "";
        this.precision = -1;
        this.decimal = "";
        this.grouping = "";
        this.currency = "";
    }

    public static final int guessPrecision(double d) {
        int maxprec = 4;
        double maxdiff = 5.0E-5;
        double diff = Math.abs(Math.floor(d) - d);
        if (diff < maxdiff) {
            return 0;
        }
        for (int i = 1; i < maxprec; ++i) {
            double factor = Math.pow(10.0, i);
            diff = Math.abs(Math.floor(d * factor) - d * factor);
            if (diff < maxdiff) {
                return i;
            }
            factor *= 10.0;
        }
        return -1;
    }

    public int getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }
}

