/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.KettleAttribute;
import org.pentaho.di.core.KettleAttributeInterface;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BaseStepMeta
implements Cloneable,
StepAttributesInterface {
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Step metadata", LoggingObjectType.STEPMETA, null);
    public static final String STEP_ATTRIBUTES_FILE = "step-attributes.xml";
    private boolean changed = false;
    protected Database[] databases;
    protected Repository repository;
    protected StepMeta parentStepMeta;
    private volatile StepIOMetaInterface ioMetaVar;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected LogChannelInterface log;
    protected ArrayList<KettleAttributeInterface> attributes;

    public BaseStepMeta() {
        try {
            this.loadStepAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            BaseStepMeta retval = (BaseStepMeta)super.clone();
            this.lock.readLock().lock();
            try {
                if (this.ioMetaVar != null) {
                    StepIOMeta stepIOMeta = new StepIOMeta(this.ioMetaVar.isInputAcceptor(), this.ioMetaVar.isOutputProducer(), this.ioMetaVar.isInputOptional(), this.ioMetaVar.isSortedDataRequired(), this.ioMetaVar.isInputDynamic(), this.ioMetaVar.isOutputDynamic());
                    List<StreamInterface> infoStreams = this.ioMetaVar.getInfoStreams();
                    for (StreamInterface infoStream : infoStreams) {
                        stepIOMeta.addStream(new Stream(infoStream));
                    }
                    List<StreamInterface> targetStreams = this.ioMetaVar.getTargetStreams();
                    for (StreamInterface targetStream : targetStreams) {
                        stepIOMeta.addStream(new Stream(targetStream));
                    }
                    this.lock.readLock().unlock();
                    retval.setStepIOMeta(stepIOMeta);
                    this.lock.readLock().lock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public void setChanged() {
        this.changed = true;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public RowMetaInterface getTableFields() {
        return null;
    }

    public String getXML() throws KettleException {
        return "";
    }

    @Deprecated
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Deprecated
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Deprecated
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) throws KettleStepException {
        return new SQLStatement(stepMeta.getName(), null, null);
    }

    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        return new SQLStatement(stepMeta.getName(), null, null);
    }

    public void cancelQueries() throws KettleDatabaseException {
        if (this.databases != null) {
            for (int i = 0; i < this.databases.length; ++i) {
                if (this.databases[i] == null) continue;
                this.databases[i].cancelQuery();
            }
        }
    }

    public Map<String, String> getUsedArguments() {
        return null;
    }

    @Deprecated
    public RowMetaInterface getRequiredFields() throws KettleException {
        return new RowMeta();
    }

    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        return new RowMeta();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public String[] getUsedLibraries() {
        return new String[0];
    }

    public boolean supportsErrorHandling() {
        return false;
    }

    public boolean excludeFromRowLayoutVerification() {
        return false;
    }

    public boolean excludeFromCopyDistributeVerification() {
        return false;
    }

    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        return Arrays.asList(new ResourceReference(stepInfo));
    }

    @Deprecated
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        return null;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        return null;
    }

    @Deprecated
    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if ((className = className.replaceFirst("\\.di\\.", ".di.ui.")).endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "Dialog";
        return className;
    }

    public StepMeta getParentStepMeta() {
        return this.parentStepMeta;
    }

    public void setParentStepMeta(StepMeta parentStepMeta) {
        this.parentStepMeta = parentStepMeta;
    }

    public LogChannelInterface getLog() {
        if (this.log == null) {
            this.log = new LogChannel((Object)this);
        }
        return this.log;
    }

    public boolean isBasic() {
        return this.getLog().isBasic();
    }

    public boolean isDetailed() {
        return this.getLog().isDetailed();
    }

    public boolean isDebug() {
        return this.getLog().isDebug();
    }

    public boolean isRowLevel() {
        return this.getLog().isRowLevel();
    }

    public void logMinimal(String message) {
        this.getLog().logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.getLog().logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.getLog().logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.getLog().logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.getLog().logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.getLog().logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.getLog().logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.getLog().logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.getLog().logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.getLog().logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.getLog().logError(message);
    }

    public void logError(String message, Throwable e) {
        this.getLog().logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.getLog().logError(message, arguments);
    }

    public String getLogChannelId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getObjectCopy() {
        return null;
    }

    public ObjectId getObjectId() {
        return null;
    }

    public ObjectRevision getObjectRevision() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return null;
    }

    public LoggingObjectInterface getParent() {
        return null;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return null;
    }

    public StepIOMetaInterface getStepIOMeta() {
        return this.getStepIOMeta(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepIOMetaInterface getStepIOMeta(boolean createIfAbsent) {
        StepIOMetaInterface ioMeta = null;
        this.lock.readLock().lock();
        try {
            if (this.ioMetaVar == null && createIfAbsent) {
                ioMeta = new StepIOMeta(true, true, true, false, false, false);
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    this.ioMetaVar = ioMeta;
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                ioMeta = this.ioMetaVar;
            }
            StepIOMetaInterface stepIOMetaInterface = ioMeta;
            return stepIOMetaInterface;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setStepIOMeta(StepIOMetaInterface value) {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<StreamInterface> getOptionalStreams() {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        return list;
    }

    public void handleStreamSelection(StreamInterface stream) {
    }

    public void resetStepIoMeta() {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
    }

    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return null;
    }

    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    protected StepInjectionMetaEntry findParentEntry(List<StepInjectionMetaEntry> entries, String key) {
        for (StepInjectionMetaEntry look : entries) {
            if (look.getKey().equals(key)) {
                return look;
            }
            StepInjectionMetaEntry check = this.findParentEntry(look.getDetails(), key);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    protected StepInjectionMetaEntry createEntry(KettleAttributeInterface attr, Class<?> PKG) {
        return new StepInjectionMetaEntry(attr.getKey(), attr.getType(), BaseMessages.getString(PKG, (String)attr.getDescription(), (String[])new String[0]));
    }

    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries(Class<?> PKG) {
        ArrayList<StepInjectionMetaEntry> entries = new ArrayList<StepInjectionMetaEntry>();
        for (KettleAttributeInterface attr : this.attributes) {
            if (attr.getParent() == null) {
                entries.add(this.createEntry(attr, PKG));
                continue;
            }
            StepInjectionMetaEntry entry = this.createEntry(attr, PKG);
            StepInjectionMetaEntry parentEntry = this.findParentEntry(entries, attr.getParent().getKey());
            if (parentEntry == null) {
                throw new RuntimeException("An error was detected in the step attributes' definition: the parent was not found for attribute " + attr);
            }
            parentEntry.getDetails().add(entry);
        }
        return entries;
    }

    protected void loadStepAttributes() throws KettleException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(STEP_ATTRIBUTES_FILE);){
            if (inputStream != null) {
                Document document = XMLHandler.loadXMLFile((InputStream)inputStream);
                Node attrsNode = XMLHandler.getSubNode((Node)document, (String)"attributes");
                List nodes = XMLHandler.getNodes((Node)attrsNode, (String)"attribute");
                this.attributes = new ArrayList();
                for (Node node : nodes) {
                    String key = XMLHandler.getTagAttribute((Node)node, (String)"id");
                    String xmlCode = XMLHandler.getTagValue((Node)node, (String)"xmlcode");
                    String repCode = XMLHandler.getTagValue((Node)node, (String)"repcode");
                    String description = XMLHandler.getTagValue((Node)node, (String)"description");
                    String tooltip = XMLHandler.getTagValue((Node)node, (String)"tooltip");
                    int valueType = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)node, (String)"valuetype"));
                    String parentId = XMLHandler.getTagValue((Node)node, (String)"parentid");
                    KettleAttribute attribute = new KettleAttribute(key, xmlCode, repCode, description, tooltip, valueType, this.findParent(this.attributes, parentId));
                    this.attributes.add((KettleAttributeInterface)attribute);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load file step-attributes.xml", (Throwable)e);
        }
    }

    @Override
    public KettleAttributeInterface findParent(List<KettleAttributeInterface> attributes, String parentId) {
        if (Utils.isEmpty((CharSequence)parentId)) {
            return null;
        }
        for (KettleAttributeInterface attribute : attributes) {
            if (!attribute.getKey().equals(parentId)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public KettleAttributeInterface findAttribute(String key) {
        for (KettleAttributeInterface attribute : this.attributes) {
            if (!attribute.getKey().equals(key)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public String getXmlCode(String attributeKey) {
        return this.findAttribute(attributeKey).getXmlCode();
    }

    @Override
    public String getRepCode(String attributeKey) {
        KettleAttributeInterface attr = this.findAttribute(attributeKey);
        return Utils.isEmpty((CharSequence)attr.getRepCode()) ? attr.getXmlCode() : attr.getRepCode();
    }

    @Override
    public String getDescription(String attributeKey) {
        return this.findAttribute(attributeKey).getDescription();
    }

    @Override
    public String getTooltip(String attributeKey) {
        return this.findAttribute(attributeKey).getTooltip();
    }

    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal, TransMeta.TransformationType.SingleThreaded};
    }

    public boolean hasRepositoryReferences() {
        return false;
    }

    public void lookupRepositoryReferences(Repository repository) throws KettleException {
    }

    public String[] getReferencedObjectDescriptions() {
        return null;
    }

    public boolean[] isReferencedObjectEnabled() {
        return null;
    }

    public String getActiveReferencedObjectDescription() {
        return null;
    }

    @Deprecated
    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        return null;
    }

    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return null;
    }

    @Deprecated
    public void readRep(Repository rep, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
    }

    @Deprecated
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
    }

    @Deprecated
    public void loadXML(Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
    }

    @Deprecated
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
    }

    @Deprecated
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
    }

    @Deprecated
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    @Deprecated
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) {
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }
}

