/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.attributes.AttributesUtil;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.IdNotFoundException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.exception.LookupReferencesException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.JobEntryLogTable;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LogTablePluginInterface;
import org.pentaho.di.core.logging.LogTablePluginType;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.reflection.StringSearcher;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLFormatter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobMeta
extends AbstractMeta
implements Cloneable,
Comparable<JobMeta>,
XMLInterface,
ResourceExportInterface,
RepositoryElementInterface,
LoggingObjectInterface {
    private static Class<?> PKG = JobMeta.class;
    public static final String XML_TAG = "job";
    protected static final String XML_TAG_SLAVESERVERS = "slaveservers";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.JOB;
    static final int BORDER_INDENT = 20;
    protected String jobVersion;
    protected int jobStatus;
    protected List<JobEntryCopy> jobcopies;
    protected List<JobHopMeta> jobhops;
    protected String[] arguments;
    protected boolean changedEntries;
    protected boolean changedHops;
    protected JobLogTable jobLogTable;
    protected JobEntryLogTable jobEntryLogTable;
    protected List<LogTableInterface> extraLogTables;
    protected String startCopyName;
    protected boolean expandingRemoteJob;
    protected LogChannelInterface log;
    public static final String STRING_SPECIAL = "SPECIAL";
    public static final String STRING_SPECIAL_START = "START";
    public static final String STRING_SPECIAL_DUMMY = "DUMMY";
    public static final String STRING_SPECIAL_OK = "OK";
    public static final String STRING_SPECIAL_ERROR = "ERROR";
    protected Map<String, Boolean> loopCache;
    public boolean[] max = new boolean[1];
    protected boolean batchIdPassed;
    protected static final String XML_TAG_PARAMETERS = "parameters";
    private List<MissingEntry> missingEntries;

    public JobMeta() {
        this.clear();
        this.initializeVariablesFrom(null);
    }

    @Override
    public void clear() {
        this.jobcopies = new ArrayList<JobEntryCopy>();
        this.jobhops = new ArrayList<JobHopMeta>();
        this.jobLogTable = JobLogTable.getDefault(this, this);
        this.jobEntryLogTable = JobEntryLogTable.getDefault(this, this);
        this.extraLogTables = new ArrayList<LogTableInterface>();
        List plugins = PluginRegistry.getInstance().getPlugins(LogTablePluginType.class);
        for (PluginInterface plugin : plugins) {
            try {
                LogTablePluginInterface logTablePluginInterface = (LogTablePluginInterface)PluginRegistry.getInstance().loadClass(plugin);
                if (logTablePluginInterface.getType() != LogTablePluginInterface.TableType.JOB) continue;
                logTablePluginInterface.setContext(this, this);
                this.extraLogTables.add(logTablePluginInterface);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error loading log table plugin with ID " + plugin.getIds()[0], (Throwable)e);
            }
        }
        this.arguments = null;
        super.clear();
        this.loopCache = new HashMap<String, Boolean>();
        this.addDefaults();
        this.jobStatus = -1;
        this.jobVersion = null;
        this.log = LogChannel.GENERAL;
    }

    public void addDefaults() {
        this.clearChanged();
    }

    public static final JobEntryCopy createStartEntry() {
        JobEntrySpecial jobEntrySpecial = new JobEntrySpecial(BaseMessages.getString(PKG, (String)"JobMeta.StartJobEntry.Name", (String[])new String[0]), true, false);
        JobEntryCopy jobEntry = new JobEntryCopy();
        jobEntry.setObjectId(null);
        jobEntry.setEntry(jobEntrySpecial);
        jobEntry.setLocation(50, 50);
        jobEntry.setDrawn(false);
        jobEntry.setDescription(BaseMessages.getString(PKG, (String)"JobMeta.StartJobEntry.Description", (String[])new String[0]));
        return jobEntry;
    }

    public static final JobEntryCopy createDummyEntry() {
        JobEntrySpecial jobEntrySpecial = new JobEntrySpecial(BaseMessages.getString(PKG, (String)"JobMeta.DummyJobEntry.Name", (String[])new String[0]), false, true);
        JobEntryCopy jobEntry = new JobEntryCopy();
        jobEntry.setObjectId(null);
        jobEntry.setEntry(jobEntrySpecial);
        jobEntry.setLocation(50, 50);
        jobEntry.setDrawn(false);
        jobEntry.setDescription(BaseMessages.getString(PKG, (String)"JobMeta.DummyJobEntry.Description", (String[])new String[0]));
        return jobEntry;
    }

    public JobEntryCopy getStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isStart()) continue;
            return cge;
        }
        return null;
    }

    public JobEntryCopy getDummy() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isDummy()) continue;
            return cge;
        }
        return null;
    }

    public int compare(JobMeta j1, JobMeta j2) {
        return super.compare(j1, j2);
    }

    @Override
    public int compareTo(JobMeta o) {
        return this.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobMeta)) {
            return false;
        }
        return this.compare(this, (JobMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            JobMeta jobMeta = (JobMeta)super.clone();
            if (doClear) {
                jobMeta.clear();
            } else {
                jobMeta.jobcopies = new ArrayList<JobEntryCopy>();
                jobMeta.jobhops = new ArrayList<JobHopMeta>();
                jobMeta.notes = new ArrayList();
                jobMeta.databases = new ArrayList();
                jobMeta.slaveServers = new ArrayList();
                jobMeta.namedParams = new NamedParamsDefault();
            }
            for (JobEntryCopy jobEntryCopy : this.jobcopies) {
                jobMeta.jobcopies.add((JobEntryCopy)jobEntryCopy.clone_deep());
            }
            for (JobHopMeta jobHopMeta : this.jobhops) {
                jobMeta.jobhops.add((JobHopMeta)jobHopMeta.clone());
            }
            for (NotePadMeta notePadMeta : this.notes) {
                jobMeta.notes.add((NotePadMeta)notePadMeta.clone());
            }
            for (DatabaseMeta databaseMeta : this.databases) {
                jobMeta.databases.add((DatabaseMeta)databaseMeta.clone());
            }
            for (SlaveServer slaveServer : this.slaveServers) {
                jobMeta.getSlaveServers().add((SlaveServer)slaveServer.clone());
            }
            for (Iterator<XMLInterface> iterator : this.listParameters()) {
                jobMeta.addParameterDefinition((String)((Object)iterator), this.getParameterDefault((String)((Object)iterator)), this.getParameterDescription((String)((Object)iterator)));
            }
            return jobMeta;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JobLogTable getJobLogTable() {
        return this.jobLogTable;
    }

    public void setJobLogTable(JobLogTable jobLogTable) {
        this.jobLogTable = jobLogTable;
    }

    @Override
    public void clearChanged() {
        this.changedEntries = false;
        this.changedHops = false;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            entry.setChanged(false);
        }
        for (JobHopMeta hi : this.jobhops) {
            hi.setChanged(false);
        }
        super.clearChanged();
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveJobEntriesChanged()) {
            return true;
        }
        return this.haveJobHopsChanged();
    }

    private Set<DatabaseMeta> getUsedDatabaseMetas() {
        HashSet<DatabaseMeta> databaseMetas = new HashSet<DatabaseMeta>();
        for (JobEntryCopy jobEntryCopy : this.getJobCopies()) {
            DatabaseMeta[] dbs = jobEntryCopy.getEntry().getUsedDatabaseConnections();
            if (dbs == null) continue;
            for (DatabaseMeta db : dbs) {
                databaseMetas.add(db);
            }
        }
        databaseMetas.add(this.jobLogTable.getDatabaseMeta());
        for (LogTableInterface logTable : this.getExtraLogTables()) {
            databaseMetas.add(logTable.getDatabaseMeta());
        }
        return databaseMetas;
    }

    public boolean isDatabaseConnectionUsed(DatabaseMeta databaseMeta) {
        return this.getUsedDatabaseMetas().contains(databaseMeta);
    }

    @Override
    public String getFileType() {
        return "Job";
    }

    @Override
    public String[] getFilterNames() {
        return Const.getJobFilterNames();
    }

    @Override
    public String[] getFilterExtensions() {
        return Const.STRING_JOB_FILTER_EXT;
    }

    @Override
    public String getDefaultExtension() {
        return "kjb";
    }

    @Override
    public String getXML() {
        int i;
        this.getNamedClusterEmbedManager().clear();
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        StringBuilder retval = new StringBuilder(500);
        retval.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("  ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("  ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("  ").append(XMLHandler.addTagValue((String)"extended_description", (String)this.extendedDescription));
        retval.append("  ").append(XMLHandler.addTagValue((String)"job_version", (String)this.jobVersion));
        if (this.jobStatus >= 0) {
            retval.append("  ").append(XMLHandler.addTagValue((String)"job_status", (int)this.jobStatus));
        }
        retval.append("  ").append(XMLHandler.addTagValue((String)"directory", (String)(this.directory != null ? this.directory.getPath() : "/")));
        retval.append("  ").append(XMLHandler.addTagValue((String)"created_user", (String)this.createdUser));
        retval.append("  ").append(XMLHandler.addTagValue((String)"created_date", (String)XMLHandler.date2string((Date)this.createdDate)));
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_user", (String)this.modifiedUser));
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_date", (String)XMLHandler.date2string((Date)this.modifiedDate)));
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        String[] parameters = this.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameter")).append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)parameters[idx]));
            try {
                retval.append("        ").append(XMLHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
                retval.append("        ").append(XMLHandler.addTagValue((String)"description", (String)this.getParameterDescription(parameters[idx])));
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameter")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        Set<DatabaseMeta> usedDatabaseMetas = this.getUsedDatabaseMetas();
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta dbMeta = this.getDatabase(i);
            if (props != null && props.areOnlyUsedConnectionsSavedToXML()) {
                if (!usedDatabaseMetas.contains(dbMeta)) continue;
                retval.append(dbMeta.getXML());
                continue;
            }
            retval.append(dbMeta.getXML());
        }
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        for (i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)this.slaveServers.get(i);
            retval.append(slaveServer.getXML());
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        for (LogTableInterface logTable : this.getLogTables()) {
            retval.append(logTable.getXML());
        }
        retval.append("   ").append(XMLHandler.addTagValue((String)"pass_batchid", (boolean)this.batchIdPassed));
        retval.append("   ").append(XMLHandler.addTagValue((String)"shared_objects_file", (String)this.sharedObjectsFile));
        retval.append("  ").append(XMLHandler.openTag((String)"entries")).append(Const.CR);
        for (int i2 = 0; i2 < this.nrJobEntries(); ++i2) {
            JobEntryCopy jge = this.getJobEntry(i2);
            jge.getEntry().setRepository(this.repository);
            retval.append(jge.getXML());
        }
        retval.append("  ").append(XMLHandler.closeTag((String)"entries")).append(Const.CR);
        retval.append("  ").append(XMLHandler.openTag((String)"hops")).append(Const.CR);
        for (JobHopMeta hi : this.jobhops) {
            retval.append(hi.getXML());
        }
        retval.append("  ").append(XMLHandler.closeTag((String)"hops")).append(Const.CR);
        retval.append("  ").append(XMLHandler.openTag((String)"notepads")).append(Const.CR);
        for (int i3 = 0; i3 < this.nrNotes(); ++i3) {
            NotePadMeta ni = this.getNote(i3);
            retval.append(ni.getXML());
        }
        retval.append("  ").append(XMLHandler.closeTag((String)"notepads")).append(Const.CR);
        retval.append(AttributesUtil.getAttributesXml(this.attributesMap));
        retval.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return XMLFormatter.format((String)retval.toString());
    }

    public JobMeta(String fname, Repository rep) throws KettleXMLException {
        this(null, fname, rep, null);
    }

    public JobMeta(String fname, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this(null, fname, rep, prompter);
    }

    @Deprecated
    public JobMeta(VariableSpace parentSpace, String fname, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this(parentSpace, fname, rep, null, prompter);
    }

    public JobMeta(VariableSpace parentSpace, String fname, Repository rep, IMetaStore metaStore, OverwritePrompter prompter) throws KettleXMLException {
        this.initializeVariablesFrom(parentSpace);
        this.metaStore = metaStore;
        try {
            Document doc = XMLHandler.loadXMLFile((FileObject)KettleVFS.getFileObject((String)fname, (VariableSpace)this));
            if (doc == null) {
                throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.ErrorReadingFromXMLFile", (String[])new String[0]) + fname);
            }
            Node jobnode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            this.loadXML(jobnode, fname, rep, metaStore, false, prompter);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.UnableToLoadJobFromXMLFile", (String[])new String[0]) + fname + "]", (Throwable)e);
        }
    }

    public JobMeta(InputStream inputStream, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this();
        Document doc = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)false, (boolean)false);
        this.loadXML(XMLHandler.getSubNode((Node)doc, (String)XML_TAG), rep, prompter);
    }

    public JobMeta(Node jobnode, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this();
        this.loadXML(jobnode, rep, false, prompter);
    }

    public JobMeta(Node jobnode, Repository rep, boolean ignoreRepositorySharedObjects, OverwritePrompter prompter) throws KettleXMLException {
        this();
        this.loadXML(jobnode, rep, ignoreRepositorySharedObjects, prompter);
    }

    public boolean isRepReference() {
        return JobMeta.isRepReference(this.getFilename(), this.getName());
    }

    public boolean isFileReference() {
        return !JobMeta.isRepReference(this.getFilename(), this.getName());
    }

    public static boolean isRepReference(String fileName, String transName) {
        return Utils.isEmpty((CharSequence)fileName) && !Utils.isEmpty((CharSequence)transName);
    }

    public static boolean isFileReference(String fileName, String transName) {
        return !JobMeta.isRepReference(fileName, transName);
    }

    public void loadXML(Node jobnode, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this.loadXML(jobnode, rep, false, prompter);
    }

    public void loadXML(Node jobnode, String fname, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this.loadXML(jobnode, fname, rep, false, prompter);
    }

    public void loadXML(Node jobnode, Repository rep, boolean ignoreRepositorySharedObjects, OverwritePrompter prompter) throws KettleXMLException {
        this.loadXML(jobnode, null, rep, ignoreRepositorySharedObjects, prompter);
    }

    @Deprecated
    public void loadXML(Node jobnode, String fname, Repository rep, boolean ignoreRepositorySharedObjects, OverwritePrompter prompter) throws KettleXMLException {
        this.loadXML(jobnode, fname, rep, null, ignoreRepositorySharedObjects, prompter);
    }

    public void loadXML(Node jobnode, String fname, Repository rep, IMetaStore metaStore, boolean ignoreRepositorySharedObjects, OverwritePrompter prompter) throws KettleXMLException {
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        try {
            String directoryPath;
            this.clear();
            if (null == rep) {
                this.setFilename(fname);
            } else {
                this.setRepository(rep);
            }
            this.setName(XMLHandler.getTagValue((Node)jobnode, (String)"name"));
            if (rep != null && (directoryPath = XMLHandler.getTagValue((Node)jobnode, (String)"directory")) != null) {
                this.directory = rep.findDirectory(directoryPath);
                if (this.directory == null) {
                    this.directory = new RepositoryDirectory();
                }
            }
            this.description = XMLHandler.getTagValue((Node)jobnode, (String)"description");
            this.extendedDescription = XMLHandler.getTagValue((Node)jobnode, (String)"extended_description");
            this.jobVersion = XMLHandler.getTagValue((Node)jobnode, (String)"job_version");
            this.jobStatus = Const.toInt((String)XMLHandler.getTagValue((Node)jobnode, (String)"job_status"), (int)-1);
            this.createdUser = XMLHandler.getTagValue((Node)jobnode, (String)"created_user");
            String createDate = XMLHandler.getTagValue((Node)jobnode, (String)"created_date");
            if (createDate != null) {
                this.createdDate = XMLHandler.stringToDate((String)createDate);
            }
            this.modifiedUser = XMLHandler.getTagValue((Node)jobnode, (String)"modified_user");
            String modDate = XMLHandler.getTagValue((Node)jobnode, (String)"modified_date");
            if (modDate != null) {
                this.modifiedDate = XMLHandler.stringToDate((String)modDate);
            }
            try {
                this.sharedObjectsFile = XMLHandler.getTagValue((Node)jobnode, (String)"shared_objects_file");
                this.sharedObjects = rep == null || ignoreRepositorySharedObjects ? this.readSharedObjects() : rep.readJobMetaSharedObjects(this);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"JobMeta.ErrorReadingSharedObjects.Message", (String[])new String[]{e.toString()}));
                LogChannel.GENERAL.logError(Const.getStackTracker((Throwable)e));
            }
            this.importFromMetaStore();
            Node paramsNode = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG_PARAMETERS);
            int nrParams = XMLHandler.countNodes((Node)paramsNode, (String)"parameter");
            for (int i = 0; i < nrParams; ++i) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramsNode, (String)"parameter", (int)i);
                String paramName = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                String defValue = XMLHandler.getTagValue((Node)paramNode, (String)"default_value");
                String descr = XMLHandler.getTagValue((Node)paramNode, (String)"description");
                this.addParameterDefinition(paramName, defValue, descr);
            }
            int nr = XMLHandler.countNodes((Node)jobnode, (String)"connection");
            HashSet<String> privateDatabases = new HashSet<String>(nr);
            for (int i = 0; i < nr; ++i) {
                DatabaseMeta exist;
                Node dbnode = XMLHandler.getSubNodeByNr((Node)jobnode, (String)"connection", (int)i);
                DatabaseMeta dbcon = new DatabaseMeta(dbnode);
                dbcon.shareVariablesWith((VariableSpace)this);
                if (!dbcon.isShared()) {
                    privateDatabases.add(dbcon.getName());
                }
                if ((exist = this.findDatabase(dbcon.getName())) == null) {
                    this.addDatabase(dbcon);
                    continue;
                }
                if (exist.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"JobMeta.Dialog.ConnectionExistsOverWrite.Message", (String[])new String[]{dbcon.getName()}), BaseMessages.getString(PKG, (String)"JobMeta.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                int idx = this.indexOfDatabase(exist);
                this.removeDatabase(idx);
                this.addDatabase(idx, dbcon);
            }
            this.setPrivateDatabases(privateDatabases);
            Node slaveServersNode = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG_SLAVESERVERS);
            int nrSlaveServers = XMLHandler.countNodes((Node)slaveServersNode, (String)"slaveserver");
            for (int i = 0; i < nrSlaveServers; ++i) {
                Node slaveServerNode = XMLHandler.getSubNodeByNr((Node)slaveServersNode, (String)"slaveserver", (int)i);
                SlaveServer slaveServer = new SlaveServer(slaveServerNode);
                slaveServer.shareVariablesWith(this);
                SlaveServer check = this.findSlaveServer(slaveServer.getName());
                if (check != null) {
                    if (check.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"JobMeta.Dialog.SlaveServerExistsOverWrite.Message", (String[])new String[]{slaveServer.getName()}), BaseMessages.getString(PKG, (String)"JobMeta.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                    this.addOrReplaceSlaveServer(slaveServer);
                    continue;
                }
                this.slaveServers.add(slaveServer);
            }
            Node jobLogNode = XMLHandler.getSubNode((Node)jobnode, (String)"job-log-table");
            if (jobLogNode == null) {
                this.jobLogTable.setConnectionName(XMLHandler.getTagValue((Node)jobnode, (String)"logconnection"));
                this.jobLogTable.setTableName(XMLHandler.getTagValue((Node)jobnode, (String)"logtable"));
                this.jobLogTable.setBatchIdUsed("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"use_batchid")));
                this.jobLogTable.setLogFieldUsed("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"use_logfield")));
                this.jobLogTable.findField(JobLogTable.ID.CHANNEL_ID).setEnabled(false);
                this.jobLogTable.findField(JobLogTable.ID.LINES_REJECTED).setEnabled(false);
            } else {
                this.jobLogTable.loadXML(jobLogNode, this.databases, null);
            }
            Node channelLogTableNode = XMLHandler.getSubNode((Node)jobnode, (String)"channel-log-table");
            if (channelLogTableNode != null) {
                this.channelLogTable.loadXML(channelLogTableNode, this.databases, null);
            }
            this.jobEntryLogTable.loadXML(jobnode, this.databases, null);
            for (LogTableInterface extraLogTable : this.extraLogTables) {
                extraLogTable.loadXML(jobnode, this.databases, null);
            }
            this.batchIdPassed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"pass_batchid"));
            Node entriesnode = XMLHandler.getSubNode((Node)jobnode, (String)"entries");
            int tr = XMLHandler.countNodes((Node)entriesnode, (String)"entry");
            for (int i = 0; i < tr; ++i) {
                JobEntryCopy prev;
                Node entrynode = XMLHandler.getSubNodeByNr((Node)entriesnode, (String)"entry", (int)i);
                JobEntryCopy je = new JobEntryCopy(entrynode, this.databases, this.slaveServers, rep, metaStore);
                if (je.isSpecial() && je.isMissing()) {
                    this.addMissingEntry((MissingEntry)je.getEntry());
                }
                if ((prev = this.findJobEntry(je.getName(), 0, true)) != null) {
                    int idx;
                    if (je.getNr() == 0) {
                        idx = this.indexOfJobEntry(prev);
                        this.removeJobEntry(idx);
                    } else if (je.getNr() > 0) {
                        je.setEntry(prev.getEntry());
                        prev = this.findJobEntry(je.getName(), je.getNr(), true);
                        if (prev != null) {
                            idx = this.indexOfJobEntry(prev);
                            this.removeJobEntry(idx);
                        }
                    }
                }
                this.addJobEntry(je);
            }
            Node hopsnode = XMLHandler.getSubNode((Node)jobnode, (String)"hops");
            int ho = XMLHandler.countNodes((Node)hopsnode, (String)"hop");
            for (int i = 0; i < ho; ++i) {
                Node hopnode = XMLHandler.getSubNodeByNr((Node)hopsnode, (String)"hop", (int)i);
                JobHopMeta hi = new JobHopMeta(hopnode, this);
                this.jobhops.add(hi);
            }
            Node notepadsnode = XMLHandler.getSubNode((Node)jobnode, (String)"notepads");
            int nrnotes = XMLHandler.countNodes((Node)notepadsnode, (String)"notepad");
            for (int i = 0; i < nrnotes; ++i) {
                Node notepadnode = XMLHandler.getSubNodeByNr((Node)notepadsnode, (String)"notepad", (int)i);
                NotePadMeta ni = new NotePadMeta(notepadnode);
                this.notes.add(ni);
            }
            this.attributesMap = AttributesUtil.loadAttributes(XMLHandler.getSubNode((Node)jobnode, (String)"attributes"));
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobMetaLoaded.id, (Object)this);
            this.clearChanged();
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.UnableToLoadJobFromXMLNode", (String[])new String[0]), (Throwable)e);
        }
        finally {
            this.setInternalKettleVariables();
        }
    }

    public JobEntryCopy getJobEntryCopy(int x, int y, int iconsize) {
        int s = this.nrJobEntries();
        for (int i = s - 1; i >= 0; --i) {
            JobEntryCopy je = this.getJobEntry(i);
            Point p = je.getLocation();
            if (p == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize) continue;
            return je;
        }
        return null;
    }

    public int nrJobEntries() {
        return this.jobcopies.size();
    }

    public int nrJobHops() {
        return this.jobhops.size();
    }

    public JobHopMeta getJobHop(int i) {
        return this.jobhops.get(i);
    }

    public JobEntryCopy getJobEntry(int i) {
        return this.jobcopies.get(i);
    }

    public void addJobEntry(JobEntryCopy je) {
        this.jobcopies.add(je);
        je.setParentJobMeta(this);
        this.setChanged();
    }

    public void addJobHop(JobHopMeta hi) {
        this.jobhops.add(hi);
        this.setChanged();
    }

    public void addJobEntry(int p, JobEntryCopy si) {
        this.jobcopies.add(p, si);
        this.changedEntries = true;
    }

    public void addJobHop(int p, JobHopMeta hi) {
        try {
            this.jobhops.add(p, hi);
        }
        catch (IndexOutOfBoundsException e) {
            this.jobhops.add(hi);
        }
        this.changedHops = true;
    }

    public void removeJobEntry(int i) {
        JobEntryCopy deleted = this.jobcopies.remove(i);
        if (deleted != null) {
            deleted.setParentJobMeta(null);
            if (deleted.getEntry() instanceof MissingEntry) {
                this.removeMissingEntry((MissingEntry)deleted.getEntry());
            }
        }
        this.setChanged();
    }

    public void removeJobHop(int i) {
        this.jobhops.remove(i);
        this.setChanged();
    }

    public void removeJobHop(JobHopMeta hop) {
        this.jobhops.remove(hop);
        this.setChanged();
    }

    public int indexOfJobHop(JobHopMeta he) {
        return this.jobhops.indexOf(he);
    }

    public int indexOfJobEntry(JobEntryCopy ge) {
        return this.jobcopies.indexOf(ge);
    }

    public void setJobEntry(int idx, JobEntryCopy jec) {
        this.jobcopies.set(idx, jec);
    }

    public JobEntryCopy findJobEntry(String name, int nr, boolean searchHiddenToo) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            if (!jec.getName().equalsIgnoreCase(name) || jec.getNr() != nr || !searchHiddenToo && !jec.isDrawn()) continue;
            return jec;
        }
        return null;
    }

    public JobEntryCopy findJobEntry(String full_name_nr) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            JobEntryInterface je = jec.getEntry();
            if (!je.toString().equalsIgnoreCase(full_name_nr)) continue;
            return jec;
        }
        return null;
    }

    public JobHopMeta findJobHop(String name) {
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopFrom(JobEntryCopy jge) {
        if (jge != null) {
            for (JobHopMeta hi : this.jobhops) {
                if (hi == null || hi.getFromEntry() == null || !hi.getFromEntry().equals(jge)) continue;
                return hi;
            }
        }
        return null;
    }

    public JobHopMeta findJobHop(JobEntryCopy from, JobEntryCopy to) {
        return this.findJobHop(from, to, false);
    }

    public JobHopMeta findJobHop(JobEntryCopy from, JobEntryCopy to, boolean includeDisabled) {
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() && !includeDisabled || hi == null || hi.getFromEntry() == null || hi.getToEntry() == null || !hi.getFromEntry().equals(from) || !hi.getToEntry().equals(to)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopTo(JobEntryCopy jge) {
        for (JobHopMeta hi : this.jobhops) {
            if (hi == null || hi.getToEntry() == null || !hi.getToEntry().equals(jge)) continue;
            return hi;
        }
        return null;
    }

    public int findNrPrevJobEntries(JobEntryCopy from) {
        return this.findNrPrevJobEntries(from, false);
    }

    public JobEntryCopy findPrevJobEntry(JobEntryCopy to, int nr) {
        return this.findPrevJobEntry(to, nr, false);
    }

    public int findNrPrevJobEntries(JobEntryCopy to, boolean info) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || !hi.getToEntry().equals(to)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findPrevJobEntry(JobEntryCopy to, int nr, boolean info) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || !hi.getToEntry().equals(to)) continue;
            if (count == nr) {
                return hi.getFromEntry();
            }
            ++count;
        }
        return null;
    }

    public int findNrNextJobEntries(JobEntryCopy from) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || hi.getFromEntry() == null || !hi.getFromEntry().equals(from)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findNextJobEntry(JobEntryCopy from, int cnt) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || hi.getFromEntry() == null || !hi.getFromEntry().equals(from)) continue;
            if (count == cnt) {
                return hi.getToEntry();
            }
            ++count;
        }
        return null;
    }

    public boolean hasLoop(JobEntryCopy entry) {
        this.clearLoopCache();
        return this.hasLoop(entry, null);
    }

    @Deprecated
    public boolean hasLoop(JobEntryCopy entry, JobEntryCopy lookup, boolean info) {
        return this.hasLoop(entry, lookup);
    }

    public boolean hasLoop(JobEntryCopy entry, JobEntryCopy lookup) {
        return this.hasLoop(entry, lookup, new HashSet<JobEntryCopy>());
    }

    private boolean hasLoop(JobEntryCopy entry, JobEntryCopy lookup, HashSet<JobEntryCopy> checkedEntries) {
        String cacheKey = entry.getName() + " - " + (lookup != null ? lookup.getName() : "");
        Boolean hasLoop = this.loopCache.get(cacheKey);
        if (hasLoop != null) {
            return hasLoop;
        }
        hasLoop = false;
        checkedEntries.add(entry);
        int nr = this.findNrPrevJobEntries(entry);
        for (int i = 0; i < nr; ++i) {
            JobEntryCopy prevJobMeta = this.findPrevJobEntry(entry, i);
            if (prevJobMeta == null || !prevJobMeta.equals(lookup) && (checkedEntries.contains(prevJobMeta) || !this.hasLoop(prevJobMeta, lookup == null ? entry : lookup, checkedEntries))) continue;
            hasLoop = true;
            break;
        }
        this.loopCache.put(cacheKey, hasLoop);
        return hasLoop;
    }

    private void clearLoopCache() {
        this.loopCache.clear();
    }

    public boolean isEntryUsedInHops(JobEntryCopy jge) {
        JobHopMeta fr = this.findJobHopFrom(jge);
        JobHopMeta to = this.findJobHopTo(jge);
        return fr != null || to != null;
    }

    public int countEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    public int findUnusedNr(String name) {
        int nr = 1;
        JobEntryCopy je = this.findJobEntry(name, nr, true);
        while (je != null) {
            je = this.findJobEntry(name, ++nr, true);
        }
        return nr;
    }

    public int findMaxNr(String name) {
        int max = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name) || je.getNr() <= max) continue;
            max = je.getNr();
        }
        return max;
    }

    public String getAlternativeJobentryName(String entryname) {
        String newname = entryname;
        JobEntryCopy jec = this.findJobEntry(newname);
        int nr = 1;
        while (jec != null) {
            newname = entryname + " " + ++nr;
            jec = this.findJobEntry(newname);
        }
        return newname;
    }

    public JobEntryCopy[] getAllJobGraphEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        JobEntryCopy[] retval = new JobEntryCopy[count];
        count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            retval[count] = je;
            ++count;
        }
        return retval;
    }

    public JobHopMeta[] getAllJobHopsUsing(String name) {
        ArrayList<JobHopMeta> hops = new ArrayList<JobHopMeta>();
        for (JobHopMeta hi : this.jobhops) {
            if (hi.getFromEntry() == null || hi.getToEntry() == null || !hi.getFromEntry().getName().equalsIgnoreCase(name) && !hi.getToEntry().getName().equalsIgnoreCase(name)) continue;
            hops.add(hi);
        }
        return hops.toArray(new JobHopMeta[hops.size()]);
    }

    public boolean isPathExist(JobEntryInterface from, JobEntryInterface to) {
        for (JobHopMeta hi : this.jobhops) {
            if (hi.getFromEntry() == null || hi.getToEntry() == null || !hi.getFromEntry().getName().equalsIgnoreCase(from.getName())) continue;
            if (hi.getToEntry().getName().equalsIgnoreCase(to.getName())) {
                return true;
            }
            if (!this.isPathExist(hi.getToEntry().getEntry(), to)) continue;
            return true;
        }
        return false;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(true);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            loc = entry.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            loc = ni.getLocation();
            if (loc.x + ni.width > maxx) {
                maxx = loc.x + ni.width;
            }
            if (loc.y + ni.height <= maxy) continue;
            maxy = loc.y + ni.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point getMinimum() {
        Point loc;
        int i;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jobEntryCopy = this.getJobEntry(i);
            loc = jobEntryCopy.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            loc = notePadMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        minx = minx > 20 && minx != Integer.MAX_VALUE ? (minx -= 20) : 0;
        miny = miny > 20 && miny != Integer.MAX_VALUE ? (miny -= 20) : 0;
        return new Point(minx, miny);
    }

    public Point[] getSelectedLocations() {
        List<JobEntryCopy> selectedEntries = this.getSelectedEntries();
        Point[] retval = new Point[selectedEntries.size()];
        for (int i = 0; i < retval.length; ++i) {
            JobEntryCopy si = selectedEntries.get(i);
            Point p = si.getLocation();
            retval[i] = new Point(p.x, p.y);
        }
        return retval;
    }

    public Point[] getSelectedNoteLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (NotePadMeta ni : this.getSelectedNotes()) {
            Point p = ni.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public List<JobEntryCopy> getSelectedEntries() {
        ArrayList<JobEntryCopy> selection = new ArrayList<JobEntryCopy>();
        for (JobEntryCopy je : this.jobcopies) {
            if (!je.isSelected()) continue;
            selection.add(je);
        }
        return selection;
    }

    public int[] getEntryIndexes(List<JobEntryCopy> entries) {
        int[] retval = new int[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            retval[i] = this.indexOfJobEntry(entries.get(i));
        }
        return retval;
    }

    public JobEntryCopy findStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            if (!this.getJobEntry(i).isStart()) continue;
            return this.getJobEntry(i);
        }
        return null;
    }

    public String toString() {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            if (Utils.isEmpty((CharSequence)this.name)) {
                return this.filename;
            }
            return this.filename + " : " + this.name;
        }
        if (this.name != null) {
            if (this.directory != null) {
                String path = this.directory.getPath();
                if (path.endsWith("/")) {
                    return path + this.name;
                }
                return path + "/" + this.name;
            }
            return this.name;
        }
        return JobMeta.class.getName();
    }

    public boolean isBatchIdPassed() {
        return this.batchIdPassed;
    }

    public void setBatchIdPassed(boolean batchIdPassed) {
        this.batchIdPassed = batchIdPassed;
    }

    public List<SQLStatement> getSQLStatements(Repository repository, ProgressMonitorListener monitor) throws KettleException {
        return this.getSQLStatements(repository, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLStatement> getSQLStatements(Repository repository, IMetaStore metaStore, ProgressMonitorListener monitor) throws KettleException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.GettingSQLNeededForThisJob", (String[])new String[0]), this.nrJobEntries() + 1);
        }
        ArrayList<SQLStatement> stats = new ArrayList<SQLStatement>();
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy copy = this.getJobEntry(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.GettingSQLForJobEntryCopy", (String[])new String[0]) + copy + "]");
            }
            stats.addAll(copy.getEntry().getSQLStatements(repository, metaStore, this));
            stats.addAll(this.compatibleGetEntrySQLStatements(copy.getEntry(), repository));
            stats.addAll(this.compatibleGetEntrySQLStatements(copy.getEntry(), repository, this));
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.GettingSQLStatementsForJobLogTables", (String[])new String[0]));
        }
        if (this.jobLogTable.getDatabaseMeta() != null && !Utils.isEmpty((CharSequence)this.jobLogTable.getTableName())) {
            Database db = new Database((LoggingObjectInterface)this, this.jobLogTable.getDatabaseMeta());
            try {
                db.connect();
                RowMetaInterface fields = this.jobLogTable.getLogRecord(LogStatus.START, null, null).getRowMeta();
                String sql = db.getDDL(this.jobLogTable.getTableName(), fields);
                if (sql != null && sql.length() > 0) {
                    SQLStatement stat = new SQLStatement(BaseMessages.getString(PKG, (String)"JobMeta.SQLFeedback.ThisJob", (String[])new String[0]), this.jobLogTable.getDatabaseMeta(), sql);
                    stats.add(stat);
                }
            }
            catch (KettleDatabaseException dbe) {
                SQLStatement stat = new SQLStatement(BaseMessages.getString(PKG, (String)"JobMeta.SQLFeedback.ThisJob", (String[])new String[0]), this.jobLogTable.getDatabaseMeta(), null);
                stat.setError(BaseMessages.getString(PKG, (String)"JobMeta.SQLFeedback.ErrorObtainingJobLogTableInfo", (String[])new String[0]) + dbe.getMessage());
                stats.add(stat);
            }
            finally {
                db.disconnect();
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    private Collection<? extends SQLStatement> compatibleGetEntrySQLStatements(JobEntryInterface entry, Repository repository, VariableSpace variableSpace) throws KettleException {
        return entry.getSQLStatements(repository, variableSpace);
    }

    private Collection<? extends SQLStatement> compatibleGetEntrySQLStatements(JobEntryInterface entry, Repository repository) throws KettleException {
        return entry.getSQLStatements(repository);
    }

    @Deprecated
    public String[] getArguments() {
        return this.arguments;
    }

    @Deprecated
    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes) {
        Object meta;
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchSteps) {
            for (i = 0; i < this.nrJobEntries(); ++i) {
                JobEntryCopy entryMeta = this.getJobEntry(i);
                stringList.add(new StringSearchResult(entryMeta.getName(), entryMeta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.JobEntryName", (String[])new String[0])));
                if (entryMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(entryMeta.getDescription(), entryMeta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.JobEntryDescription", (String[])new String[0])));
                }
                JobEntryInterface metaInterface = entryMeta.getEntry();
                StringSearcher.findMetaData(metaInterface, 1, stringList, entryMeta, this);
            }
        }
        if (searchDatabases) {
            for (i = 0; i < this.nrDatabases(); ++i) {
                meta = this.getDatabase(i);
                stringList.add(new StringSearchResult(meta.getName(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseConnectionName", (String[])new String[0])));
                if (meta.getHostname() != null) {
                    stringList.add(new StringSearchResult(meta.getHostname(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseHostName", (String[])new String[0])));
                }
                if (meta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseName(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseName", (String[])new String[0])));
                }
                if (meta.getUsername() != null) {
                    stringList.add(new StringSearchResult(meta.getUsername(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseUsername", (String[])new String[0])));
                }
                if (meta.getPluginId() != null) {
                    stringList.add(new StringSearchResult(meta.getPluginId(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseTypeDescription", (String[])new String[0])));
                }
                if (meta.getDatabasePortNumberString() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabasePortNumberString(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabasePort", (String[])new String[0])));
                }
                if (meta.getServername() != null) {
                    stringList.add(new StringSearchResult(meta.getServername(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabaseServer", (String[])new String[0])));
                }
                if (meta.getPassword() == null) continue;
                stringList.add(new StringSearchResult(meta.getPassword(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.DatabasePassword", (String[])new String[0])));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                meta = this.getNote(i);
                if (((NotePadMeta)meta).getNote() == null) continue;
                stringList.add(new StringSearchResult(((NotePadMeta)meta).getNote(), meta, this, BaseMessages.getString(PKG, (String)"JobMeta.SearchMetadata.NotepadText", (String[])new String[0])));
            }
        }
        return stringList;
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false);
        ArrayList<String> varList = new ArrayList<String>();
        for (StringSearchResult result : stringList) {
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    public boolean haveJobEntriesChanged() {
        if (this.changedEntries) {
            return true;
        }
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            if (!entry.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveJobHopsChanged() {
        if (this.changedHops) {
            return true;
        }
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String getJobversion() {
        return this.jobVersion;
    }

    public int getJobstatus() {
        return this.jobStatus;
    }

    public void setJobversion(String jobVersion) {
        this.jobVersion = jobVersion;
    }

    public void setJobstatus(int jobStatus) {
        this.jobStatus = jobStatus;
    }

    public static final JobEntryInterface findJobEntry(List<JobEntryInterface> jobentries, ObjectId id_jobentry) {
        if (jobentries == null) {
            return null;
        }
        for (JobEntryInterface je : jobentries) {
            if (je.getObjectId() == null || !je.getObjectId().equals(id_jobentry)) continue;
            return je;
        }
        return null;
    }

    public static final JobEntryCopy findJobEntryCopy(List<JobEntryCopy> jobcopies, ObjectId id_jobentry_copy) {
        if (jobcopies == null) {
            return null;
        }
        for (JobEntryCopy jec : jobcopies) {
            if (jec.getObjectId() == null || !jec.getObjectId().equals(id_jobentry_copy)) continue;
            return jec;
        }
        return null;
    }

    @Override
    public void setInternalKettleVariables(VariableSpace var) {
        boolean hasRepoDir;
        this.setInternalFilenameKettleVariables(var);
        this.setInternalNameKettleVariable(var);
        this.variables.setVariable("Internal.Job.Repository.Directory", this.directory != null ? this.directory.getPath() : "");
        boolean bl = hasRepoDir = this.getRepositoryDirectory() != null && this.getRepository() != null;
        if (hasRepoDir) {
            this.variables.setVariable("Internal.Job.Filename.Directory", this.variables.getVariable("Internal.Job.Repository.Directory"));
        } else {
            this.variables.setVariable("Internal.Job.Repository.Directory", this.variables.getVariable("Internal.Job.Filename.Directory"));
        }
        this.updateCurrentDir();
    }

    private void updateCurrentDir() {
        String prevCurrentDir = this.variables.getVariable("Internal.Entry.Current.Directory");
        String currentDir = this.variables.getVariable(this.repository != null ? "Internal.Job.Repository.Directory" : "Internal.Job.Filename.Directory");
        this.variables.setVariable("Internal.Entry.Current.Directory", currentDir);
        this.fireCurrentDirectoryChanged(prevCurrentDir, currentDir);
    }

    @Override
    protected void setInternalNameKettleVariable(VariableSpace var) {
        this.variables.setVariable("Internal.Job.Name", Const.NVL((String)this.name, (String)""));
    }

    @Override
    protected void setInternalFilenameKettleVariables(VariableSpace var) {
        if (this.filename != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.filename, (VariableSpace)var);
                FileName fileName = fileObject.getName();
                this.variables.setVariable("Internal.Job.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                this.variables.setVariable("Internal.Job.Filename.Directory", fileDir.getURI());
            }
            catch (Exception e) {
                this.variables.setVariable("Internal.Job.Filename.Directory", "");
                this.variables.setVariable("Internal.Job.Filename.Name", "");
            }
        } else {
            this.variables.setVariable("Internal.Job.Filename.Directory", "");
            this.variables.setVariable("Internal.Job.Filename.Name", "");
        }
        this.variables.setVariable("Internal.Entry.Current.Directory", this.variables.getVariable(this.repository != null ? "Internal.Job.Repository.Directory" : "Internal.Job.Filename.Directory"));
    }

    @Deprecated
    public void checkJobEntries(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor) {
        this.checkJobEntries(remarks, only_selected, monitor, this, null, null);
    }

    public void checkJobEntries(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor, VariableSpace space, Repository repository, IMetaStore metaStore) {
        remarks.clear();
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.VerifyingThisJobEntryTask.Title", (String[])new String[0]), this.jobcopies.size() + 2);
        }
        boolean stop_checking = false;
        for (int i = 0; i < this.jobcopies.size() && !stop_checking; ++i) {
            JobEntryInterface entry;
            JobEntryCopy copy = this.jobcopies.get(i);
            if ((!only_selected || only_selected && copy.isSelected()) && (entry = copy.getEntry()) != null) {
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.VerifyingJobEntry.Title", (String[])new String[]{entry.getName()}));
                }
                entry.check(remarks, this, space, repository, metaStore);
                this.compatibleEntryCheck(entry, remarks);
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        stop_checking = true;
                    }
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void compatibleEntryCheck(JobEntryInterface entry, List<CheckResultInterface> remarks) {
        entry.check(remarks, this);
    }

    public List<ResourceReference> getResourceDependencies() {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        JobEntryCopy copy = null;
        JobEntryInterface entry = null;
        for (int i = 0; i < this.jobcopies.size(); ++i) {
            copy = this.jobcopies.get(i);
            entry = copy.getEntry();
            resourceReferences.addAll(entry.getResourceDependencies(this));
        }
        return resourceReferences;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        String resourceName = null;
        try {
            String fullname;
            String baseName;
            String originalPath;
            String extension = "kjb";
            if (Utils.isEmpty((CharSequence)this.getFilename())) {
                originalPath = this.directory.getPath();
                baseName = this.getName();
                fullname = this.directory.getPath() + (this.directory.getPath().endsWith("/") ? "" : "/") + this.getName() + "." + extension;
            } else {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.getFilename()), (VariableSpace)space);
                originalPath = fileObject.getParent().getName().getPath();
                baseName = fileObject.getName().getBaseName();
                fullname = fileObject.getName().getPath();
            }
            resourceName = namingInterface.nameResource(baseName, originalPath, extension, ResourceNamingInterface.FileNamingType.JOB);
            ResourceDefinition definition = definitions.get(resourceName);
            if (definition == null) {
                JobMeta jobMeta = (JobMeta)this.realClone(false);
                jobMeta.setRepositoryDirectory(this.directory);
                for (JobEntryCopy jobEntryCopy : jobMeta.jobcopies) {
                    this.compatibleJobEntryExportResources(jobEntryCopy.getEntry(), jobMeta, definitions, namingInterface, repository);
                    jobEntryCopy.getEntry().exportResources(jobMeta, definitions, namingInterface, repository, metaStore);
                }
                Map<String, String> directoryMap = namingInterface.getDirectoryMap();
                if (directoryMap != null) {
                    for (String directory : directoryMap.keySet()) {
                        String parameterName = directoryMap.get(directory);
                        jobMeta.addParameterDefinition(parameterName, directory, "Data file path discovered during export");
                    }
                }
                String string = jobMeta.getXML();
                definition = new ResourceDefinition(resourceName, string);
                if (Utils.isEmpty((CharSequence)this.getFilename())) {
                    definition.setOrigin(fullname);
                } else {
                    definition.setOrigin(this.getFilename());
                }
                definitions.put(fullname, definition);
            }
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.AnErrorOccuredReadingJob", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        catch (KettleFileException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.AnErrorOccuredReadingJob", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        return resourceName;
    }

    private void compatibleJobEntryExportResources(JobEntryInterface entry, JobMeta jobMeta, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository2) throws KettleException {
        entry.exportResources(jobMeta, definitions, namingInterface, this.repository);
    }

    public void renameJobEntryIfNameCollides(JobEntryCopy je) {
        boolean found;
        String newname = je.getName();
        int nr = 1;
        do {
            found = false;
            for (JobEntryCopy copy : this.jobcopies) {
                if (copy == je || !copy.getName().equalsIgnoreCase(newname) || copy.getNr() != 0) continue;
                found = true;
            }
            if (!found) continue;
            newname = je.getName() + " (" + ++nr + ")";
        } while (found);
        je.setName(newname);
    }

    public List<JobEntryCopy> getJobCopies() {
        return this.jobcopies;
    }

    public List<JobHopMeta> getJobhops() {
        return this.jobhops;
    }

    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public List<JobEntryInterface> composeJobEntryInterfaceList() {
        ArrayList<JobEntryInterface> list = new ArrayList<JobEntryInterface>();
        for (JobEntryCopy copy : this.jobcopies) {
            if (list.contains(copy.getEntry())) continue;
            list.add(copy.getEntry());
        }
        return list;
    }

    public String getLogChannelId() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.JOBMETA;
    }

    public JobEntryLogTable getJobEntryLogTable() {
        return this.jobEntryLogTable;
    }

    public void setJobEntryLogTable(JobEntryLogTable jobEntryLogTable) {
        this.jobEntryLogTable = jobEntryLogTable;
    }

    public List<LogTableInterface> getLogTables() {
        ArrayList<LogTableInterface> logTables = new ArrayList<LogTableInterface>();
        logTables.add(this.jobLogTable);
        logTables.add(this.jobEntryLogTable);
        logTables.add(this.channelLogTable);
        logTables.addAll(this.extraLogTables);
        return logTables;
    }

    public boolean hasRepositoryReferences() {
        for (JobEntryCopy copy : this.jobcopies) {
            if (!copy.getEntry().hasRepositoryReferences()) continue;
            return true;
        }
        return false;
    }

    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        IdNotFoundException lastThrownException = null;
        HashMap<String, RepositoryObjectType> notFoundedReferences = new HashMap<String, RepositoryObjectType>();
        for (JobEntryCopy copy : this.jobcopies) {
            if (!copy.getEntry().hasRepositoryReferences()) continue;
            try {
                copy.getEntry().lookupRepositoryReferences(repository);
            }
            catch (IdNotFoundException e) {
                lastThrownException = e;
                String path = e.getPathToObject();
                String name = e.getObjectName();
                String key = StringUtils.isEmpty((String)path) || path.equals("null") ? name : path + "/" + name;
                notFoundedReferences.put(key, e.getObjectType());
            }
        }
        if (lastThrownException != null && !notFoundedReferences.isEmpty()) {
            throw new LookupReferencesException(lastThrownException, notFoundedReferences);
        }
    }

    public boolean isGatheringMetrics() {
        return false;
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
    }

    public boolean isForcingSeparateLogging() {
        return false;
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
    }

    public List<LogTableInterface> getExtraLogTables() {
        return this.extraLogTables;
    }

    public void setExtraLogTables(List<LogTableInterface> extraLogTables) {
        this.extraLogTables = extraLogTables;
    }

    public boolean containsJobCopy(JobEntryCopy jobCopy) {
        return this.jobcopies.contains(jobCopy);
    }

    public List<MissingEntry> getMissingEntries() {
        return this.missingEntries;
    }

    public void addMissingEntry(MissingEntry missingEntry) {
        if (this.missingEntries == null) {
            this.missingEntries = new ArrayList<MissingEntry>();
        }
        this.missingEntries.add(missingEntry);
    }

    public void removeMissingEntry(MissingEntry missingEntry) {
        if (this.missingEntries != null && missingEntry != null && this.missingEntries.contains(missingEntry)) {
            this.missingEntries.remove(missingEntry);
        }
    }

    @Override
    public boolean hasMissingPlugins() {
        return this.missingEntries != null && !this.missingEntries.isEmpty();
    }

    @Override
    public NamedClusterEmbedManager getNamedClusterEmbedManager() {
        if (this.namedClusterEmbedManager == null) {
            this.namedClusterEmbedManager = new NamedClusterEmbedManager(this, LogChannel.GENERAL);
        }
        return this.namedClusterEmbedManager;
    }

    public String getStartCopyName() {
        return this.startCopyName;
    }

    public void setStartCopyName(String startCopyName) {
        this.startCopyName = startCopyName;
    }

    public boolean isExpandingRemoteJob() {
        return this.expandingRemoteJob;
    }

    public void setExpandingRemoteJob(boolean expandingRemoteJob) {
        this.expandingRemoteJob = expandingRemoteJob;
    }
}

